/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.security;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.UserClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.SECURITY, Category.PERMISSIONS, Category.ISSUES, Category.USER_LOOKUP, Category.TPM})
@RestoreOnce(value="JRASERVER-74869_duplicate_users.zip")
public class TestUserSearchWithDuplicates
extends BaseJiraFuncTest {
    @Test
    public void testCorrectUsersAreAssignable() {
        TestUserSearchWithDuplicates.testUserCandidates(this.backdoor.userClient().getAssignees("crowd", "HSP", "HSP-1", 10));
    }

    @Test
    public void testCorrectUsersAreMentionable() {
        TestUserSearchWithDuplicates.testUserCandidates(this.backdoor.userClient().getMentions("HSP", 10, "crowd"));
    }

    private static void testUserCandidates(List<UserClient.UserCandidate> userCandidates) {
        List userCandidateDisplayNames = userCandidates.stream().map(userCandidate -> userCandidate.displayName).collect(Collectors.toList());
        Assertions.assertThat(userCandidateDisplayNames).containsExactly((Object[])new String[]{"CrowdUser1 UpperDirectory", "CrowdUser3 LowerDirectory"});
    }
}

