/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.security;

import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.SECURITY})
@RestoreBlankInstance
public class TestValidateProject
extends BaseJiraRestTest {
    private String TEST_PROJECT_NAME = "TEST";
    private ProjectValidateClient projectValidateClient;

    @Before
    public void setUp() {
        this.projectValidateClient = new ProjectValidateClient(this.getEnvironmentData());
        this.backdoor.project().addProject(this.TEST_PROJECT_NAME, this.TEST_PROJECT_NAME, "admin");
    }

    @After
    public void tearDown() {
        this.backdoor.project().deleteProject(this.TEST_PROJECT_NAME);
    }

    @Test
    public void testLoggedUserCanValidateProject() throws JSONException {
        this.projectValidateClient.loginAs("admin");
        Response response = this.projectValidateClient.validateKey(this.TEST_PROJECT_NAME);
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        JSONObject jsonResponse = new JSONObject((String)response.readEntity(String.class));
        Assert.assertThat((Object)jsonResponse.getJSONArray("errorMessages"), (Matcher)Matchers.equalTo((Object)new JSONArray()));
        Assert.assertThat((Object)jsonResponse.getJSONObject("errors"), (Matcher)Matchers.equalTo((Object)new JSONObject((Map<String, Object>)ImmutableMap.of((Object)"projectKey", (Object)"Another project uses this project key."))));
    }

    @Test
    public void testAnonymousUserCanNotValidateProject() {
        this.projectValidateClient.anonymous();
        Response response = this.projectValidateClient.validateKey(this.TEST_PROJECT_NAME);
        Assert.assertEquals((long)response.getStatus(), (long)401L);
        String textResponse = (String)response.readEntity(String.class);
        Assert.assertThat((Object)textResponse, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)this.TEST_PROJECT_NAME)));
        Assert.assertThat((Object)textResponse, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"errorMessages")));
        Assert.assertThat((Object)textResponse, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"errors")));
    }

    protected static class ProjectValidateClient
    extends RestApiClient<ProjectValidateClient> {
        public ProjectValidateClient(JIRAEnvironmentData environmentData) {
            super(environmentData);
        }

        private WebTarget getProjectValidateResource() {
            return this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("rest").path("api").path("latest").path("projectvalidate");
        }

        public Response validateKey(String key) {
            return (Response)this.getProjectValidateResource().path("key").queryParam("key", new Object[]{key}).request().get(Response.class);
        }
    }
}

