/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig.framework;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.rule.IssueTypeUrls;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleIssueType;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleProject;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleUser;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;

public abstract class BaseTestWorkflowSchemeResource
extends BaseJiraFuncTest {
    protected static final SimpleProject HSP = new SimpleProject(10000L, "HSP", "homosapien", null, "project for homosapiens");
    protected static final SimpleProject MKY = new SimpleProject(10001L, "MKY", "monkey", null, "project for monkeys");
    protected static final SimpleProject TEST = new SimpleProject(10010L, "TEST", "test", null, null);
    protected static final SimpleProject PROJECT_WITH_DEFAULT_WORKFLOW = new SimpleProject(10110L, "PUDW", "Project Using Default Workflow", null, null);
    protected static final SimpleProject PROJECT_WITHOUT_DEFAULT_WORKFLOW = new SimpleProject(10111L, "PNUDW", "Project Not Using Default Workflow", null, null);
    protected static final SimpleProject PROJECT_WITH_DRAFT_WORKFLOW_SCHEME = new SimpleProject(10210L, "PWDWS", "Project With Draft Workflow Scheme", null, null);
    protected static final SimpleProject PROJECT_USING_DEFAULT_WORKFLOW_SCHEME = new SimpleProject(10310L, "PUDWS", "Project Using Default Workflow Scheme", null, null);
    protected static final SimpleProject PROJECT_NOT_USING_DEFAULT_WORKFLOW_SCHEME = new SimpleProject(10311L, "PNUDWS", "Project Not Using Default Workflow Scheme", null, null);
    protected static final SimpleProject PROJECT_WITH_SHARED_DRAFT_SCHEME = new SimpleProject(10410L, "PWDSBS", "Project With Draft Scheme But Shared", null, null);
    protected static final SimpleProject PROJECT_WITH_WORKFLOW_TO_DELETE = new SimpleProject(10510L, "PWDSWTD", "project with draft scheme and workflow to delete", null, null);
    protected static final String MONKEY_WORKFLOW = "monkey Workflow";
    protected static final String MONKEY_2_WORKFLOW = "monkey 2 Workflow";
    protected static final String PROJECT_NOT_USING_DEFAULT_WORKFLOW_SCHEME_WORKFLOW = "Project Not Using Default Workflow Scheme Workflow";
    protected static final String DEFAULT_WORKFLOW = "jira";
    protected static final SimpleUser ADMIN_USER = new SimpleUser("Administrator", "admin", "", true);
    protected static final String PROJECT_ADMIN_USERNAME = "proj";
    protected IssueTypeUrls issueTypeUrls;

    @Before
    public void setUpTest() {
        this.issueTypeUrls = IssueTypeUrls.init(this.backdoor);
    }

    private String getIssueTypeUrl(String issueTypeName) {
        return this.getIconUrl(this.issueTypeUrls.getIssueTypeUrl(issueTypeName));
    }

    private String getIconUrl(String url) {
        String context = StringUtils.stripToNull((String)this.environmentData.getContext());
        if (context == null) {
            return url;
        }
        return StringUtils.removeEnd((String)context, (String)"/") + url;
    }

    protected SimpleIssueType bug() {
        return new SimpleIssueType(this.getIssueTypeUrl("bug"), "Bug", "A problem which impairs or prevents the functions of the product.", "1", false, false);
    }

    protected SimpleIssueType improvement() {
        return new SimpleIssueType(this.getIssueTypeUrl("improvement"), "Improvement", "An improvement or enhancement to an existing feature or task.", "4", false, false);
    }

    protected SimpleIssueType monkey() {
        return new SimpleIssueType(this.getIssueTypeUrl("monkey"), "Monkey", null, "6", false, false);
    }

    protected SimpleIssueType newFeature() {
        return new SimpleIssueType(this.getIssueTypeUrl("new feature"), "New Feature", "A new feature of the product, which has yet to be developed.", "2", false, false);
    }

    protected SimpleIssueType task() {
        return new SimpleIssueType(this.getIssueTypeUrl("task"), "Task", "A task that needs to be done.", "3", false, false);
    }

    protected SimpleIssueType ignored() {
        return new SimpleIssueType(this.getIssueTypeUrl("ignored"), "Ignored", null, "5", false, false);
    }
}

