/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.projectconfig.framework;

import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.projectconfig.framework.SimpleWorkflowScheme;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class WorkflowSchemeResource
extends RestApiClient<WorkflowSchemeResource> {
    private final String root;

    public WorkflowSchemeResource(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        super((JIRAEnvironmentData)environmentData);
        this.root = environmentData.getBaseUrl().toExternalForm();
    }

    protected WebTarget createResource() {
        return this.resourceRoot(this.root).path("rest").path("projectconfig").path("latest").path("workflowscheme");
    }

    public SimpleWorkflowScheme getWorkflowScheme(String projectKey) {
        return (SimpleWorkflowScheme)this.createResource().path(projectKey).request().get(SimpleWorkflowScheme.class);
    }

    public SimpleWorkflowScheme getOriginalWorkflowScheme(String projectKey) {
        return (SimpleWorkflowScheme)this.createResource().path(projectKey).queryParam("original", new Object[]{Boolean.TRUE.toString()}).request().get(SimpleWorkflowScheme.class);
    }

    public SimpleWorkflowScheme createDraftWorkflowScheme(String projectKey) {
        return (SimpleWorkflowScheme)this.createResource().path(projectKey).request().post(null, SimpleWorkflowScheme.class);
    }

    public SimpleWorkflowScheme discardDraftWorkflowScheme(String projectKey) {
        return (SimpleWorkflowScheme)this.createResource().path(projectKey).request().delete(SimpleWorkflowScheme.class);
    }

    public ParsedResponse createDraftWorkflowSchemeResponse(final String projectKey) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeResource.this.createResource().path(projectKey).request().post(null, Response.class);
            }
        });
    }

    public ParsedResponse getWorkflowResponse(final String projectKey) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeResource.this.createResource().path(projectKey).request().get(Response.class);
            }
        });
    }

    public ParsedResponse discardDraftWorkflowSchemeResponse(final String projectKey) {
        return this.toResponse(new RestApiClient.RestCall(){

            public Response call() {
                return (Response)WorkflowSchemeResource.this.createResource().path(projectKey).request().delete(Response.class);
            }
        });
    }
}

