/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.render;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.Rules;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.webtests.ztests.render.ContentToRender;
import com.atlassian.jira.webtests.ztests.render.RenderersClient;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RunWith(value=Parameterized.class)
public class TestRenderEndpointSecurity
extends BaseJiraRestTest {
    private static final String ADMIN = "admin";
    private static final String ANONYMOUS = "anonymous";
    private static final String BOB = "bob";
    private static final int OK = Response.Status.OK.getStatusCode();
    private static final int NOT_FOUND = Response.Status.NOT_FOUND.getStatusCode();
    private static final String ACCESS_PUBLIC = "should access an issue in a project which has browse project permission granted to anyone.";
    private static final String ACCESS_USER = "should access an issue in a project which has browse project permission granted to logged in users.";
    private static final String ACCESS_ADMIN = "should access an issue in a project which has browse project permission granted to jira-administrators.";
    private static final String ACCESS_ADMIN_SECURITY_LEVEL = "should access an issue which has issue level security set to jira-administrators.";
    private static final String ACCESS_404 = "should get a 404 [Not Found] HTTP error when accessing an issue that doesn't exist.";
    private static final String ACCESS_404_PERMISSION = "should get a 404 [Not Found] HTTP error when accessing an issue without browse project permission.";
    private static final String ACCESS_404_PERMISSION_ADMIN = "should get a 404 [Not Found] HTTP error when accessing a project which has browse project permission granted to jira-administrators.";
    private static final String ACCESS_404_SECURITY_LEVEL_ADMIN = "should get a 404 [Not Found] HTTP error when accessing an issue which has issue level security set to jira-administrators.";
    @Rule
    public TestRule copyAttachmentsRule = Rules.prepareAttachments(this::getEnvironmentData, this::getBackdoor, "TestRenderEndpointSecurity/attachments");
    private final String username;
    private final String issueKey;
    private final int expectedStatusCode;
    private final String testMessage;

    public Backdoor getBackdoor() {
        return this.backdoor;
    }

    @Parameterized.Parameters(name="{3}")
    public static Collection<Object[]> params() {
        return Arrays.asList({ANONYMOUS, "PUB-1", OK, TestRenderEndpointSecurity.format(null, ACCESS_PUBLIC)}, {ANONYMOUS, "PUB-2", OK, TestRenderEndpointSecurity.format(null, ACCESS_PUBLIC)}, {ANONYMOUS, "PUB-3", NOT_FOUND, TestRenderEndpointSecurity.format(null, ACCESS_404)}, {ANONYMOUS, "PRIV-1", NOT_FOUND, TestRenderEndpointSecurity.format(null, ACCESS_404_PERMISSION)}, {ANONYMOUS, "PRIV-2", NOT_FOUND, TestRenderEndpointSecurity.format(null, ACCESS_404_PERMISSION)}, {ANONYMOUS, "PRIV-3", NOT_FOUND, TestRenderEndpointSecurity.format(null, ACCESS_404)}, {ANONYMOUS, "OTH-1", NOT_FOUND, TestRenderEndpointSecurity.format(null, ACCESS_404_PERMISSION)}, {ANONYMOUS, "OTH-2", NOT_FOUND, TestRenderEndpointSecurity.format(null, ACCESS_404_PERMISSION)}, {ANONYMOUS, "OTH-3", NOT_FOUND, TestRenderEndpointSecurity.format(null, ACCESS_404_PERMISSION)}, {ANONYMOUS, "OTH-4", NOT_FOUND, TestRenderEndpointSecurity.format(null, ACCESS_404_PERMISSION)}, {ANONYMOUS, "OTH-5", NOT_FOUND, TestRenderEndpointSecurity.format(null, ACCESS_404)}, {ADMIN, "PUB-1", OK, TestRenderEndpointSecurity.format(ADMIN, ACCESS_PUBLIC)}, {ADMIN, "PUB-2", OK, TestRenderEndpointSecurity.format(ADMIN, ACCESS_PUBLIC)}, {ADMIN, "PUB-3", NOT_FOUND, TestRenderEndpointSecurity.format(ADMIN, ACCESS_404)}, {ADMIN, "PRIV-1", OK, TestRenderEndpointSecurity.format(ADMIN, ACCESS_ADMIN)}, {ADMIN, "PRIV-2", OK, TestRenderEndpointSecurity.format(ADMIN, ACCESS_ADMIN)}, {ADMIN, "PRIV-3", NOT_FOUND, TestRenderEndpointSecurity.format(ADMIN, ACCESS_404)}, {ADMIN, "OTH-1", OK, TestRenderEndpointSecurity.format(ADMIN, ACCESS_ADMIN_SECURITY_LEVEL)}, {ADMIN, "OTH-2", OK, TestRenderEndpointSecurity.format(ADMIN, ACCESS_ADMIN_SECURITY_LEVEL)}, {ADMIN, "OTH-3", OK, TestRenderEndpointSecurity.format(ADMIN, ACCESS_USER)}, {ADMIN, "OTH-4", OK, TestRenderEndpointSecurity.format(ADMIN, ACCESS_USER)}, {ADMIN, "OTH-5", NOT_FOUND, TestRenderEndpointSecurity.format(ADMIN, ACCESS_404)}, {BOB, "PUB-1", OK, TestRenderEndpointSecurity.format(BOB, ACCESS_PUBLIC)}, {BOB, "PUB-2", OK, TestRenderEndpointSecurity.format(BOB, ACCESS_PUBLIC)}, {BOB, "PUB-3", NOT_FOUND, TestRenderEndpointSecurity.format(BOB, ACCESS_404)}, {BOB, "PRIV-1", NOT_FOUND, TestRenderEndpointSecurity.format(BOB, ACCESS_404_PERMISSION_ADMIN)}, {BOB, "PRIV-2", NOT_FOUND, TestRenderEndpointSecurity.format(BOB, ACCESS_404_PERMISSION_ADMIN)}, {BOB, "PRIV-3", NOT_FOUND, TestRenderEndpointSecurity.format(BOB, ACCESS_404)}, {BOB, "OTH-1", NOT_FOUND, TestRenderEndpointSecurity.format(BOB, ACCESS_404_SECURITY_LEVEL_ADMIN)}, {BOB, "OTH-2", NOT_FOUND, TestRenderEndpointSecurity.format(BOB, ACCESS_404_SECURITY_LEVEL_ADMIN)}, {BOB, "OTH-3", OK, TestRenderEndpointSecurity.format(BOB, ACCESS_USER)}, {BOB, "OTH-4", OK, TestRenderEndpointSecurity.format(BOB, ACCESS_USER)}, {BOB, "OTH-5", NOT_FOUND, TestRenderEndpointSecurity.format(BOB, ACCESS_404)});
    }

    public TestRenderEndpointSecurity(String username, String issueKey, int expectedStatusCode, String testMessage) {
        this.username = username;
        this.issueKey = issueKey;
        this.expectedStatusCode = expectedStatusCode;
        this.testMessage = testMessage;
    }

    private static String format(String user, String message) {
        return user == null ? String.format("Anonymous user %s", message) : String.format("User '%s' %s", user, message);
    }

    private RenderersClient getClient() {
        return ADMIN.equals(this.username) || BOB.equals(this.username) ? (RenderersClient)new RenderersClient(this.getEnvironmentData()).loginAs(this.username) : (RenderersClient)new RenderersClient(this.getEnvironmentData()).anonymous();
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    @Restore(value="TestRenderEndpointSecurity.xml")
    public void checkRenderEndpoint() {
        ParsedResponse rendered = this.getClient().render(ContentToRender.fromWikiMarkup(String.format("[^%s.txt]", this.issueKey.toLowerCase()), this.issueKey));
        Assert.assertEquals((String)this.testMessage, (long)this.expectedStatusCode, (long)rendered.statusCode);
        if (this.expectedStatusCode == NOT_FOUND) {
            Assert.assertEquals((String)"Render endpoint should give a proper message when responding with 404.", (Object)"<h1>You can't view this issue</h1><p><span class=\"error\">It may have been deleted or you don't have permission to view it.</span></p>", rendered.entity.errorMessages.get(0));
        }
    }
}

