/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.resources;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.HTTP})
@LoginAs(user="admin")
public class ResourceHeadersTest
extends BaseJiraFuncTest {
    @Inject
    private FuncTestRestClient restClient;
    private static final String X_AUSERNAME = "X-AUSERNAME";
    private static final String CONTENT_SECURITY_POLICY = "Content-Security-Policy";
    private static final String CSP_SANDBOX = "sandbox";
    private static final String JS_REST_RESOURCE = "/rest/func-test/1.0/resources/fetchJsResponse.js";
    private static final String JS_STATIC_RESOURCE = "/s/anotherRandomCDNHash/-hash/buildNumber/randomHash/version/_/download/batch/jira.webresources:calendar-en/jira.webresources:calendar-en.js";
    private static final String CSS_STATIC_RESOURCE = "/s/randomCDNHash/-hash/buildNumber/randomHash/version/_/download/batch/com.atlassian.jira.gadgets:core-gadget-resources/com.atlassian.jira.gadgets:core-gadget-resources.css";
    private static final String NON_CACHEABLE = "secure/Dashboard.jspa";

    @Test
    public void testIfJsResourceFromRestPathDoesntHaveUserNameHeader() {
        WebResponse webResponse = this.doGet(JS_REST_RESOURCE);
        Assert.assertNull((Object)webResponse.getHeaderField(X_AUSERNAME));
    }

    @Test
    public void testIfJsResourceFromRestPathDoesntHaveSandboxContentSecurityPolicyHeader() {
        WebResponse webResponse = this.doGet(JS_REST_RESOURCE);
        Assert.assertNotEquals((Object)CSP_SANDBOX, (Object)webResponse.getHeaderField(CONTENT_SECURITY_POLICY));
    }

    @Test
    public void testIfJsResourceFromStaticPathDoesntHaveUserNameHeader() {
        WebResponse webResponse = this.doGet(JS_STATIC_RESOURCE);
        Assert.assertNull((Object)webResponse.getHeaderField(X_AUSERNAME));
    }

    @Test
    public void testIfJsResourceFromStaticPathDoesntHaveUserSandboxContentSecurityPolicyHeader() {
        WebResponse webResponse = this.doGet(JS_STATIC_RESOURCE);
        Assert.assertNotEquals((Object)CSP_SANDBOX, (Object)webResponse.getHeaderField(CONTENT_SECURITY_POLICY));
    }

    @Test
    public void testIfCSSResourceFromStaticPathDoesntHaveUserNameHeader() {
        WebResponse webResponse = this.doGet(CSS_STATIC_RESOURCE);
        Assert.assertNull((Object)webResponse.getHeaderField(X_AUSERNAME));
    }

    @Test
    public void testIfCSSResourceFromStaticPathHasSandboxContentSecurityPolicyHeader() {
        WebResponse webResponse = this.doGet(CSS_STATIC_RESOURCE);
        Assert.assertEquals((Object)CSP_SANDBOX, (Object)webResponse.getHeaderField(CONTENT_SECURITY_POLICY));
    }

    @Test
    public void testIfOtherNonCachableResourcehasUserNameHeader() {
        WebResponse webResponse = this.doGet(NON_CACHEABLE);
        Assert.assertEquals((Object)webResponse.getHeaderField(X_AUSERNAME), (Object)"admin");
    }

    private WebResponse doGet(String path) {
        try {
            return this.restClient.GET(path);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

