/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.scheduler;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.EventClient;
import com.atlassian.jira.functest.framework.backdoor.SchedulerControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.scheduler.config.RunMode;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST})
@RestoreBlankInstance
public class TestScheduler
extends BaseJiraFuncTest {
    private static final String SCHEDULED_EVENT_NAME = "com.atlassian.jira.dev.backdoor.SchedulerBackdoor$ScheduledTestJobExecutedEvent";

    @Test
    public void shouldScheduleClusterJobWithCustomParameters() {
        this.testSchedulerWith(RunMode.RUN_ONCE_PER_CLUSTER);
    }

    @Test
    public void shouldScheduleLocalJobWithCustomParameters() {
        this.testSchedulerWith(RunMode.RUN_LOCALLY);
    }

    private void testSchedulerWith(RunMode mode) {
        EventClient.EventPoller poller = this.backdoor.events().createPoller();
        SchedulerControl.JobBean jobBean = this.backdoor.scheduler().scheduleJob(mode);
        MatcherAssert.assertThat((Object)jobBean.runnable, (Matcher)Matchers.is((Object)true));
        Awaitility.await().atMost(Duration.TEN_SECONDS).until(poller::events, Matchers.hasItem((Object)SCHEDULED_EVENT_NAME));
    }
}

