/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.screens.tabs;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Node;

@Ignore(value="MNSTR-1148 Abstract class should not be instantiated")
public abstract class AbstractTestFieldScreenTabs
extends BaseJiraFuncTest {
    private static final String CLASS_HAS_ERRORS = "has-errors";
    private static final String ORIGINAL_ESTIMATE_ERROR_MESSAGE = "The original estimate specified is not valid.";
    private static final String REMAINING_ESTIMATE_ERROR_MESSAGE = "The remaining estimate specified is not valid.";
    private static final String TIME_LOGGED_ERROR_MESSAGE = "Invalid time duration entered.";
    @Inject
    private TimeTracking timeTracking;
    @Inject
    private HtmlPage page;
    @Inject
    private TextAssertions textAssertions;

    protected abstract void gotoTabScreenForIssueWithNoWork();

    protected abstract void gotoTabScreenForIssueWithWorkStarted();

    protected boolean canShowScreenForIssueWithWork() {
        return true;
    }

    protected String[] getFieldsInFirstTab() {
        return new String[]{"Summary", "Issue Type", "Priority"};
    }

    @Before
    public void setUpDataAndDisableJsReporterField() {
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.reporter.field");
    }

    @After
    public void restoreJsReporterFieldSetting() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.reporter.field");
    }

    @Test
    @LoginAs(user="admin")
    public void testErrorsForTimeTrackingAndWorklog() throws Exception {
        this.navigation.gotoDashboard();
        this.testErrorsForTimeTrackingAndWorklog_LegacyModeWorkNotStarted();
        if (this.canShowScreenForIssueWithWork()) {
            this.testErrorsForTimeTrackingAndWorklog_LegacyModeWorkStarted();
        }
        this.testErrorsForTimeTrackingAndWorklog_ModernMode();
    }

    private void testErrorsForTimeTrackingAndWorklog_LegacyModeWorkNotStarted() {
        this.gotoTabScreenForIssueWithNoWork();
        this.tester.setFormElement("timetracking", "xxx");
        this.tester.setFormElement("worklog_timeLogged", "5m");
        this.tester.submit();
        this.assertErrorAppearsOnTimeTrackingTab(ORIGINAL_ESTIMATE_ERROR_MESSAGE);
        this.tester.setFormElement("timetracking", "5h");
        this.tester.setFormElement("worklog_timeLogged", "yyy");
        this.tester.submit();
        this.assertErrorAppearsOnWorkLogTab(TIME_LOGGED_ERROR_MESSAGE);
    }

    private void testErrorsForTimeTrackingAndWorklog_LegacyModeWorkStarted() {
        this.gotoTabScreenForIssueWithWorkStarted();
        this.tester.setFormElement("timetracking", "xxx");
        this.tester.setFormElement("worklog_timeLogged", "5m");
        this.tester.submit();
        this.assertErrorAppearsOnWorkLogTab(REMAINING_ESTIMATE_ERROR_MESSAGE);
        this.tester.setFormElement("timetracking", "5h");
        this.tester.setFormElement("worklog_timeLogged", "yyy");
        this.tester.checkCheckbox("worklog_activate", "true");
        this.tester.submit();
        this.assertErrorAppearsOnWorkLogTab(TIME_LOGGED_ERROR_MESSAGE);
    }

    private void testErrorsForTimeTrackingAndWorklog_ModernMode() {
        this.enableModernMode();
        this.gotoTabScreenForIssueWithNoWork();
        this.tester.setFormElement("timetracking_originalestimate", "xxx");
        this.tester.setFormElement("timetracking_remainingestimate", "4m");
        this.tester.setFormElement("worklog_timeLogged", "5m");
        this.tester.submit();
        this.assertErrorAppearsOnTimeTrackingTab(ORIGINAL_ESTIMATE_ERROR_MESSAGE);
        this.tester.setFormElement("timetracking_originalestimate", "5h");
        this.tester.setFormElement("timetracking_remainingestimate", "zzz");
        this.tester.setFormElement("worklog_timeLogged", "2h");
        this.tester.submit();
        this.assertErrorAppearsOnWorkLogTab(REMAINING_ESTIMATE_ERROR_MESSAGE);
        this.tester.checkCheckbox("worklog_activate", "true");
        this.tester.setFormElement("timetracking_originalestimate", "5h");
        this.tester.setFormElement("timetracking_remainingestimate", "15m");
        this.tester.setFormElement("worklog_timeLogged", "xxx");
        this.tester.submit();
        this.assertErrorAppearsOnWorkLogTab(TIME_LOGGED_ERROR_MESSAGE);
    }

    private void assertErrorAppearsOnWorkLogTab(String errorMessage) {
        this.assertTabIsSelected("Tab 2");
        this.assertTabsHaveErrors("Tab 2");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tab2"), errorMessage);
    }

    private void assertErrorAppearsOnTimeTrackingTab(String errorMessage) {
        this.assertTabIsSelected("Tab 4");
        this.assertTabsHaveErrors("Tab 4");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tab4"), errorMessage);
    }

    @Test
    @LoginAs(user="admin")
    public void testErrorsOnMultipleTabs() throws Exception {
        this.navigation.gotoDashboard();
        this.gotoTabScreenForIssueWithNoWork();
        this.tester.setFormElement("duedate", "xxx");
        this.tester.setFormElement("reporter", "yyy");
        this.tester.setFormElement("timetracking", "zzz");
        this.tester.submit();
        this.assertTabsDontHaveErrors("Field Tab");
        this.assertTabsHaveErrors("Tab 2", "Tab 3", "Tab 4");
        this.assertTabIsSelected("Tab 2");
        this.tester.setFormElement("duedate", "");
        this.tester.submit();
        this.assertTabsDontHaveErrors("Field Tab", "Tab 2");
        this.assertTabsHaveErrors("Tab 3", "Tab 4");
        this.assertTabIsSelected("Tab 3");
    }

    @Test
    @LoginAs(user="admin")
    public void testPresentationOfTabs() throws Exception {
        this.navigation.gotoDashboard();
        this.gotoTabScreenForIssueWithNoWork();
        this.assertFieldsInTabsForLegacyModeWorkNotStarted();
        this.enableModernMode();
        this.gotoTabScreenForIssueWithNoWork();
        this.assertFieldsInTabsForModernMode();
        if (this.canShowScreenForIssueWithWork()) {
            this.enableLegacyMode();
            this.gotoTabScreenForIssueWithWorkStarted();
            this.assertFieldsInTabsForLegacyModeWorkStarted();
            this.enableModernMode();
            this.gotoTabScreenForIssueWithWorkStarted();
            this.assertFieldsInTabsForModernMode();
        }
    }

    private void assertFieldsInTabsForLegacyModeWorkNotStarted() {
        this.assertFieldsInTab("tab1", this.getFieldsInFirstTab());
        this.assertFieldsInTab("tab2", "Time Spent", "Date Started", "Remaining Estimate", "Affects Version/s", "Component/s", "Due Date");
        this.assertFieldsInTab("tab3", "Environment", "Reporter", "Assignee", "Fix Version/s");
        this.assertFieldsInTab("tab4", "Labels", "Original Estimate", "Description");
    }

    private void assertFieldsInTabsForLegacyModeWorkStarted() {
        this.assertFieldsInTab("tab1", this.getFieldsInFirstTab());
        this.assertFieldsInTab("tab2", "Log work", "Remaining Estimate", "Affects Version/s", "Component/s", "Due Date");
        this.assertFieldsInTab("tab3", "Environment", "Reporter", "Assignee", "Fix Version/s");
        this.assertFieldsInTab("tab4", "Labels", "Description");
    }

    private void assertFieldsInTabsForModernMode() {
        this.assertFieldsInTab("tab1", this.getFieldsInFirstTab());
        this.assertFieldsInTab("tab2", "Log work", "Remaining Estimate", "Affects Version/s", "Component/s", "Due Date");
        this.assertFieldsInTab("tab3", "Environment", "Reporter", "Assignee", "Fix Version/s");
        this.assertFieldsInTab("tab4", "Labels", "Original Estimate", "Description");
    }

    private void enableModernMode() {
        this.timeTracking.disable();
        this.timeTracking.enable(TimeTracking.Mode.MODERN);
    }

    private void enableLegacyMode() {
        this.timeTracking.disable();
        this.timeTracking.enable(TimeTracking.Mode.LEGACY);
    }

    private void assertTabsDontHaveErrors(String ... tabNames) {
        for (String tabName : tabNames) {
            Assert.assertFalse((String)("Tab with name '" + tabName + "' had error class"), (boolean)this.page.getLinksWithExactText(tabName)[0].getClassName().contains(CLASS_HAS_ERRORS));
        }
    }

    private void assertTabsHaveErrors(String ... tabNames) {
        for (String tabName : tabNames) {
            Assert.assertEquals((String)("Tab with name '" + tabName + "' did not have error class"), (Object)CLASS_HAS_ERRORS, (Object)this.page.getLinksWithExactText(tabName)[0].getClassName());
        }
    }

    private void assertTabIsSelected(String tabName) {
        XPathLocator locator = new XPathLocator(this.tester, String.format("//li[@class='menu-item active-tab']/a/strong[contains(text(), '%s')]", tabName));
        Node[] nodes = locator.getNodes();
        Assert.assertTrue((String)("Could not find tab with name '" + tabName + "' that was selected."), (nodes != null && nodes.length == 1 ? 1 : 0) != 0);
    }

    private void assertFieldsInTab(String tabId, String ... fields) {
        IdLocator tabContainerLocator = new IdLocator(this.tester, tabId);
        this.textAssertions.assertTextSequence(tabContainerLocator, fields);
    }
}

