/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security.properties;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.SecurityPropertiesDaoControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.base.Strings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestSecurityPropertiesDao
extends BaseJiraFuncTest {
    SecurityPropertiesDaoControl securityPropertiesDaoControl;
    private final String key = Strings.repeat((String)"A", (int)255);
    private final String secret = Strings.repeat((String)"X", (int)4000);
    private final String secret2 = Strings.repeat((String)"Y", (int)4000);

    @Before
    public void setUpTest() {
        this.securityPropertiesDaoControl = new SecurityPropertiesDaoControl(this.getEnvironmentData());
    }

    @Test
    public void testGetOrCreate() throws Exception {
        this.securityPropertiesDaoControl.delete(this.key);
        Assert.assertEquals((Object)"", (Object)this.securityPropertiesDaoControl.get(this.key));
        this.securityPropertiesDaoControl.getOrCreate(this.key, this.secret);
        Assert.assertEquals((Object)this.secret, (Object)this.securityPropertiesDaoControl.get(this.key));
    }

    @Test
    public void testGetOrCreateTwice() throws Exception {
        this.securityPropertiesDaoControl.delete(this.key);
        this.securityPropertiesDaoControl.getOrCreate(this.key, this.secret);
        Assert.assertEquals((Object)this.secret, (Object)this.securityPropertiesDaoControl.get(this.key));
        this.securityPropertiesDaoControl.getOrCreate(this.key, this.secret2);
        Assert.assertEquals((Object)this.secret, (Object)this.securityPropertiesDaoControl.get(this.key));
    }

    @Test
    public void testGetOrCreateTwiceWithDelete() throws Exception {
        this.securityPropertiesDaoControl.delete(this.key);
        this.securityPropertiesDaoControl.getOrCreate(this.key, this.secret);
        Assert.assertEquals((Object)this.secret, (Object)this.securityPropertiesDaoControl.get(this.key));
        this.securityPropertiesDaoControl.delete(this.key);
        this.securityPropertiesDaoControl.getOrCreate(this.key, this.secret2);
        Assert.assertEquals((Object)this.secret2, (Object)this.securityPropertiesDaoControl.get(this.key));
    }

    @Test
    public void testGetDontCreateIfAbsent() throws Exception {
        this.securityPropertiesDaoControl.delete(this.key);
        Assert.assertEquals((Object)"", (Object)this.securityPropertiesDaoControl.get(this.key));
        this.securityPropertiesDaoControl.getButDoNotCreate(this.key);
        Assert.assertEquals((Object)"", (Object)this.securityPropertiesDaoControl.get(this.key));
    }

    @Test
    public void testGetDontCreateIfPresent() throws Exception {
        this.securityPropertiesDaoControl.delete(this.key);
        this.securityPropertiesDaoControl.getOrCreate(this.key, this.secret);
        Assert.assertEquals((Object)this.secret, (Object)this.securityPropertiesDaoControl.get(this.key));
        this.securityPropertiesDaoControl.getButDoNotCreate(this.key);
        Assert.assertEquals((Object)this.secret, (Object)this.securityPropertiesDaoControl.get(this.key));
    }

    @Test
    public void testDelete() throws Exception {
        this.securityPropertiesDaoControl.getOrCreate(this.key, this.secret);
        Assert.assertNotEquals((Object)"", (Object)this.securityPropertiesDaoControl.get(this.key));
        this.securityPropertiesDaoControl.delete(this.key);
        Assert.assertEquals((Object)"", (Object)this.securityPropertiesDaoControl.get(this.key));
    }
}

