/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.sendheadearly;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.HTTP})
@LoginAs(user="admin")
public class TestSendHeadEarly
extends BaseJiraFuncTest {
    private static final FeatureFlag SEND_HEAD_EARLY_FOR_DASHBOARD_DISABLE_FF = FeatureFlag.featureFlag((String)"com.atlassian.plugins.dashboard.SEND_HEAD_EARLY.disabled");
    private static final FeatureFlag DEFER_SCRIPTS_ON_DASHBOARD_DISABLE_FF = FeatureFlag.featureFlag((String)"com.atlassian.plugins.dashboard.DEFER_SCRIPTS.disabled");

    @Test
    public void testDashboard() {
        this.compareEnabledVsDisabled("/secure/Dashboard.jspa");
    }

    private void compareEnabledVsDisabled(String url) {
        this.navigation.login("admin", "admin");
        PageResult disabledResponse = this.getPageResultWithFlushHeadEarlyAndDeferringDisabled(url);
        PageResult enabledResponse = this.getPage(url);
        Assert.assertEquals((Object)disabledResponse.content, (Object)enabledResponse.content);
        Assert.assertEquals((Object)disabledResponse.titleTag, (Object)enabledResponse.titleTag);
        Assert.assertEquals((Object)disabledResponse.osdTag, (Object)enabledResponse.osdTag);
    }

    private PageResult getPageResultWithFlushHeadEarlyAndDeferringDisabled(String url) {
        PageResult disabledResponse;
        try {
            this.backdoor.darkFeatures().enableForSite(SEND_HEAD_EARLY_FOR_DASHBOARD_DISABLE_FF);
            this.backdoor.darkFeatures().enableForSite(DEFER_SCRIPTS_ON_DASHBOARD_DISABLE_FF);
            disabledResponse = this.getPage(url);
        }
        finally {
            this.backdoor.darkFeatures().disableForSite(SEND_HEAD_EARLY_FOR_DASHBOARD_DISABLE_FF);
            this.backdoor.darkFeatures().disableForSite(DEFER_SCRIPTS_ON_DASHBOARD_DISABLE_FF);
        }
        return disabledResponse;
    }

    private PageResult getPage(String url) {
        String[] patterns;
        String[] selectors;
        this.tester.gotoPage(url);
        String response = this.tester.getDialog().getResponseText();
        Document doc = Jsoup.parse((String)response);
        Element titleElement = doc.select("title").first();
        String title = titleElement.outerHtml();
        titleElement.remove();
        Element osdElement = doc.select("link[rel=search][type*=opensearchdescription]").first();
        String osd = osdElement.outerHtml();
        osdElement.remove();
        for (String selector : selectors = new String[]{"meta[name=ajs-enabled-dark-features]", "form#jira_request_timing_info", "script:not([src])"}) {
            doc.select(selector).remove();
        }
        String filteredResponse = doc.outerHtml();
        for (String pattern : patterns = new String[]{"AG\\.DashboardManager\\.setup\\(\\{.*?\\}\\);", "<!--\\s+REQUEST ID.*?-->", "\\\\\\\"com\\.atlassian\\.plugins\\.dashboard\\.SEND_HEAD_EARLY\\.disabled\\\\\\\",", "WRM._unparsedData\\[\"jira.request.correlation-id\"]=\"\\\\\"[a-z0-9_]+\\\\\"\";", "view-params=[a-z%0-9_]+", "st=[a-z%0-9_]+"}) {
            filteredResponse = TestSendHeadEarly.replace(pattern, filteredResponse);
        }
        filteredResponse = filteredResponse.replaceAll("\\s+", " ");
        return new PageResult(filteredResponse, title, osd);
    }

    private static String replace(String pattern, String response) {
        Pattern regex = Pattern.compile(pattern, 34);
        return regex.matcher(response).replaceAll("");
    }

    private static final class PageResult {
        private final String content;
        private final String titleTag;
        private final String osdTag;

        private PageResult(String content, String titleTag, String osdTag) {
            this.content = content;
            this.titleTag = titleTag;
            this.osdTag = osdTag;
        }
    }
}

