/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.servermetrics;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.EventClient;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.RegexMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@LoginAs(user="admin")
public class TestServerMetricsEvents
extends BaseJiraFuncTest {
    private static final String CORRELATION_ID_VARIABLE = "jira.request.correlation-id";

    @Test
    public void shouldPublishServerMetricsEvents() {
        EventClient.EventPoller events = this.backdoor.events().createPoller();
        this.navigation.gotoDashboard();
        Iterable<String> allEvents = events.events();
        Assert.assertThat(allEvents, (Matcher)Matchers.hasItem((Object)"com.atlassian.jira.servermetrics.RequestMetricsEvent"));
    }

    @Test
    public void correlationIdIsTransferredToClient() {
        this.tester.gotoPage("/secure/Dashboard.jspa");
        String response = this.tester.getDialog().getResponseText();
        String requestCorrelationIdSetup = "WRM._unparsedData\\[\"jira.request.correlation-id\"]=\"\\\\u0022[a-z0-9_]+\\\\u0022\";";
        Assert.assertThat((Object)response, (Matcher)RegexMatchers.regexMatches((String)"WRM._unparsedData\\[\"jira.request.correlation-id\"]=\"\\\\u0022[a-z0-9_]+\\\\u0022\";"));
    }
}

