/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.statistics;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Collection;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
@Restore(value="blankprojects.xml")
public class TestProjectStatisticsManager
extends BaseJiraRestTest {
    public static final String ISSUE_TYPE_BUG = "1";
    public static final String ISSUE_TYPE_FEATURE = "2";
    public static final String MAJOR_PRIORITY_ID = "3";
    @Inject
    private Backdoor backdoor;

    @Test
    public void testCorrectProjectsEmptyJQL() {
        String jql = "";
        Collection<String> result = this.backdoor.statisticsControl().getProjectsResultingFrom();
        Assert.assertThat(result, (Matcher)IsCollectionWithSize.hasSize((int)0));
        result = this.backdoor.statisticsControl().getProjectsResultingFrom("");
        Assert.assertThat(result, (Matcher)IsCollectionWithSize.hasSize((int)0));
        this.backdoor.issues().createIssue("HSP", "New issue for the HSP project");
        result = this.backdoor.statisticsControl().getProjectsResultingFrom("");
        Assert.assertThat(result, (Matcher)IsCollectionContaining.hasItem((Object)"HSP"));
        this.backdoor.issues().createIssue("MKY", "New issue for the MKY project");
        result = this.backdoor.statisticsControl().getProjectsResultingFrom("");
        Assert.assertThat(result, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"HSP", "MKY"}));
    }

    @Test
    public void testCorrectProjectsWithAmbiguousJQL() {
        String jql = "issuetype = Bug";
        Collection<String> result = this.backdoor.statisticsControl().getProjectsResultingFrom("issuetype = Bug");
        Assert.assertThat(result, (Matcher)IsCollectionWithSize.hasSize((int)0));
        this.backdoor.issues().createIssue("HSP", "It's a bug", null, MAJOR_PRIORITY_ID, ISSUE_TYPE_BUG);
        result = this.backdoor.statisticsControl().getProjectsResultingFrom("issuetype = Bug");
        Assert.assertThat(result, (Matcher)IsCollectionContaining.hasItem((Object)"HSP"));
        this.backdoor.issues().createIssue("MKY", "It's not a bug, it's a feature", null, MAJOR_PRIORITY_ID, ISSUE_TYPE_FEATURE);
        result = this.backdoor.statisticsControl().getProjectsResultingFrom("issuetype = Bug");
        Assert.assertThat(result, (Matcher)IsCollectionContaining.hasItem((Object)"HSP"));
    }

    @Test
    public void testCorrectProjectsWithExplicitProjectsJQL() {
        String jql = "Project = MKY";
        Collection<String> result = this.backdoor.statisticsControl().getProjectsResultingFrom("Project = MKY");
        Assert.assertThat(result, (Matcher)IsCollectionWithSize.hasSize((int)0));
        this.backdoor.issues().createIssue("HSP", "It's a bug", null, MAJOR_PRIORITY_ID, ISSUE_TYPE_BUG);
        result = this.backdoor.statisticsControl().getProjectsResultingFrom("Project = MKY");
        Assert.assertThat(result, (Matcher)IsCollectionWithSize.hasSize((int)0));
        this.backdoor.issues().createIssue("MKY", "It's not a bug, it's a feature", null, MAJOR_PRIORITY_ID, ISSUE_TYPE_FEATURE);
        result = this.backdoor.statisticsControl().getProjectsResultingFrom("Project = MKY");
        Assert.assertThat(result, (Matcher)IsCollectionContaining.hasItem((Object)"MKY"));
    }
}

