/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
@LoginAs(user="admin")
public class TestClosedParent
extends BaseJiraFuncTest {
    @Inject
    private WorkflowUtil workflowUtil;

    @Test
    @Restore(value="TestCantCreateSubtaskWhenParentClosed.xml")
    public void testCantCreateSubtaskWhenParentClosed() {
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.navigation.issue().viewIssue("HSP-3");
        this.tester.assertLinkPresent("create-subtask");
        this.tester.assertTextNotPresent("Closed");
        this.workflowUtil.clickAction("action_id_2");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertTextPresent("Closed");
        this.tester.assertLinkNotPresent("create-subtask");
    }

    @Test
    @Restore(value="TestCantCreateSubtaskWhenParentClosed.xml")
    public void testCantCloseParentWithOpenSubTasks() {
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertTextPresent("Open");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertTextPresent("Open");
        this.tester.assertLinkNotPresentWithText("Close Issue");
        this.navigation.issue().viewIssue("HSP-2");
        this.workflowUtil.clickAction("action_id_2");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        MatcherAssert.assertThat(this.workflowUtil.queryAvailableWorkflowActionNames("HSP-1"), (Matcher)Matchers.hasItem((Object)"Close Issue"));
    }

    @Test
    @Restore(value="TestConvertIssueToSubtask.xml")
    public void testConvertIssueToSubtask() {
        this.navigation.issue().viewIssue("HSP-3");
        this.tester.clickLinkWithText("Convert");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("parentIssueKey", "HSP-1");
        this.tester.submit();
        this.tester.assertTextPresent("The issue HSP-1 is not editable.");
    }

    @Test
    @Restore(value="TestMoveSubtaskToClosedParent.xml")
    public void testMoveSubtaskToClosedParent() {
        this.navigation.issue().viewIssue("HSP-4");
        this.tester.clickLink("move-subtask");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("operation", "move.subtask.parent.operation.name");
        this.tester.submit();
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("parentIssue", "HSP-1");
        this.tester.submit();
        this.tester.assertTextPresent("The new parent issue HSP-1 is not editable.");
    }

    @Test
    @Restore(value="TestCantChangeAssigneeWhenIssueIsClosed.xml")
    public void testCantChangeAssigneeWhenIssueIsClosed() {
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertLinkNotPresentWithText("Assign");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertLinkNotPresentWithText("Assign");
        this.navigation.issue().viewIssue("HSP-1");
        this.workflowUtil.clickAction("action_id_3");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertLinkPresentWithText("Assign");
        this.navigation.issue().viewIssue("HSP-2");
        this.workflowUtil.clickAction("action_id_3");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertLinkPresentWithText("Assign");
    }
}

