/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.AssertRedirect;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperationProgress;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import java.io.IOException;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
@LoginAs(user="admin")
public class TestCreateSubTasks
extends BaseJiraFuncTest {
    private static final String PROJECT_MONKEY_ID = "10001";
    @Inject
    private AssertRedirect assertRedirect;
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private BulkOperationProgress bulkOperationProgress;

    @After
    public void tearDown() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.reporter.field");
    }

    @Test
    public void testCreateSubTaskInJiraWithSingleSubTaskType() {
        this.administration.restoreData("TestOneProjectWithOneIssueType.xml");
        this.administration.project().addProject("neanderthal", "NEA", "admin");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Bugs & Sub-tasks");
        this.tester.submit();
        this.navigation.issue().createIssue("homosapien", "Bug", "First issue");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("create-subtask");
        this.tester.assertTextNotPresent("Choose the project and issue type");
        this.tester.assertTextPresent("Create Sub-Task");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Project", "homosapien", "Issue Type", "Sub-task"});
        this.tester.assertFormElementPresent("summary");
    }

    @Test
    public void testCreateSubTasks() {
        this.administration.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.administration.project().addProject("neanderthal", "NDT", "admin");
        this.administration.subtasks().addSubTaskType("Custom Sub Task", "Custom Sub Task");
        this.editIssueFieldVisibility.resetFields();
        String issueKeyNormal = this.navigation.issue().createIssue("homosapien", "Bug", "test for sub tasks");
        this.subTasksWithSubTasksEnabled(issueKeyNormal);
        this.subTasksCreateSubTaskWithCustonType(issueKeyNormal);
        this.subTasksWithCreatePermission(issueKeyNormal);
        this.subTaskWithNoSummary(issueKeyNormal);
        this.subTaskWithRequiredFields(issueKeyNormal);
        this.subTaskWithHiddenFields(issueKeyNormal);
        this.subTaskWithInvalidDueDate(issueKeyNormal);
        this.subTaskWithSchedulePermission(issueKeyNormal);
        this.subTaskWithAssignPermission(issueKeyNormal);
        this.subTaskWithModifyReporterPermission(issueKeyNormal);
        this.subTaskWithTimeTracking(issueKeyNormal);
        this.subTaskWithUnassignableUser(issueKeyNormal);
        this.subTaskMoveIssueWithSubTask(issueKeyNormal);
        this.navigation.issue().deleteIssue(issueKeyNormal);
    }

    @Test
    public void testCreateSubtaskSkipStep1OnlyOneProjectAndOneIssueType() {
        this.administration.restoreData("TestCreateSubtaskOneProjectOneSubtaskType.xml");
        this.assertRedirect.assertRedirectAndFollow("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000", ".*CreateSubTaskIssue\\.jspa\\?parentIssueId=10000&pid=10001&issuetype=4$");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Create Sub-Task", "Project", "monkey", "Issue Type", "Sub-task", "Summary"});
    }

    @Test
    public void testCreateSubtaskStep1ShowsCorrectIssueTypes() {
        this.administration.restoreData("IssuesWithSubTasksWorkflowScheme.xml");
        this.tester.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000");
        Stream.of("issuetype-options", "Sub Task", "Super Sub Task", "Mega Sub Task").forEach(this.textAssertions::assertTextPresent);
    }

    @Test
    public void testCreateIssueSkipStep1IssueTypeSchemeInfersOneProjectAndIssueType() {
        this.administration.restoreData("TestCreateMonkeyHasOneIssueType.xml");
        this.assertRedirect.assertRedirectAndFollow("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000", ".*CreateSubTaskIssue\\.jspa\\?parentIssueId=10000&pid=10001&issuetype=5$");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Create Sub-Task", "Project", "monkey", "Issue Type", "Sub-task", "Summary"});
        this.tester.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10001");
        this.tester.assertFormPresent("subtask-create-start");
        this.navigation.logout();
        this.tester.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000");
        this.tester.assertTextPresent("You're not logged in");
        this.tester.clickLinkWithText("Log In");
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Create Sub-Task", "Project", "monkey", "Issue Type", "Sub-task", "Summary"});
    }

    private void subTasksWithSubTasksEnabled(String issueKey) {
        this.administration.subtasks().enable();
        this.logger.log((Object)"Sub Task Create: Tests the availability of the 'Sub Task' Link with 'Sub Tasks' enabled");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresent("create-subtask");
        this.administration.subtasks().disable();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkNotPresent("create-subtask");
    }

    private void subTasksCreateSubTaskWithCustonType(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Tests the ability to create a sub task using a custom-made sub task type");
        this.navigation.issue().createSubTaskStep1(issueKey, "Custom Sub Task");
        this.tester.setFormElement("summary", "Custom Sub Task of Test 5");
        this.tester.submit();
        this.tester.assertTextPresent("Custom Sub Task of Test 5");
        this.tester.assertTextPresent("test for sub tasks");
        this.deleteCurrentIssue();
        this.administration.subtasks().disable();
        this.tester.assertTextPresent("Enable");
    }

    private void subTasksWithCreatePermission(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Test availability of 'Create Sub Task' link with 'Create Issue' permission.");
        this.administration.subtasks().enable();
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkNotPresent("create-subtask");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresent("create-subtask");
        this.administration.subtasks().disable();
    }

    private void subTaskWithNoSummary(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Adding sub task without summary");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.selectOption("priority", "Minor");
        this.tester.submit();
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.assertTextPresent("You must specify a summary of the issue.");
        this.administration.subtasks().disable();
    }

    private void subTaskWithRequiredFields(String issueKey) {
        this.editIssueFieldVisibility.setRequiredFields();
        this.logger.log((Object)"Sub Task Create: Test the creation of a sub task using required fields");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.setFormElement("summary", "This is a new summary");
        this.tester.setFormElement("reporter", "");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.assertTextPresent("Component/s is required");
        this.tester.assertTextPresent("Affects Version/s is required");
        this.tester.assertTextPresent("Fix Version/s is required");
        this.editIssueFieldVisibility.resetFields();
        this.administration.subtasks().disable();
    }

    private void subTaskWithHiddenFields(String issueKey) {
        this.editIssueFieldVisibility.setHiddenFields("Component/s");
        this.editIssueFieldVisibility.setHiddenFields("Affects Version/s");
        this.editIssueFieldVisibility.setHiddenFields("Fix Version/s");
        this.logger.log((Object)"Sub Task Create: Test the creation of a sub task using hidden fields");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.assertLinkNotPresent("components");
        this.tester.assertLinkNotPresent("versions");
        this.tester.assertLinkNotPresent("fixVersions");
        this.editIssueFieldVisibility.resetFields();
        this.administration.subtasks().disable();
    }

    private void subTaskWithInvalidDueDate(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Creating sub task with invalid due date");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.setFormElement("summary", "stuff");
        this.tester.setFormElement("duedate", "stuff");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
        this.administration.subtasks().disable();
    }

    private void subTaskWithSchedulePermission(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Test prescence of 'Due Date' field with 'Schedule Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertTextNotPresent("Due Date");
        this.administration.subtasks().disable();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertTextPresent("Due Date");
        this.administration.subtasks().disable();
    }

    private void subTaskWithAssignPermission(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Test ability to specify assignee with 'Assign Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementNotPresent("assignee");
        this.administration.subtasks().disable();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementPresent("assignee");
        this.administration.subtasks().disable();
    }

    private void subTaskWithModifyReporterPermission(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Test availability of Reporter with 'Modify Reporter' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MODIFY_REPORTER, "jira-administrators");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementNotPresent("reporter");
        this.administration.subtasks().disable();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MODIFY_REPORTER, "jira-administrators");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementPresent("reporter");
        this.administration.subtasks().disable();
    }

    private void subTaskWithTimeTracking(String issueKey) {
        this.logger.log((Object)"Sub task Create: Test availability of the original esitmate field with time tracking activated");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementNotPresent("timetracking");
        this.administration.subtasks().disable();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementPresent("timetracking");
        this.administration.timeTracking().disable();
        this.administration.subtasks().disable();
    }

    private void subTaskWithUnassignableUser(String issueKey) {
        this.logger.log((Object)"Sub Task Create: Attempt to set the assignee to be an unassignable user ...");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.submit("Create");
        this.tester.assertTextPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.administration.subtasks().disable();
    }

    private void subTaskMoveIssueWithSubTask(String issueKey) {
        this.logger.log((Object)"Sub Task Move: Move issue with a sub task");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.setFormElement("summary", "Sub Task of Test 5");
        this.tester.submit();
        this.tester.assertTextPresent("Sub Task of Test 5");
        this.tester.assertTextPresent("test for sub tasks");
        try {
            this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MOVE_ISSUES, "jira-developers");
        }
        catch (WebApplicationException webApplicationException) {
            // empty catch block
        }
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("neanderthal", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperationProgress.waitAndReloadBulkOperationProgressPage();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLinkWithText("Sub Task of Test 5");
        this.tester.assertTextPresent("neanderthal");
        this.deleteCurrentIssue();
        this.administration.subtasks().disable();
    }

    private void subTaskMoveSubTask(String issueKey) {
        String subTaskKey;
        this.logger.log((Object)"Sub Task Move; Move a sub task to a different sub task type.");
        this.navigation.issue().createSubTaskStep1(issueKey, "Sub-task");
        this.tester.setFormElement("summary", "Sub Task of Test 5");
        this.tester.submit();
        this.tester.assertTextPresent("Sub Task of Test 5");
        this.tester.assertTextPresent("test for sub tasks");
        try {
            String text = this.tester.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf("[NDT") + 1;
            int endOfIssueKey = text.indexOf("]", projectIdLocation);
            subTaskKey = text.substring(projectIdLocation, endOfIssueKey);
        }
        catch (IOException t) {
            Assert.fail((String)"Unable to obtain sub-task key");
            return;
        }
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(subTaskKey);
        this.tester.assertLinkNotPresent("move-subtask");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(subTaskKey);
        this.tester.clickLink("move-subtask");
        this.navigation.issue().selectIssueType("Custom Sub Task", "issuetype");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Step 2 of 3");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Step 4 of 4");
        this.tester.submit("Move");
        this.tester.assertTextPresent("Custom Sub Task");
        this.tester.assertTextPresent("Details");
        this.navigation.issue().gotoIssue(subTaskKey);
        this.deleteCurrentIssue();
        this.administration.subtasks().disable();
    }

    private void deleteCurrentIssue() {
        this.tester.clickLink("delete-issue");
        this.tester.setWorkingForm("delete-issue");
        this.tester.submit("Delete");
    }
}

