/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.subtask.SubTaskAssertions;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SUB_TASKS})
@LoginAs(user="admin")
@Restore(value="TestIssueToSubTaskConversion.xml")
public class TestIssueToSubTaskConversionStep1
extends BaseJiraFuncTest {
    private static final String ISSUE_WITHOUT_SUBTASK = "HSP-1";
    private static final String ISSUE_WITHOUT_SUBTASK_ID = "10000";
    private static final String ISSUE_WITH_SUBTASK = "HSP-2";
    private static final String ISSUE_WITH_SUBTASK_ID = "10001";
    private static final String SUBTASK = "HSP-3";
    private static final String SUBTASK_ID = "10002";
    private static final String INVALID_ISSUE_1 = "HSP-9";
    private static final String INVALID_ISSUE_ID_1 = "1)%20Please%20login%20again%20at%20https://attacker.com%20";
    private static final String INVALID_ISSUE_ID_2 = "10000a";
    private static final String ISSUE_FROM_OTHER_PROJECT = "MKY-1";
    private static final String ISSUE_TO_CONVERT_ID = "10020";
    private static final String ISSUE_TO_CONVERT_KEY = "MKY-2";
    private static final String PARENT_ISSUE = "MKY-3";
    private static final String SUBTASK_TYPE = "Sub-task";
    private static final String SUBTASK_TYPE_ID = "5";
    private static final String TASK_TYPE = "Task";
    private static final String TASK_TYPE_ID = "3";
    private static final String SUBTASK_TYPE_2 = "Sub-task 2";
    private static final String SUBTASK_TYPE_2_ID = "6";
    private static final String SUBTASK_TYPE_3 = "Sub-task 3";
    private static final String SUBTASK_TYPE_3_ID = "7";
    private static final String INVALID_TYPE_ID = "976";
    @Inject
    private SubTaskAssertions subTaskAssertions;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Test
    public void testParentIssueKeyIsTranslatedToCurrentKey() {
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.backdoor.project().addProjectKey(projectId, "OLD");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Select Parent Issue");
        this.tester.assertTextPresent("Begin typing to search for issues to link");
        this.tester.assertTextPresent("Only non-sub-task issues from the same project (HSP) can be selected.");
        this.tester.setFormElement("parentIssueKey", "OLD-2");
        this.tester.submit();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Parent Issue:", ISSUE_WITH_SUBTASK);
    }

    @Test
    public void testIssueToSubTaskConversionWhenSubTaskNotEnabled() {
        this.navigation.issue().gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.tester.assertLinkPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Step 1 of 4");
        this.navigation.issue().deleteIssue(SUBTASK);
        this.administration.subtasks().disable();
        this.navigation.issue().gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.tester.assertLinkNotPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Errors");
        this.tester.assertTextPresent("Sub-tasks are disabled.");
        this.tester.assertTextNotPresent("Step 1 of 4");
    }

    @Test
    public void testIssueToSubTaskConversionOnSubtask() {
        this.navigation.issue().gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.tester.assertLinkPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Step 1 of 4");
        this.navigation.issue().gotoIssue(SUBTASK);
        this.tester.assertLinkNotPresent("issue-to-subtask");
        this.gotoConvertIssue(SUBTASK_ID);
        this.tester.assertTextPresent("Errors");
        this.tester.assertTextPresent("Issue HSP-3 is already a sub-task.");
        this.tester.assertTextNotPresent("Step 1 of 4");
    }

    @Test
    public void testIssueToSubTaskConversionWhenIssueHasSubTasks() {
        this.navigation.issue().gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.tester.assertLinkPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Step 1 of 4");
        this.navigation.issue().gotoIssue(ISSUE_WITH_SUBTASK);
        this.tester.assertLinkNotPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITH_SUBTASK_ID);
        this.tester.assertTextPresent("Errors");
        this.tester.assertTextPresent("Can not convert issue HSP-2 with sub-tasks to a sub-task.");
        this.tester.assertTextNotPresent("Step 1 of 4");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Return to", ISSUE_WITH_SUBTASK);
        this.tester.assertLinkPresentWithText(ISSUE_WITH_SUBTASK);
    }

    @Test
    public void testIssueToSubTaskConversionEditPermission() {
        this.navigation.issue().gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.tester.assertLinkPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Step 1 of 4");
        this.tester.assertTextPresent("Select Parent Issue");
        this.tester.assertTextPresent("Begin typing to search for issues to link");
        this.tester.assertTextPresent("Only non-sub-task issues from the same project (HSP) can be selected.");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issue().gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.tester.assertLinkNotPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Access Denied");
        this.tester.assertTextNotPresent("Step 1 of 4");
    }

    @Test
    public void testIssueToSubTaskConversionWhenNotInIssueTypes() {
        this.navigation.issue().gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.tester.assertLinkPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Step 1 of 4");
        this.navigation.issue().deleteIssue(SUBTASK);
        this.tester.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=5");
        this.tester.assertTextPresent("Delete Issue Type: Sub-task");
        this.tester.submit("Delete");
        this.tester.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=6");
        this.tester.assertTextPresent("Delete Issue Type: Sub-task 2");
        this.tester.submit("Delete");
        this.tester.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=7");
        this.tester.assertTextPresent("Delete Issue Type: Sub-task 3");
        this.tester.submit("Delete");
        this.navigation.issue().gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.tester.assertLinkNotPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Errors");
        this.tester.assertTextPresent("Project HSP associated with issue does not have any sub-task issue types available.");
        this.tester.assertTextNotPresent("Step 1 of 4");
    }

    @Test
    public void testIssueToSubTaskConversionIsProtectAgainstContentSpoofingThroughAnInvalidIssueId() {
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Step 1 of 4");
        this.gotoConvertIssue(INVALID_ISSUE_ID_1);
        this.tester.assertTextPresent("Errors");
        this.tester.assertTextPresent("Invalid issue id");
        this.tester.assertTextNotPresent("attacker.com");
        this.tester.assertTextNotPresent("Step 1 of 4");
        this.gotoConvertIssue(INVALID_ISSUE_ID_2);
        this.tester.assertTextPresent("Errors");
        this.tester.assertTextNotPresent(INVALID_ISSUE_ID_2);
        this.tester.assertTextNotPresent("Step 1 of 4");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Return to", "Dashboard");
        this.tester.assertLinkPresentWithText("Dashboard");
    }

    @Test
    public void testIssueToSubTaskConversionInvalidParentIssue() {
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertTextPresent("Select Parent Issue");
        this.tester.assertTextPresent("Begin typing to search for issues to link");
        this.tester.assertTextPresent("Only non-sub-task issues from the same project (HSP) can be selected.");
        this.tester.setFormElement("parentIssueKey", "");
        this.tester.submit();
        this.tester.assertTextPresent("Parent issue key not specified.");
        this.tester.setFormElement("parentIssueKey", INVALID_ISSUE_1);
        this.tester.submit();
        this.tester.assertTextPresent("Parent issue with key HSP-9 not found.");
        this.tester.setFormElement("parentIssueKey", ISSUE_FROM_OTHER_PROJECT);
        this.tester.submit();
        this.tester.assertTextPresent("Parent issue MKY-1 must be from the same project as issue HSP-1");
        this.tester.setFormElement("parentIssueKey", ISSUE_WITHOUT_SUBTASK);
        this.tester.submit();
        this.tester.assertTextPresent("Issue HSP-1 can not be parent of itself.");
        this.tester.setFormElement("parentIssueKey", SUBTASK);
        this.tester.submit();
        this.tester.assertTextPresent("Parent issue HSP-3 can not be sub-task.");
    }

    @Test
    public void testIssueToSubTaskConversionSubTaskType() {
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.tester.assertOptionsEqual("issuetype", new String[]{SUBTASK_TYPE, SUBTASK_TYPE_2, SUBTASK_TYPE_3});
        this.tester.assertRadioOptionValueNotPresent("issuetype", TASK_TYPE);
        this.gotoConvertIssue(ISSUE_TO_CONVERT_ID);
        this.tester.assertOptionsEqual("issuetype", new String[]{SUBTASK_TYPE, SUBTASK_TYPE_3});
        this.tester.assertRadioOptionValueNotPresent("issuetype", SUBTASK_TYPE_2);
    }

    @Test
    public void testIssueToSubTaskConversionInvalidSubTaskType() {
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, INVALID_TYPE_ID);
        this.tester.assertTextPresent("Selected issue type not found.");
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, SUBTASK_TYPE_2_ID);
        this.tester.assertTextPresent("Issue type Sub-task 2 not applicable for this project");
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, TASK_TYPE_ID);
        this.tester.assertTextPresent("Issue type Task is not a sub-task");
    }

    @Test
    public void testIssueToSubTaskConversionPanelStep1() {
        this.gotoConvertIssue(ISSUE_TO_CONVERT_ID);
        this.tester.assertTextPresent("Select Parent Issue");
        this.tester.assertTextPresent("Begin typing to search for issues to link");
        this.tester.assertTextPresent("Only non-sub-task issues from the same project (MKY) can be selected.");
        this.subTaskAssertions.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_KEY, 1);
    }

    private void gotoConvertIssue(String issueId) {
        this.tester.gotoPage("/secure/ConvertIssue.jspa?id=" + issueId);
    }

    private void gotoConvertIssueStep2(String issueId, String parent, String issueType) {
        this.tester.gotoPage("/secure/ConvertIssueSetIssueType.jspa?id=" + issueId + "&parentIssueKey=" + parent + "&issuetype=" + issueType);
    }
}

