/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.BulkOperations;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
@LoginAs(user="admin")
@Restore(value="TestReindexingSubtasks.xml")
public class TestReindexingSubtasks
extends BaseJiraFuncTest {
    @Inject
    BulkOperations bulkOperations;
    @Inject
    private HtmlPage page;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Test
    public void testEditSingleIssue() throws SAXException {
        this.assertPrecondition();
        WebTable issueTable = this.getIssuesTable();
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-7");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-6");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 11, "Level Mouse");
        this.tester.clickLinkWithText("RAT-5");
        this.tester.clickLink("edit-issue");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "Level Mouse", "Priority"});
        this.tester.selectOption("security", "Level KingRat");
        this.tester.submit("Update");
        this.navigation.issue().returnToSearch();
        issueTable = this.getIssuesTable();
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-7");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-6");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 11, "Level KingRat");
        this.tester.assertTextNotPresent("Level Mouse");
    }

    @Test
    public void testMoveSingleIssue() throws SAXException {
        this.assertPrecondition();
        this.navigation.issue().gotoIssue("COW-35");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.navigation.issue().selectProject("Porcine", "10000_4_pid");
        this.navigation.issue().selectIssueType("Bug", "10000_4_issuetype");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Below is a summary of all issues that will be moved");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Project", "Porcine"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Type", "Bug"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "None"});
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextNotPresent("MyFriendsOnly");
        WebTable issueTable = this.getIssuesTable();
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 1, "PIG-12");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "PIG-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "Lets get a third milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 1, "PIG-11");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 2, "PIG-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 2, "Get another milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 1, "PIG-10");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 2, "PIG-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 2, "Get new milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 1, "PIG-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 2, "No more milk");
        this.navigation.issue().gotoIssue("PIG-9");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Move Issue");
        this.navigation.issue().selectProject("Rattus", "10021_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields");
        this.tester.selectOption("security", "Level KingRat");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Project", "Rattus"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Type", "Bug"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "Level KingRat"});
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextPresent("Level KingRat");
        this.navigation.issueNavigator().displayAllIssues();
        issueTable = this.getIssuesTable();
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-11");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 2, "RAT-8");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 2, "Lets get a third milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-10");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 2, "RAT-8");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 2, "Get another milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-9");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 2, "RAT-8");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 2, "Get new milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 1, "RAT-8");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "No more milk");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 11, "Level KingRat");
    }

    @Test
    public void testWorkflowTransitionSingleIssue() throws SAXException {
        this.assertPrecondition();
        this.tester.clickLinkWithText("RAT-5");
        this.tester.assertTextPresent("Details");
        this.tester.assertTextPresent("RAT-5");
        this.workflowUtil.clickAction("action_id_2");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.assertTextPresent("Close Issue");
        this.tester.assertTextPresent("Closing an issue indicates that there is no more work to be done on it, and that it has been verified as complete.");
        this.tester.selectOption("security", "Level KingRat");
        this.tester.submit("Transition");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextNotPresent("Level Mouse");
        WebTable issueTable = this.getIssuesTable();
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-7");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-6");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level KingRat");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 11, "Level KingRat");
        this.tester.clickLinkWithText("RAT-5");
        this.workflowUtil.clickAction("action_id_3");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.selectOption("security", "None");
        this.tester.submit("Transition");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextNotPresent("Level KingRat");
        this.tester.assertTextNotPresent("Level Mouse");
        issueTable = this.getIssuesTable();
        Assert.assertEquals((Object)"RAT-7", (Object)issueTable.getCellAsText(1, 1).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(1, 11).trim());
        Assert.assertEquals((Object)"RAT-6", (Object)issueTable.getCellAsText(2, 1).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 11).trim());
        Assert.assertEquals((Object)"RAT-5", (Object)issueTable.getCellAsText(3, 1).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 11).trim());
    }

    @Test
    public void testBulkEditIssue() throws SAXException {
        this.assertPrecondition();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10033", "on");
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 2 of 4: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "security");
        this.tester.selectOption("security", "A");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 4 of 4: Confirmation");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "A"});
        this.tester.submit("Confirm");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.assertTextNotPresent("MyFriendsOnly");
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10033", "on");
        this.tester.checkCheckbox("bulkedit_10041", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.checkCheckbox("actions", "security");
        this.tester.selectOption("security", "MyFriendsOnly");
        this.tester.submit("Next");
        this.tester.assertTextPresent("No more milk");
        this.tester.assertTextPresent("Lets get a third milk bucket");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "MyFriendsOnly"});
        this.tester.submit("Confirm");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.assertPrecondition();
    }

    @Test
    public void testBulkMoveIssue() throws SAXException {
        this.assertPrecondition();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.assertTextPresent("Step 1 of 4");
        this.tester.checkCheckbox("bulkedit_10030", "on");
        this.tester.checkCheckbox("bulkedit_10031", "on");
        this.tester.checkCheckbox("bulkedit_10033", "on");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 2 of 4: Choose Operation", "Choose the operation you wish to perform on the selected 3 issue(s)."});
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4", "Select Projects and Issue Types", "Please note that 1 sub-task issues were removed from the selection and do not appear in the table below. You are not allowed to bulk move sub-task issues together with their parent issue. In this case, you will only be asked to move the sub-task if you move the parent issue to a new project.", "The change will affect 1 issues with issue type(s) Improvement in project(s) Bovine.", "The change will affect 1 issues with issue type(s) Bug in project(s) Rattus."});
        this.navigation.issue().selectProject("Canine", "10000_4_pid");
        this.navigation.issue().selectIssueType("New Feature", "10000_4_issuetype");
        this.navigation.issue().selectProject("Porcine", "10022_1_pid");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4", "Select Projects and Issue Types for Sub-Tasks", "The table below lists all the sub-tasks that need to be moved to a new project. Please select the appropriate issue type for each of them", "The change will affect 3 issues with issue type(s) Sub-task in project(s) Bovine.", "The change will affect 2 issues with issue type(s) Sub-task in project(s) Rattus."});
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4", "Update Fields for Target Project 'Canine' - Issue Type 'New Feature'", "Security Level"});
        this.tester.selectOption("security", "Level Red");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4", "Update Fields for Target Project 'Canine' - Issue Type 'Sub-task'", "Security Level", "The security level of subtasks is inherited from parents."});
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4", "Update Fields for Target Project 'Porcine' - Issue Type 'Bug'", "Security Level", "The value of this field must be changed to be valid in the target project, but you are not able to update this field in the target project. It will be set to the field's default value for the affected issues."});
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4", "Update Fields for Target Project 'Porcine' - Issue Type 'Sub-task'", "Security Level", "The value of this field must be changed to be valid in the target project, but you are not able to update this field in the target project. It will be set to the field's default value for the affected issues."});
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 4 of 4", "Confirmation", "Below is a summary of all issues that will be moved. Please confirm that the correct changes have been entered. The bullet points below lists the different target projects and issue types the issues will be moved to. Click on a link below to go to that particular group of issues.", "Target Project", "Canine", "Target Issue Type", "New Feature", "Security Level", "Level Red", "Target Project", "Canine", "Target Issue Type", "Sub-task", "Security Level", "Level Red", "Target Project", "Porcine", "Target Issue Type", "Bug", "Security Level", "None", "Target Project", "Porcine", "Target Issue Type", "Sub-task", "Security Level", "None"});
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        WebTable issueTable = this.getIssuesTable();
        Assert.assertEquals((Object)"PIG-11", (Object)issueTable.getCellAsText(1, 1).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(1, 11).trim());
        Assert.assertEquals((Object)"PIG-10", (Object)issueTable.getCellAsText(2, 1).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(2, 11).trim());
        Assert.assertEquals((Object)"PIG-9", (Object)issueTable.getCellAsText(3, 1).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(3, 11).trim());
        Assert.assertEquals((Object)"DOG-12", (Object)issueTable.getCellAsText(4, 1).trim());
        Assert.assertEquals((Object)"Level Red", (Object)issueTable.getCellAsText(4, 11).trim());
        Assert.assertEquals((Object)"DOG-11", (Object)issueTable.getCellAsText(5, 1).trim());
        Assert.assertEquals((Object)"Level Red", (Object)issueTable.getCellAsText(5, 11).trim());
        Assert.assertEquals((Object)"DOG-10", (Object)issueTable.getCellAsText(6, 1).trim());
        Assert.assertEquals((Object)"Level Red", (Object)issueTable.getCellAsText(6, 11).trim());
        Assert.assertEquals((Object)"DOG-9", (Object)issueTable.getCellAsText(7, 1).trim());
        Assert.assertEquals((Object)"Level Red", (Object)issueTable.getCellAsText(7, 11).trim());
    }

    @Test
    public void testBulkMoveWithOrphanedSubtasks() throws SAXException {
        this.assertPrecondition();
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "Another parent");
        this.tester.submit("Create");
        this.tester.clickLink("create-subtask");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.setFormElement("summary", "Orphan");
        this.tester.submit("Create");
        this.navigation.issueNavigator().displayAllIssues();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10051", "on");
        this.tester.checkCheckbox("bulkedit_10033", "on");
        this.tester.checkCheckbox("bulkedit_10040", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4", "Select Projects and Issue Types", "Please note that 1 sub-task issues were removed from the selection and do not appear in the table below. You are not allowed to bulk move sub-task issues together with their parent issue. In this case, you will only be asked to move the sub-task if you move the parent issue to a new project.", "The change will affect 1 issues with issue type(s) Improvement in project(s) Bovine.", "Move", "To", "Bovine", "The change will affect 1 issues with issue type(s) Sub-task in project(s) Bovine and parent issue(s) COW-38."});
        this.tester.checkCheckbox("sameAsBulkEditBean", "10000_4_");
        this.navigation.issue().selectProject("Rattus", "10000_4_pid");
        this.navigation.issue().selectIssueType("New Feature", "10000_4_issuetype");
        this.navigation.issue().selectIssueType("Task", "10000_5_10000_10050_issuetype");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4", "Select Projects and Issue Types for Sub-Tasks", "The table below lists all the sub-tasks that need to be moved to a new project. Please select the appropriate issue type for each of them", "The change will affect 3 issues with issue type(s) Sub-task in project(s) Bovine.", "Move", "To", "Rattus"});
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4", "Update Fields for Target Project 'Rattus' - Issue Type 'New Feature'"});
        this.tester.selectOption("security", "Level KingRat");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.page.getCollapsedResponseText(), new String[]{"Step 3 of 4", "Update Fields for Target Project 'Rattus' - Issue Type 'Sub-task'"});
        this.tester.assertTextPresent("The security level of subtasks is inherited from parents.");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        WebTable issueTable = this.getIssuesTable();
        Assert.assertEquals((Object)"RAT-12", (Object)issueTable.getCellAsText(1, 1).trim());
        Assert.assertEquals((Object)"Level KingRat", (Object)issueTable.getCellAsText(1, 11).trim());
        Assert.assertEquals((Object)"RAT-11", (Object)issueTable.getCellAsText(2, 1).trim());
        Assert.assertEquals((Object)"Level KingRat", (Object)issueTable.getCellAsText(2, 11).trim());
        Assert.assertEquals((Object)"RAT-10", (Object)issueTable.getCellAsText(3, 1).trim());
        Assert.assertEquals((Object)"Level KingRat", (Object)issueTable.getCellAsText(3, 11).trim());
        Assert.assertEquals((Object)"RAT-9", (Object)issueTable.getCellAsText(4, 1).trim());
        Assert.assertEquals((Object)"Level KingRat", (Object)issueTable.getCellAsText(4, 11).trim());
        Assert.assertEquals((Object)"RAT-8", (Object)issueTable.getCellAsText(5, 1).trim());
        Assert.assertEquals((Object)"Level KingRat", (Object)issueTable.getCellAsText(5, 11).trim());
        Assert.assertEquals((Object)"RAT-7", (Object)issueTable.getCellAsText(6, 1).trim());
        Assert.assertEquals((Object)"Level Mouse", (Object)issueTable.getCellAsText(6, 11).trim());
        Assert.assertEquals((Object)"RAT-6", (Object)issueTable.getCellAsText(7, 1).trim());
        Assert.assertEquals((Object)"Level Mouse", (Object)issueTable.getCellAsText(7, 11).trim());
        Assert.assertEquals((Object)"RAT-5", (Object)issueTable.getCellAsText(8, 1).trim());
        Assert.assertEquals((Object)"Level Mouse", (Object)issueTable.getCellAsText(8, 11).trim());
        Assert.assertEquals((Object)"COW-38", (Object)issueTable.getCellAsText(9, 1).trim());
        Assert.assertEquals((Object)"", (Object)issueTable.getCellAsText(9, 11).trim());
    }

    @Test
    public void testBulkWorkflowTransitionIssue() throws SAXException {
        this.assertPrecondition();
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.assertTextPresent("Step 1 of 4: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10033", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 2 of 4: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 3 of 4: Operation Details");
        this.tester.checkCheckbox("wftransition", "Copy of jira_2_6");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Workflow", "Copy of jira"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Selected Transition", "Close Issue"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Status Transition", "Open", "Closed"});
        this.tester.checkCheckbox("actions", "resolution");
        this.tester.selectOption("resolution", "Fixed");
        this.tester.checkCheckbox("actions", "security");
        this.tester.selectOption("security", "None");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Workflow", "Copy of jira"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Selected Transition", "Close Issue"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Status Transition", "Open", "Closed"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"This change will affect", "1", "issues"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "None"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Resolution", "Fixed"});
        this.tester.assertTextPresent("COW-35");
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.assertTextNotPresent("MyFriendsOnly");
        WebTable issueTable = this.getIssuesTable();
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 1, "COW-37");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "Lets get a third milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 6, "Open");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 1, "COW-36");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 2, "Get another milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 6, "Open");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 1, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 2, "No more milk");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 6, "Closed");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 1, "COW-34");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 2, "Get new milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 6, "Open");
        this.bulkOperations.bulkChangeIncludeAllPages();
        this.tester.checkCheckbox("bulkedit_10033", "on");
        this.tester.checkCheckbox("bulkedit_10034", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.workflowtransition.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Step 3 of 4: Operation Details");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Closed", "Reopened"});
        this.tester.submit("Next");
        this.tester.checkCheckbox("wftransition", "Copy of jira_3_4");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Workflow", "Copy of jira"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Selected Transition", "Reopen Issue"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Status Transition", "Closed", "Reopened"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"This change will affect", "1", "issues"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "MyFriendsOnly"});
        this.tester.checkCheckbox("actions", "security");
        this.tester.selectOption("security", "MyFriendsOnly");
        this.tester.submit("Next");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Workflow", "Copy of jira"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Selected Transition", "Reopen Issue"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Status Transition", "Closed", "Reopened"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"This change will affect", "1", "issues"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"COW-35"});
        this.tester.submit("Next");
        this.bulkOperations.waitAndReloadBulkOperationProgressPage();
        issueTable = this.getIssuesTable();
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 1, "COW-37");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "Lets get a third milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 6, "Open");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 1, "COW-36");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 2, "Get another milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 6, "Open");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 1, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 2, "No more milk");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 6, "Reopened");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 1, "COW-34");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 2, "Get new milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 6, "Open");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 11, "MyFriendsOnly");
    }

    @Test
    public void testConvertSingleIssueToSubtask() throws SAXException {
        this.assertPrecondition();
        this.navigation.issue().gotoIssue("COW-34");
        this.tester.clickLink("subtask-to-issue");
        this.tester.assertTextPresent("Convert Sub-task to Issue: COW-34");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Type", "Sub-task", "New Feature"});
        this.tester.submit("Finish");
        this.tester.assertTextPresent("Get new milk bucket");
        this.tester.assertTextNotPresent("COW-35");
        this.tester.assertTextPresent("MyFriendsOnly");
        this.tester.clickLink("edit-issue");
        this.tester.selectOption("security", "None");
        this.tester.submit("Update");
        this.navigation.issue().returnToSearch();
        WebTable issueTable = this.getIssuesTable();
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 1, "COW-37");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "Lets get a third milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 1, "COW-36");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 2, "Get another milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 1, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 2, "No more milk");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 1, "COW-34");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 2, "Get new milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 11, "");
        this.navigation.issue().gotoIssue("COW-34");
        this.tester.clickLink("issue-to-subtask");
        this.tester.setFormElement("parentIssueKey", "COW-35");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Convert Issue to Sub-task: COW-34");
        this.tester.assertTextPresent("All fields will be updated automatically.");
        this.tester.submit("Next >>");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Type", "New Feature", "Sub-task"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Security Level", "None", "MyFriendsOnly"});
        this.tester.submit("Finish");
        this.tester.assertTextPresent("COW-35");
        this.tester.assertTextPresent("MyFriendsOnly");
        this.navigation.issue().returnToSearch();
        this.assertPrecondition();
    }

    private void assertPrecondition() throws SAXException {
        this.navigation.issueNavigator().displayAllIssues();
        WebTable issueTable = this.getIssuesTable();
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 1, "RAT-7");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 2, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 1, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 1, "RAT-6");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 2, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 2, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 1, "RAT-5");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 3, 11, "Level Mouse");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 1, "COW-37");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 2, "Lets get a third milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 4, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 1, "COW-36");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 2, "Get another milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 5, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 1, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 2, "No more milk");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 6, 11, "MyFriendsOnly");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 1, "COW-34");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 2, "COW-35");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 2, "Get new milk bucket");
        this.assertions.getTableAssertions().assertTableCellHasText(issueTable, 7, 11, "MyFriendsOnly");
    }

    private WebTable getIssuesTable() throws SAXException {
        return this.tester.getDialog().getResponse().getTableWithID("issuetable");
    }
}

