/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import javax.inject.Inject;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING, Category.WORKLOGS})
@LoginAs(user="admin")
@Restore(value="TestUpdateWorklog.xml")
public class TestDeleteWorklog
extends BaseJiraFuncTest {
    private static final String ADMIN_COMMENT = "Admin does some work.";
    private static final String HSP_1 = "HSP-1";
    @Inject
    private Parser parse;
    @Inject
    private HtmlPage page;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testMandatoryFields() {
        this.navigation.issue().viewIssue(HSP_1);
        this.clickWorkLogLink();
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().setFormElement("newEstimate", "");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().submit();
        this.textAssertions.assertTextPresent("You must supply a valid new estimate.");
    }

    @Test
    public void testInvalidFormattedDurationFields() {
        this.navigation.issue().viewIssue(HSP_1);
        this.clickWorkLogLink();
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().setFormElement("newEstimate", "Six Days, Seven Nights");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().submit();
        this.textAssertions.assertTextPresent("Invalid new estimate entered.");
    }

    @Test
    public void testInsufficientSecurityLevelCantDelete() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLinkWithText("Work Log");
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().selectOption("commentLevel", "jira-administrators");
        this.getTester().submit("Log");
        this.navigation.logout();
        this.navigation.login("mel", "mel");
        this.getTester().gotoPage("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=10000");
        this.textAssertions.assertTextPresent("Access Denied");
        this.textAssertions.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    @Test
    public void testNoPermissionCantDelete() {
        this.backdoor.permissionSchemes().removeEveryonePermission(Long.valueOf(0L), ProjectPermissions.DELETE_ALL_WORKLOGS);
        this.navigation.logout();
        this.navigation.login("mel", "mel");
        this.getTester().gotoPage("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=10000");
        this.textAssertions.assertTextPresent("Access Denied");
        this.textAssertions.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    @Test
    public void testDeleteNonExistantWorklog() {
        this.getTester().gotoPage("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=OMGROFLCOPTER");
        this.textAssertions.assertTextPresent("Delete Worklog");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Cannot retrieve worklog with id='null' for update.");
    }

    @Test
    public void testDeleteChangeHistory() throws SAXException {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLinkWithText("Work Log");
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().submit("Delete");
        this.assertAdminWorklogDeleted();
        this.getTester().clickLinkWithText("History");
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Administrator").add("Time Spent", "6 days [ 518400 ]", "5 days [ 432000 ]").add("Remaining Estimate", "3 weeks, 1 day [ 1900800 ]", "3 weeks, 2 days [ 1987200 ]").add("Worklog Id", "10000 [ 10000 ]", "").add("Worklog Time Spent", "1 day [ 86400 ]", "");
        ChangeHistoryList list = this.parse.issue().parseChangeHistory();
        list.assertContainsSomeOf(expectedList);
    }

    @Test
    public void testDeleteAndAutoAdjustRemainingEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().checkCheckbox("adjustEstimate", "auto");
        this.getTester().submit("Delete");
        this.assertTextSequence(new String[]{"3 weeks", "5 days"});
        this.assertAdminWorklogDeleted();
    }

    @Test
    public void testDeleteAndRetainRemainingEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().checkCheckbox("adjustEstimate", "leave");
        this.getTester().submit("Delete");
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "5 days"});
        this.assertAdminWorklogDeleted();
    }

    @Test
    public void testDeleteAndSpecifyNewEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("delete_worklog_10000");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "8w");
        this.getTester().submit("Delete");
        this.assertTextSequence(new String[]{"8 weeks", "5 days"});
        this.assertAdminWorklogDeleted();
    }

    private void assertAdminWorklogDeleted() {
        this.textAssertions.assertTextNotPresent(ADMIN_COMMENT);
        this.textAssertions.assertTextNotPresent("19/Jun/07 06:09 PM");
        this.textAssertions.assertTextNotPresent("title=\"Created: 19/Jun/07 06:10 PM\"");
        this.getTester().assertLinkNotPresent("delete_worklog_10000");
        this.getTester().assertLinkNotPresent("edit_worklog_10000");
    }

    private void clickWorkLogLink() {
        if (this.page.isLinkPresentWithExactText("Work Log")) {
            this.getTester().clickLinkWithText("Work Log");
        }
    }

    @Test
    public void testManuallyIncreaseEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated:", "4w", "Remaining:", "3w 1d", "Logged:", "6d");
        this.getTester().clickLinkWithText("Work Log");
        this.getTester().clickLink("delete_worklog_10002");
        this.getTester().checkCheckbox("adjustEstimate", "manual");
        this.getTester().submit("Delete");
        this.textAssertions.assertTextPresent("You must supply a valid amount of time to adjust the estimate by.");
        this.getTester().setFormElement("adjustmentAmount", "heaps");
        this.getTester().submit("Delete");
        this.textAssertions.assertTextPresent("Invalid time entered for adjusting the estimate.");
        this.getTester().setFormElement("adjustmentAmount", "2d");
        this.getTester().submit("Delete");
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated:", "4w", "Remaining:", "3w 3d", "Logged:", "3d");
    }

    private void assertTextSequence(String[] strings) {
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
    }
}

