/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.RequestAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.meterware.httpunit.WebResponseUtil;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS, Category.TIME_TRACKING})
@LoginAs(user="admin")
public class TestTimeTrackingExcelReport
extends BaseJiraFuncTest {
    private static String EXCEL_REPORT_URL = "/secure/ConfigureReport!excelView.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking&Next=Next&versionId=10001&sortingOrder=least&completedFilter=all";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private RequestAssertions requestAssertions;
    @Inject
    private Administration administration;

    @Test
    @Restore(value="TestTimeTrackingReport.xml")
    public void testTimeTrackingExcelReport() throws SAXException {
        this.tester.gotoPage("/secure/ConfigureReport!excelView.jspa?Next=Next&versionId=-1&reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking&sortingOrder=least&selectedProjectId=10000&completedFilter=all");
        if (!WebResponseUtil.replaceResponseContentType(this.tester.getDialog().getResponse(), "text/html")) {
            Assert.fail((String)"Failed to replace response content type with 'text/html'");
        }
        WebTable reportTable = this.tester.getDialog().getResponse().getTableWithID("time_tracking_report_table");
        this.assertions.getTableAssertions().assertTableRowEquals(reportTable, 3, new Object[]{"Bug", "HSP-1", "Open", "Major", "massive bug", "14400", "8370", "6030", "0"});
        this.assertions.getTableAssertions().assertTableRowEquals(reportTable, 4, new Object[]{"Bug", "HSP-2", "Open", "Major", "bug2", "1440", "1230", "210", "0"});
        this.assertions.getTableAssertions().assertTableRowEquals(reportTable, 5, new Object[]{"", "", "", "", "Total", "15840", "9600", "6240", "0", "0"});
    }

    @Test
    @Restore(value="TestTimeTrackingReport.xml")
    public void testTimeTrackingExcelReportTruncation() throws SAXException {
        String warningMessage = "We've truncated the report because it's too big";
        this.backdoor.applicationProperties().setString("jira.timetracking.report.issues.limit", String.valueOf(1));
        this.tester.gotoPage("/secure/ConfigureReport!excelView.jspa?Next=Next&versionId=-1&reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking&sortingOrder=least&selectedProjectId=10000&completedFilter=all");
        if (!WebResponseUtil.replaceResponseContentType(this.tester.getDialog().getResponse(), "text/html")) {
            Assert.fail((String)"Failed to replace response content type with 'text/html'");
        }
        WebTable reportTable = this.tester.getDialog().getResponse().getTableWithID("time_tracking_report_table");
        String headerRow = reportTable.getCellAsText(0, 0);
        Assert.assertTrue((String)"header row shall contain a warning message", (boolean)headerRow.contains("We've truncated the report because it's too big"));
        String secondToLastRow = reportTable.getCellAsText(reportTable.getRowCount() - 2, 0);
        Assert.assertTrue((String)"additional footer row shall contain a warning message", (boolean)secondToLastRow.contains("We've truncated the report because it's too big"));
        this.backdoor.applicationProperties().setString("jira.timetracking.report.issues.limit", String.valueOf(1000));
        this.tester.gotoPage("/secure/ConfigureReport!excelView.jspa?Next=Next&versionId=-1&reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking&sortingOrder=least&selectedProjectId=10000&completedFilter=all");
        if (!WebResponseUtil.replaceResponseContentType(this.tester.getDialog().getResponse(), "text/html")) {
            Assert.fail((String)"Failed to replace response content type with 'text/html'");
        }
        reportTable = this.tester.getDialog().getResponse().getTableWithID("time_tracking_report_table");
        for (int i = 0; i < reportTable.getRowCount(); ++i) {
            String testRow = reportTable.getCellAsText(i, 0);
            Assert.assertTrue((String)"un-truncated report shall not contain warning message", (!testRow.contains("We've truncated the report because it's too big") ? 1 : 0) != 0);
        }
    }

    @Test
    @Restore(value="TestTimeTrackingExcelReport.xml")
    public void testInternationalizationOfExcelReport() {
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        try {
            if (!WebResponseUtil.replaceResponseContentType(this.tester.getDialog().getResponse(), "text/html")) {
                this.logger.log((Object)"Failed to replace response content type with 'text/html'");
                Assert.fail();
            } else {
                this.tester.gotoPage(EXCEL_REPORT_URL);
                this.tester.assertTextPresent("In Progress");
                this.tester.assertTextPresent("Open");
            }
        }
        catch (Exception e) {
            this.logger.log((Object)"Failed to parse the printable view");
            this.logger.log((Throwable)e);
            Assert.fail();
        }
        this.tester.gotoPage("/secure/Dashboard.jspa");
        this.setLocaleTo("Deutsch (Deutschland)");
        try {
            if (!WebResponseUtil.replaceResponseContentType(this.tester.getDialog().getResponse(), "text/html")) {
                this.logger.log((Object)"Failed to replace response content type with 'text/html'");
                Assert.fail();
            } else {
                this.tester.gotoPage(EXCEL_REPORT_URL);
                this.tester.assertTextPresent(this.backdoor.i18n().getText("jira.translation.status.inprogress.name", "de_DE"));
                this.tester.assertTextPresent(this.backdoor.i18n().getText("jira.translation.status.open.name", "de_DE"));
            }
        }
        catch (Exception e) {
            this.logger.log((Object)"Failed to parse the printable view");
            this.logger.log((Throwable)e);
            Assert.fail();
        }
        finally {
            this.tester.gotoPage("/secure/Dashboard.jspa");
            this.navigation.userProfile().changeUserLanguageToJiraDefault();
        }
    }

    @Test
    @Restore(value="TestTimeTrackingReport.xml")
    public void testExcelReportResponseCanBeCached() throws SAXException {
        this.tester.gotoPage("/secure/ConfigureReport!excelView.jspa?Next=Next&versionId=-1&reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking&sortingOrder=least&selectedProjectId=10000&completedFilter=all");
        if (!WebResponseUtil.replaceResponseContentType(this.tester.getDialog().getResponse(), "text/html")) {
            Assert.fail((String)"Failed to replace response content type with 'text/html'");
        }
        this.requestAssertions.assertResponseCanBeCached();
    }

    private void setLocaleTo(String localeName) {
        this.navigation.userProfile().changeUserLanguage(localeName);
    }
}

