/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS, Category.TIME_TRACKING})
@LoginAs(user="admin")
public class TestTimeTrackingReport
extends BaseJiraFuncTest {
    private static final char NEG = '\u2011';
    private static final String SIGMA = "&Sigma;";
    private static final int PID_MONOTREME = 10010;
    private static final int PID_HOMOSAPIEN = 10000;
    private static final Long PROJECT_MONKEY_ID = 10001L;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testTimeTrackingReportAvailable() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Atime-tracking&Next=Next");
        this.tester.assertTextPresent("The selected project does not exist, or you do not have permission to view it.");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Atime-tracking&Next=Next&selectedProjectId=10000");
        this.tester.assertTextNotPresent("The selected project does not exist, or you do not have permission to view it.");
        this.tester.assertTextPresent("Time Tracking Report for&nbsp;homosapien");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Time Tracking Report for&nbsp;homosapien");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Atime-tracking&Next=Next");
        this.tester.assertTextPresent("Time Tracking Report for&nbsp;homosapien");
    }

    @Test
    public void testTimeTrackingReportSwitchingBetweenProjects() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Atime-tracking&Next=Next&selectedProjectId=10000");
        this.tester.assertTextPresent("Time Tracking Report for&nbsp;homosapien");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Atime-tracking&Next=Next&selectedProjectId=10001");
        this.tester.assertTextPresent("Time Tracking Report for&nbsp;monkey");
    }

    @Test
    public void testTimeTrackingReportShowsSubTaskSelector() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Atime-tracking&Next=Next&selectedProjectId=10000");
        this.tester.assertTextNotPresent("Sub-task Inclusion");
        this.administration.subtasks().enable();
        this.gotoReportConfig(10000);
        this.tester.assertTextPresent("Sub-task Inclusion");
        this.tester.selectOption("subtaskInclusion", "Only including sub-tasks with the selected version");
        this.tester.selectOption("subtaskInclusion", "Also including sub-tasks without a version set");
        this.tester.selectOption("subtaskInclusion", "Including all sub-tasks");
        this.tester.assertRadioOptionValueNotPresent("subtaskInclusion", "Sub-tasks are not enabled");
    }

    @Test
    public void testSubTaskAggregatesWithNoSubtasksDisplayed() throws SAXException {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.administration.subtasks().enable();
        this.gotoReportConfig(10000);
        this.tester.checkCheckbox("subtaskInclusion", "all");
        this.tester.checkCheckbox("sortingOrder", "least");
        this.tester.checkCheckbox("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Including all sub-tasks");
        this.tester.assertTextPresent(SIGMA);
        WebTable barsSummary = this.tester.getDialog().getWebTableBySummaryOrId("bars-summary");
        this.assertions.getTableAssertions().assertTableCellHasText(barsSummary, 0, 0, "Progress: 39%");
        this.assertions.getTableAssertions().assertTableCellHasText(barsSummary, 1, 0, "Accuracy: 0%");
        WebTable table = this.tester.getDialog().getResponse().getTableWithID("timeReport");
        List<String> rowList = this.getTableRowAsList(table, 1);
        String[] row = rowList.toArray(new String[rowList.size()]);
        Assert.assertTrue((boolean)row[3].contains("massive bug"));
        Assert.assertEquals((Object)"1w 3d", (Object)row[4]);
        Assert.assertEquals((Object)"1w 3d", (Object)row[5]);
        Assert.assertEquals((Object)"5d 19h 30m", (Object)row[6]);
        Assert.assertEquals((Object)"5d 19h 30m", (Object)row[7]);
        Assert.assertEquals((Object)"4d 4h 30m", (Object)row[8]);
        Assert.assertEquals((Object)"4d 4h 30m", (Object)row[9]);
        Assert.assertEquals((Object)"on track", (Object)row[10]);
        Assert.assertEquals((Object)"on track", (Object)row[11]);
        rowList = this.getTableRowAsList(table, 2);
        row = rowList.toArray(new String[rowList.size()]);
        Assert.assertTrue((boolean)row[3].contains("bug2"));
        Assert.assertEquals((Object)"1d", (Object)row[4]);
        Assert.assertEquals((Object)"1d", (Object)row[5]);
        Assert.assertEquals((Object)"20h 30m", (Object)row[6]);
        Assert.assertEquals((Object)"20h 30m", (Object)row[7]);
        Assert.assertEquals((Object)"3h 30m", (Object)row[8]);
        Assert.assertEquals((Object)"3h 30m", (Object)row[9]);
        Assert.assertEquals((Object)"on track", (Object)row[10]);
        Assert.assertEquals((Object)"on track", (Object)row[11]);
        rowList = this.getTableRowAsList(table, 3);
        row = rowList.toArray(new String[rowList.size()]);
        Assert.assertEquals((Object)"Total", (Object)row[3]);
        Assert.assertEquals((Object)"1w 4d", (Object)row[4]);
        Assert.assertEquals((Object)"6d 16h", (Object)row[6]);
        Assert.assertEquals((Object)"4d 8h", (Object)row[8]);
        Assert.assertEquals((Object)"on track", (Object)row[10]);
    }

    @Test
    public void testSubTaskAggregates() throws SAXException {
        this.administration.restoreData("TestTimeTrackingReportWithSubtasksEnterprise.xml");
        this.gotoReportConfig(10010);
        this.tester.checkCheckbox("versionId", "10010");
        this.tester.checkCheckbox("subtaskInclusion", "all");
        this.tester.checkCheckbox("sortingOrder", "least");
        this.tester.checkCheckbox("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Time Tracking Report for&nbsp;Monotreme");
        this.tester.assertTextPresent("(v8)");
        this.tester.assertTextPresent("Including all sub-tasks");
        WebTable table = this.tester.getDialog().getResponse().getTableWithID("timeReport");
        List<String> rowList = this.getTableRowAsList(table, 1);
        String[] row = rowList.toArray(new String[rowList.size()]);
        Assert.assertTrue((boolean)row[3].contains("monotreme parent with fixfor v8"));
        Assert.assertEquals((Object)"-", (Object)row[4]);
        Assert.assertEquals((Object)"7h 10m", (Object)row[5]);
        Assert.assertEquals((Object)"-", (Object)row[6]);
        Assert.assertEquals((Object)"6h 10m", (Object)row[7]);
        Assert.assertEquals((Object)"-", (Object)row[8]);
        Assert.assertEquals((Object)"5h", (Object)row[9]);
        Assert.assertEquals((Object)"-", (Object)row[10]);
        Assert.assertEquals((Object)"\u20114h", (Object)row[11]);
        rowList = this.getTableRowAsList(table, 2);
        row = rowList.toArray(new String[rowList.size()]);
        Assert.assertTrue((boolean)row[3].contains("subtask with no fixfor and parent fixfor v8"));
        Assert.assertEquals((Object)"6h", (Object)row[4]);
        Assert.assertEquals((Object)"-", (Object)row[5]);
        Assert.assertEquals((Object)"6h", (Object)row[6]);
        Assert.assertEquals((Object)"-", (Object)row[7]);
        Assert.assertEquals((Object)"4h", (Object)row[8]);
        Assert.assertEquals((Object)"-", (Object)row[9]);
        Assert.assertEquals((Object)"\u20114h", (Object)row[10]);
        Assert.assertEquals((Object)"-", (Object)row[11]);
        rowList = this.getTableRowAsList(table, 3);
        row = rowList.toArray(new String[rowList.size()]);
        Assert.assertTrue((boolean)row[3].contains("subtask with fixfor v8 same as parent"));
        Assert.assertEquals((Object)"10m", (Object)row[4]);
        Assert.assertEquals((Object)"-", (Object)row[5]);
        Assert.assertEquals((Object)"10m", (Object)row[6]);
        Assert.assertEquals((Object)"-", (Object)row[7]);
        Assert.assertEquals((Object)"-", (Object)row[8]);
        Assert.assertEquals((Object)"-", (Object)row[9]);
        Assert.assertEquals((Object)"on track", (Object)row[10]);
        Assert.assertEquals((Object)"-", (Object)row[11]);
        rowList = this.getTableRowAsList(table, 4);
        row = rowList.toArray(new String[rowList.size()]);
        Assert.assertTrue((boolean)row[3].contains("subtask complete same fixfor as parent"));
        Assert.assertEquals((Object)"1h", (Object)row[4]);
        Assert.assertEquals((Object)"-", (Object)row[5]);
        Assert.assertEquals((Object)"0m", (Object)row[6]);
        Assert.assertEquals((Object)"-", (Object)row[7]);
        Assert.assertEquals((Object)"1h", (Object)row[8]);
        Assert.assertEquals((Object)"-", (Object)row[9]);
        Assert.assertEquals((Object)"on track", (Object)row[10]);
        Assert.assertEquals((Object)"-", (Object)row[11]);
        rowList = this.getTableRowAsList(table, 5);
        row = rowList.toArray(new String[rowList.size()]);
        Assert.assertTrue((boolean)row[3].contains("MON-5"));
        Assert.assertTrue((boolean)row[3].contains("v12 subtask with v8 fixfor"));
        Assert.assertEquals((Object)"44m", (Object)row[4]);
        Assert.assertEquals((Object)"44m", (Object)row[5]);
        Assert.assertEquals((Object)"23m", (Object)row[6]);
        Assert.assertEquals((Object)"23m", (Object)row[7]);
        Assert.assertEquals((Object)"21m", (Object)row[8]);
        Assert.assertEquals((Object)"21m", (Object)row[9]);
        Assert.assertEquals((Object)"on track", (Object)row[10]);
        Assert.assertEquals((Object)"on track", (Object)row[11]);
        rowList = this.getTableRowAsList(table, 6);
        row = rowList.toArray(new String[rowList.size()]);
        Assert.assertEquals((Object)"Total", (Object)row[3]);
        Assert.assertEquals((Object)"7h 54m", (Object)row[4]);
        Assert.assertEquals((Object)"6h 33m", (Object)row[6]);
        Assert.assertEquals((Object)"5h 21m", (Object)row[8]);
        Assert.assertEquals((Object)"\u20114h", (Object)row[10]);
        this.assertSummaryPercentages(44, -50);
        WebTable barsSummary = this.tester.getDialog().getWebTableBySummaryOrId("bars-summary");
        this.assertions.getTableAssertions().assertTableCellHasText(barsSummary, 0, 2, "5h 21m completed from current total estimate of 11h 54m");
        this.assertions.getTableAssertions().assertTableCellHasText(barsSummary, 1, 2, "Issues in this version are behind the original estimate of 7h 54m by 4 hours.");
    }

    @Test
    public void testSubTaskAggregatesVersionSpecific() throws SAXException {
        this.administration.restoreData("TestTimeTrackingReportWithSubtasksEnterprise.xml");
        this.gotoReportConfig(10010);
        this.tester.checkCheckbox("versionId", "10010");
        this.tester.checkCheckbox("subtaskInclusion", "onlySelected");
        this.tester.checkCheckbox("sortingOrder", "most");
        this.tester.checkCheckbox("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Time Tracking Report for&nbsp;Monotreme");
        this.tester.assertTextPresent("(v8)");
        this.tester.assertTextPresent("Only including sub-tasks with the selected version");
        this.assertTimeReportCell(1, 3, "monotreme parent with fixfor v8");
        this.assertTimeReportCell(1, 4, "-");
        this.assertTimeReportCell(1, 5, "1h 10m");
        this.assertTimeReportCell(1, 6, "-");
        this.assertTimeReportCell(1, 7, "10m");
        this.assertTimeReportCell(1, 8, "-");
        this.assertTimeReportCell(1, 9, "1h");
        this.assertTimeReportCell(1, 10, "-");
        this.assertTimeReportCell(1, 11, "on track");
        this.assertTimeReportCell(2, 3, "subtask complete same fixfor as parent");
        this.assertTimeReportCell(2, 4, "1h");
        this.assertTimeReportCell(2, 5, "-");
        this.assertTimeReportCell(2, 6, "0m");
        this.assertTimeReportCell(2, 7, "-");
        this.assertTimeReportCell(2, 8, "1h");
        this.assertTimeReportCell(2, 9, "-");
        this.assertTimeReportCell(2, 10, "on track");
        this.assertTimeReportCell(2, 11, "-");
        this.assertTimeReportCell(3, 3, "subtask with fixfor v8 same as parent");
        this.assertTimeReportCell(3, 4, "10m");
        this.assertTimeReportCell(3, 5, "-");
        this.assertTimeReportCell(3, 6, "10m");
        this.assertTimeReportCell(3, 7, "-");
        this.assertTimeReportCell(3, 8, "-");
        this.assertTimeReportCell(3, 9, "-");
        this.assertTimeReportCell(3, 10, "on track");
        this.assertTimeReportCell(3, 11, "-");
        this.assertTimeReportCell(4, 3, "v12 subtask with v8 fixfor");
        this.assertTimeReportCell(4, 4, "44m");
        this.assertTimeReportCell(4, 5, "44m");
        this.assertTimeReportCell(4, 6, "23m");
        this.assertTimeReportCell(4, 7, "23m");
        this.assertTimeReportCell(4, 8, "21m");
        this.assertTimeReportCell(4, 9, "21m");
        this.assertTimeReportCell(4, 10, "on track");
        this.assertTimeReportCell(4, 11, "on track");
        this.assertTimeReportCell(5, 3, "Total");
        this.assertTimeReportCell(5, 4, "1h 54m");
        this.assertTimeReportCell(5, 6, "33m");
        this.assertTimeReportCell(5, 8, "1h 21");
        this.assertTimeReportCell(5, 10, "on track");
        this.tester.assertTextNotPresent("subtask with no fixfor and parent fixfor v8");
        this.assertSummaryPercentages(71, 0);
    }

    @Test
    public void testSubTaskAggregatesWithVersionAndBlank() throws SAXException {
        this.administration.restoreData("TestTimeTrackingReportWithSubtasksEnterprise.xml");
        this.assertSubtaskAggregatesWithVersionAndBlank();
    }

    @Test
    public void testSubTasksBothResolvedAndUnresolvedIncluded() throws Exception {
        this.administration.restoreData("TestTimeTrackingReportSubTasksResolvedAndUnresolved.xml");
        this.gotoReportConfig(10000);
        this.tester.checkCheckbox("versionId", "10000");
        this.tester.checkCheckbox("sortingOrder", "least");
        this.tester.checkCheckbox("completedFilter", "all");
        this.tester.checkCheckbox("subtaskInclusion", "all");
        this.tester.submit("Next");
        for (int i = 1; i < 11; ++i) {
            this.tester.assertTextPresent("HSP-" + i);
        }
    }

    private void assertSubtaskAggregatesWithVersionAndBlank() {
        this.gotoReportConfig(10010);
        this.tester.checkCheckbox("versionId", "10011");
        this.tester.checkCheckbox("subtaskInclusion", "selectedAndBlank");
        this.tester.checkCheckbox("sortingOrder", "least");
        this.tester.checkCheckbox("completedFilter", "incomplete");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Time Tracking Report for&nbsp;Monotreme");
        this.tester.assertTextPresent("(v12)");
        this.tester.assertTextPresent("Also including sub-tasks without a version set");
        this.assertTimeReportCell(1, 3, "v12 issue");
        this.assertTimeReportCell(1, 4, "1d 6h");
        this.assertTimeReportCell(1, 5, "1d 10h 2m");
        this.assertTimeReportCell(1, 6, "1d 6h");
        this.assertTimeReportCell(1, 7, "1d 10h 1m");
        this.assertTimeReportCell(1, 8, "-");
        this.assertTimeReportCell(1, 9, "1h 3m");
        this.assertTimeReportCell(1, 10, "on track");
        this.assertTimeReportCell(1, 11, "\u20111h 2m");
        this.assertTimeReportCell(2, 3, "subtask v12");
        this.assertTimeReportCell(2, 4, "4h 1m");
        this.assertTimeReportCell(2, 5, "-");
        this.assertTimeReportCell(2, 6, "3h 59m");
        this.assertTimeReportCell(2, 7, "-");
        this.assertTimeReportCell(2, 8, "3m");
        this.assertTimeReportCell(2, 9, "-");
        this.assertTimeReportCell(2, 10, "\u20111m");
        this.assertTimeReportCell(2, 11, "-");
        this.assertTimeReportCell(3, 3, "no fixfor subtask of a v12 issue");
        this.assertTimeReportCell(3, 4, "1m");
        this.assertTimeReportCell(3, 5, "-");
        this.assertTimeReportCell(3, 6, "2m");
        this.assertTimeReportCell(3, 7, "-");
        this.assertTimeReportCell(3, 8, "1h");
        this.assertTimeReportCell(3, 9, "-");
        this.assertTimeReportCell(3, 10, "\u20111h 1m");
        this.assertTimeReportCell(3, 11, "-");
        this.assertTimeReportCell(4, 3, "Total");
        this.assertTimeReportCell(4, 4, "1d 10h 2m");
        this.assertTimeReportCell(4, 6, "1d 10h 1m");
        this.assertTimeReportCell(4, 8, "1h 3m");
        this.assertTimeReportCell(4, 10, "\u20111h 2m");
        this.assertSummaryPercentages(2, -3);
        WebTable barsSummary = this.tester.getDialog().getWebTableBySummaryOrId("bars-summary");
        this.assertions.getTableAssertions().assertTableCellHasText(barsSummary, 0, 2, "1h 3m completed from current total estimate of 1d 11h 4m");
        this.assertions.getTableAssertions().assertTableCellHasText(barsSummary, 1, 2, "Issues in this version are behind the original estimate of 1d 10h 2m by 1 hour, 2 minutes.");
    }

    @Test
    public void testPrintFormatInTimeTrackingReport() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.administration.timeTracking().switchFormat(TimeTracking.Format.DAYS);
        this.generateTimeTrackingReport(PROJECT_MONKEY_ID);
        this.tester.assertTextPresent("<b>2d 16h</b> completed from current total estimate of <b>2d 19h</b>");
        this.administration.timeTracking().switchFormat(TimeTracking.Format.HOURS);
        this.generateTimeTrackingReport(PROJECT_MONKEY_ID);
        this.tester.assertTextPresent("<b>64h</b> completed from current total estimate of <b>67h</b>");
        this.administration.timeTracking().switchFormat(TimeTracking.Format.PRETTY);
        this.generateTimeTrackingReport(PROJECT_MONKEY_ID);
        this.tester.assertTextPresent("<b>2d 16h</b> completed from current total estimate of <b>2d 19h</b>");
    }

    @Test
    public void testPrettyPrintTimeTrackingReports() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
        this.administration.timeTracking().switchFormat(TimeTracking.Format.PRETTY);
        this.generateUserWorkloadReport(10000L, "admin");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "1", "homosapien");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "1", "5 days, 19 hours, 30 minutes");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "2", "monkey");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "2", "3 hours");
        String issueKey1 = this.navigation.issue().createIssue("homosapien", "Bug", "increase HSP workload by 4 days");
        this.setOriginalEstimate(issueKey1, "4d");
        this.navigation.issue().assignIssue(issueKey1, "assigning to admin", "Administrator");
        this.generateUserWorkloadReport(10000L, "admin");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "2", "homosapien");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "2", "1 week, 2 days, 19 hours, 30 minutes");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "2", "monkey");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "2", "3 hours");
        this.navigation.issue().logWork(issueKey1, "9d");
        this.generateUserWorkloadReport(10000L, "admin");
        this.tester.assertTextPresent("5 days, 19 hours, 30 minutes");
        this.tester.assertTextPresent("5 days, 22 hours, 30 minutes");
        this.administration.timeTracking().switchFormat(TimeTracking.Format.DAYS);
        this.generateUserWorkloadReport(10000L, "admin");
        this.tester.assertTextPresent("5d 19.5h");
        this.tester.assertTextPresent("3h");
        this.tester.assertTextPresent("5d 22.5h");
        String issueKey = this.navigation.issue().createIssue("monkey", "Bug", "1");
        this.setOriginalEstimate(issueKey, "10d");
        this.generateUserWorkloadReport(PROJECT_MONKEY_ID, "admin");
        this.tester.assertTextPresent("5d 19.5h");
        this.tester.assertTextPresent("10d 3h");
        this.tester.assertTextPresent("15d 22.5h");
    }

    @Test
    public void testPrintHoursTimeTracking() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.administration.timeTracking().switchFormat(TimeTracking.Format.HOURS);
        this.generateUserWorkloadReport(10000L, "admin");
        this.tester.assertTextPresent("139.5h");
        this.tester.assertTextPresent("3h");
        this.tester.assertTextPresent("142.5h");
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Bug");
        this.setOriginalEstimate(issueKey, "2h 30m");
        this.generateUserWorkloadReport(PROJECT_MONKEY_ID, "admin");
        this.tester.assertTextPresent("145h");
        issueKey = this.navigation.issue().createIssue("monkey", "Bug", "Bug");
        this.setOriginalEstimate(issueKey, "5h");
        this.generateUserWorkloadReport(PROJECT_MONKEY_ID, "admin");
        this.tester.assertTextPresent("150h");
        this.navigation.issue().logWork(issueKey, "5h");
        this.generateUserWorkloadReport(PROJECT_MONKEY_ID, "admin");
        this.tester.assertTextPresent("145h");
    }

    @Test
    public void testTimeTrackingReport() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.administration.timeTracking().switchFormat(TimeTracking.Format.DAYS);
        this.generateTimeTrackingReport(10000L);
        this.tester.assertTextPresent("4d 8h");
        String issuekey = this.navigation.issue().createIssue("homosapien", "Bug", "Bug");
        this.setOriginalEstimate(issuekey, "3d");
        this.navigation.issue().logWork(issuekey, "3d");
        this.generateTimeTrackingReport(10000L);
        this.tester.assertTextPresent("7d 8h");
        this.administration.timeTracking().switchFormat(TimeTracking.Format.HOURS);
        this.generateTimeTrackingReport(10000L);
        this.tester.assertTextPresent("176h");
        this.tester.assertTextPresent("160h");
        issuekey = this.navigation.issue().createIssue("homosapien", "Bug", "Bug");
        this.setOriginalEstimate(issuekey, "1d");
        this.generateTimeTrackingReport(10000L);
        this.tester.assertTextPresent("184h");
        this.navigation.issue().logWork(issuekey, "1d");
        this.generateTimeTrackingReport(10000L);
        this.tester.assertTextPresent("160h");
        this.administration.timeTracking().switchFormat(TimeTracking.Format.PRETTY);
        this.generateTimeTrackingReport(10000L);
        this.tester.assertTextPresent("1w 1d 8h");
        this.tester.assertTextPresent("6d 16h");
    }

    @Test
    public void testSingleLevelGroupByReport() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:singlelevelgroupby");
        this.tester.setFormElement("filterid", "10000");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Issues {all}");
    }

    @Test
    public void testVersionIsEncoded() {
        this.administration.restoreData("TestVersionAndComponentsWithHTMLNames.xml");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking");
        try {
            this.tester.selectOption("versionId", "- \"version<input >");
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Unable to find option - \"version<input > for versionId", (Object)e.getMessage());
        }
        this.tester.selectOption("versionId", "- &quot;version&lt;input &gt;");
        this.tester.submit("Next");
        this.tester.assertTextPresent("&quot;version&lt;input &gt;");
        this.tester.assertTextNotPresent("\"version<input >");
    }

    @Test
    public void testTimeTrackingReportNotCacheable() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.tester.gotoPage("/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Atime-tracking&Next=Next&selectedProjectId=10000");
        this.assertResponseCannotBeCached();
    }

    @Test
    public void testTimeTrackingReportSorting() {
        this.administration.restoreData("TestTimeTrackingReportSorting.xml");
        this.tester.gotoPage("/browse/AA?selectedTab=com.atlassian.jira.jira-projects-plugin%3Areports-panel");
        this.tester.clickLinkWithText("Time Tracking Report");
        this.tester.selectOption("sortingOrder", "Least completed issues first");
        this.tester.selectOption("completedFilter", "All");
        this.tester.submit("Next");
        this.assertIssueOrder(new String[]{"AA-11", "AA-9", "AA-8", "AA-7", "AA-6", "AA-5", "AA-4", "AA-3", "AA-2", "AA-1", "AA-10"});
        this.tester.gotoPage("/browse/AA?selectedTab=com.atlassian.jira.jira-projects-plugin%3Areports-panel");
        this.tester.clickLinkWithText("Time Tracking Report");
        this.tester.selectOption("sortingOrder", "Most completed issues first");
        this.tester.selectOption("completedFilter", "All");
        this.tester.submit("Next");
        this.assertIssueOrder(new String[]{"AA-10", "AA-1", "AA-2", "AA-3", "AA-4", "AA-5", "AA-6", "AA-7", "AA-8", "AA-9", "AA-11"});
    }

    private void assertIssueOrder(String[] issueKeys) {
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//table[@id='timeReport']/tbody/tr/td[@class='issue-key']/a");
        Node[] nodes = xPathLocator.getNodes();
        Assert.assertEquals((long)issueKeys.length, (long)nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            String issueKey = issueKeys[i];
            Assert.assertEquals((String)("The " + i + "th row was expected to be " + issueKey), (Object)issueKey, (Object)xPathLocator.getText(nodes[i]));
        }
    }

    @Test
    public void testTimeTrackingReportConfigPageIsUnavailableWhenTimeTrackingIsDisabled() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.disableTimeTracking();
        this.gotoReportConfig(10000);
        this.assertions.forms().assertFormErrMsg("Found no available report with key 'com.atlassian.jira.jira-core-reports-plugin:time-tracking'");
    }

    @Test
    public void testTimeTrackingReportGenerationIsUnavailableWhenTimeTrackingIsDisabled() {
        this.administration.restoreData("TestTimeTrackingReport.xml");
        this.gotoReportConfig(10000);
        this.tester.selectOption("sortingOrder", "Most completed issues first");
        this.tester.selectOption("completedFilter", "All");
        this.tester.selectOption("versionId", "No Fix Version");
        this.disableTimeTracking();
        this.tester.submit("Next");
        this.assertions.forms().assertFormErrMsg("Found no available report with key 'com.atlassian.jira.jira-core-reports-plugin:time-tracking'");
    }

    @Test
    public void testReportIsTruncatedAtLimit() throws SAXException {
        String warningMessage = "Report has been truncated";
        int reportIssueLimit = 3;
        this.administration.restoreData("TestTimeTrackingReportWithSubtasksEnterprise.xml");
        this.backdoor.applicationProperties().setString("jira.timetracking.report.issues.limit", String.valueOf(3));
        this.gotoReportConfig(10010);
        this.tester.checkCheckbox("versionId", "10010");
        this.tester.checkCheckbox("subtaskInclusion", "all");
        this.tester.checkCheckbox("sortingOrder", "least");
        this.tester.checkCheckbox("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Time Tracking Report for&nbsp;Monotreme");
        this.tester.assertTextPresent("(v8)");
        this.tester.assertTextPresent("Including all sub-tasks");
        this.tester.assertTextPresent("Report has been truncated");
        WebTable table = this.tester.getDialog().getResponse().getTableWithID("timeReport");
        Assert.assertEquals((long)5L, (long)table.getRowCount());
        this.backdoor.applicationProperties().setString("jira.timetracking.report.issues.limit", "1000");
        this.gotoReportConfig(10010);
        this.tester.checkCheckbox("versionId", "10010");
        this.tester.checkCheckbox("subtaskInclusion", "all");
        this.tester.checkCheckbox("sortingOrder", "least");
        this.tester.checkCheckbox("completedFilter", "all");
        this.tester.submit("Next");
        this.tester.assertTextNotPresent("Report has been truncated");
        table = this.tester.getDialog().getResponse().getTableWithID("timeReport");
        Assert.assertEquals((long)7L, (long)table.getRowCount());
    }

    private void disableTimeTracking() {
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", false);
    }

    private void gotoReportConfig(int projectId) {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking&selectedProjectId=" + projectId);
    }

    private void assertTimeReportCell(int row, int col, String expectedText) {
        WebTable timeReport = this.tester.getDialog().getWebTableBySummaryOrId("timeReport");
        this.assertions.getTableAssertions().assertTableCellHasText(timeReport, row, col, expectedText);
    }

    private void assertSummaryPercentages(int progressPercentage, int accuracyPercentage) {
        WebTable barsSummary = this.tester.getDialog().getWebTableBySummaryOrId("bars-summary");
        this.assertions.getTableAssertions().assertTableCellHasText(barsSummary, 0, 0, "Progress: " + progressPercentage + "%");
        this.assertions.getTableAssertions().assertTableCellHasText(barsSummary, 1, 0, "Accuracy: " + accuracyPercentage + "%");
    }

    private void generateTimeTrackingReport(Long projectId) {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=" + projectId + "&reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking");
        this.tester.selectOption("sortingOrder", "Most completed issues first");
        this.tester.selectOption("completedFilter", "All");
        this.tester.selectOption("versionId", "No Fix Version");
        this.tester.submit("Next");
    }

    private void generateUserWorkloadReport(long projectId, String user) {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=" + projectId + "&reportKey=com.atlassian.jira.jira-core-reports-plugin:developer-workload");
        this.tester.setFormElement("developer", user);
        this.tester.submit("Next");
    }

    private void setOriginalEstimate(String issueKey, String originalEstimate) {
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("timetracking", originalEstimate);
        this.tester.submit("Update");
    }

    private void assertResponseCannotBeCached() {
        String cacheControl = this.tester.getDialog().getResponse().getHeaderField("Cache-control");
        String[] values = new String[]{"no-cache", "no-store", "must-revalidate"};
        if (cacheControl != null && StringUtils.isNotEmpty((CharSequence)cacheControl)) {
            boolean found = false;
            for (String value : values) {
                found = found || cacheControl.contains(value);
            }
            if (!found) {
                Assert.fail((String)"Cache-control header was set, but was not set to 'no-cache', 'no-store' or 'must-revalidate'");
            }
        } else {
            Assert.fail((String)"No Cache-control header was set in the response");
        }
    }

    private List<String> getTableRowAsList(WebTable table, int row) {
        ArrayList<String> tableRow = new ArrayList<String>();
        int maxCol = table.getColumnCount();
        for (int col = 0; col < maxCol; ++col) {
            tableRow.add(table.getCellAsText(row, col).trim());
        }
        return tableRow;
    }

    private static class Urls {
        private static final String TIMETRACKING_REPORT_DEFAULTS = "/secure/ConfigureReport.jspa?versionId=-1&sortingOrder=least&completedFilter=all&reportKey=com.atlassian.jira.jira-core-reports-plugin%3Atime-tracking&Next=Next";
        private static final String TIMETRACKING_REPORT_CONFIG = "/secure/ConfigureReport!default.jspa?reportKey=com.atlassian.jira.jira-core-reports-plugin:time-tracking";

        private Urls() {
        }
    }
}

