/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING, Category.WORKLOGS})
@LoginAs(user="admin")
@Restore(value="TestUpdateWorklog.xml")
public class TestUpdateWorklog
extends BaseJiraFuncTest {
    private static final String ADMIN_COMMENT = "Admin does some work.";
    private static final String HSP_1 = "HSP-1";
    private static final String HSP_2 = "HSP-2";
    @Inject
    private Parser parse;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private HtmlPage page;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testWorklogDoesNotExist() {
        this.getTester().gotoPage("/secure/UpdateWorklog!default.jspa?worklogId=99999&id=10000");
        this.assertions.assertNodeHasText("//div[@class='aui-message aui-message-error']", "Cannot retrieve worklog with id='99999' for update.");
    }

    @Test
    public void testWorklogNoPermToUpdate() {
        this.backdoor.permissionSchemes().removeEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_OWN_WORKLOGS);
        this.backdoor.permissionSchemes().removeEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_ALL_WORKLOGS);
        this.getTester().gotoPage("/secure/UpdateWorklog!default.jspa?worklogId=10000&id=10000");
        this.textAssertions.assertTextPresent("Access Denied");
    }

    @Test
    public void testMandatoryFields() {
        this.navigation.issue().viewIssue(HSP_1);
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "");
        this.getTester().setFormElement("startDate", "");
        this.getTester().setFormElement("newEstimate", "");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().submit();
        this.textAssertions.assertTextPresent("You must indicate the time spent working.");
        this.textAssertions.assertTextPresent("You must specify a date on which the work occurred.");
        this.textAssertions.assertTextPresent("You must supply a valid new estimate.");
    }

    @Test
    public void testInvalidFormattedDurationFields() {
        this.navigation.issue().viewIssue(HSP_1);
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "16 Candles");
        this.getTester().setFormElement("startDate", "18/Jun/07 10:49 AM");
        this.getTester().setFormElement("newEstimate", "Six Days, Seven Nights");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().submit();
        this.textAssertions.assertTextPresent("Invalid time duration entered.");
        this.textAssertions.assertTextPresent("Invalid new estimate entered.");
    }

    @Test
    public void testInvalidTimeSpentZero() {
        this.navigation.issue().viewIssue(HSP_1);
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "0");
        this.getTester().setFormElement("startDate", "18/Jun/07 10:49 AM");
        this.getTester().submit();
        this.textAssertions.assertTextPresent("Time Spent can not be zero.");
    }

    @Test
    public void testInvalidStartDateField() {
        this.navigation.issue().viewIssue(HSP_1);
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "4h");
        this.getTester().setFormElement("startDate", "The Day After Tomorrow");
        this.getTester().checkCheckbox("adjustEstimate", "leave");
        this.getTester().submit();
        this.textAssertions.assertTextPresent("You must specify a date on which the work occurred.");
    }

    @Test
    public void testUpdateTimeSpentDecreasingAutoAdjust() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10002");
        this.getTester().setFormElement("timeLogged", "1d");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"3 weeks, 3 days", "4 days"});
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "wl-10002-d"), "1 day");
    }

    @Test
    public void testUpdateTimeSpentIncreasingAutoAdjust() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "8d");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"2 weeks, 1 day", "1 week, 6 days"});
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "wl-10000-d"), "1 week, 1 day");
    }

    @Test
    public void testUpdateTimeSpentStopsAtZeroAutoAdjust() {
        this.navigation.issue().viewIssue(HSP_2);
        this.assertTextSequence(new String[]{"3 days", "2 weeks"});
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10010");
        this.getTester().setFormElement("timeLogged", "3w");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"0 minutes", "3 weeks"});
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "wl-10010-d"), "3 weeks");
    }

    @Test
    public void testUpdateStartDateOrderChanges() {
        this.navigation.issue().viewIssue(HSP_1);
        this.clickWorkLogLink();
        this.assertTextSequence(new String[]{"worklog_details_10002", "worklog_details_10001", "worklog_details_10000"});
        this.getTester().clickLink("edit_worklog_10001");
        this.getTester().setFormElement("startDate", "1/Jun/06 12:00 PM");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"worklog_details_10002", "worklog_details_10000", "worklog_details_10001"});
        this.textAssertions.assertTextPresent("1/Jun/06 12:00 PM");
    }

    @Test
    public void testUpdateTimeSpentIncreasingNoRemainingEstimateChange() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "8d");
        this.getTester().checkCheckbox("adjustEstimate", "leave");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "1 week, 6 days"});
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "wl-10000-d"), "1 week, 1 day");
    }

    @Test
    public void testUpdateTimeSpentIncreasingClobberRemainingEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "8d");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "8w");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"8 weeks", "1 week, 6 days"});
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "wl-10000-d"), "1 week, 1 day");
    }

    @Test
    public void testUpdateComment() {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("comment", "This is an updated worklog comment");
        this.getTester().submit("Log");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "wl-10000-c"), "This is an updated worklog comment");
    }

    @Test
    public void testUpdateTimeSpentAutoAdjustCreatesChangeHistory() throws SAXException {
        this.navigation.issue().viewIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "8d");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"2 weeks, 1 day", "1 week, 6 days"});
        this.getTester().clickLinkWithText("History");
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Administrator").add("Time Spent", "6 days [ 518400 ]", "1 week, 6 days [ 1123200 ]").add("Remaining Estimate", "3 weeks, 1 day [ 1900800 ]", "2 weeks, 1 day [ 1296000 ]").add("Worklog Id", "10000 [ 10000 ]", "");
        ChangeHistoryList list = this.parse.issue().parseChangeHistory();
        list.assertContainsSomeOf(expectedList);
    }

    @Test
    public void testUpdateWorklogSecurityLevels() {
        Assert.assertTrue((boolean)this.canUserSeeComment("mel", ADMIN_COMMENT));
        Assert.assertTrue((boolean)this.canUserSeeComment("fred", ADMIN_COMMENT));
        this.navigation.issue().viewIssue(HSP_1);
        this.clickWorkLogLink();
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "1d");
        this.getTester().selectOption("commentLevel", "jira-developers");
        this.getTester().submit("Log");
        Assert.assertTrue((boolean)this.canUserSeeComment("fred", ADMIN_COMMENT));
        Assert.assertFalse((boolean)this.canUserSeeComment("mel", ADMIN_COMMENT));
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "1d");
        this.getTester().selectOption("commentLevel", "Specialist");
        this.getTester().submit("Log");
        Assert.assertFalse((boolean)this.canUserSeeComment("fred", ADMIN_COMMENT));
        Assert.assertTrue((boolean)this.canUserSeeComment("mel", ADMIN_COMMENT));
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("edit_worklog_10000");
        this.getTester().setFormElement("timeLogged", "1d");
        this.getTester().selectOption("commentLevel", "jira-users");
        this.getTester().submit("Log");
        Assert.assertTrue((boolean)this.canUserSeeComment("mel", ADMIN_COMMENT));
        Assert.assertTrue((boolean)this.canUserSeeComment("fred", ADMIN_COMMENT));
    }

    @Test
    public void testManuallyAdjustEstimateOptionNotAvailable() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLinkWithText("Work Log");
        this.getTester().clickLink("edit_worklog_10001");
        this.textAssertions.assertTextPresent("id=\"log-work-adjust-estimate-auto\"");
        this.textAssertions.assertTextNotPresent("id=\"log-work-adjust-estimate-manual\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canUserSeeComment(String user, String comment) {
        try {
            this.navigation.logout();
            this.navigation.login(user, user);
            this.logger.log((Object)("Checking if " + user + " can see comment '" + comment + "'"));
            this.navigation.issue().viewIssue(HSP_1);
            this.clickWorkLogLink();
            boolean bl = this.getTester().getDialog().isTextInResponse(comment);
            return bl;
        }
        finally {
            this.navigation.login("admin");
        }
    }

    private void clickWorkLogLink() {
        if (this.page.isLinkPresentWithExactText("Work Log")) {
            this.getTester().clickLinkWithText("Work Log");
        }
    }

    private void assertTextSequence(String[] strings) {
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), strings);
    }
}

