/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.DevMode;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING, Category.WORKLOGS})
@LoginAs(user="admin")
@DevMode(enabled=false)
public class TestWorkLogTabPanelVisibility
extends BaseJiraFuncTest {
    private static final String BUG = "HSP-1";
    private static final String NEW_FEATURE = "HSP-2";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreDataWithLicense("TestWorkLogVisibility.xml", LicenseKeys.COMMERCIAL.getLicenseString());
    }

    @Test
    public void testWorkLogTabPanelVisibility() {
        this.navigation.issue().viewIssue(BUG);
        this.assertTabLinkPresent();
        this.navigation.issue().viewIssue(NEW_FEATURE);
        this.assertTabLinkNotPresent();
        this.flipVisibilityInFieldConfigEnterprise();
        this.navigation.issue().viewIssue(BUG);
        this.assertTabLinkNotPresent();
        this.navigation.issue().viewIssue(NEW_FEATURE);
        this.assertTabLinkPresent();
    }

    @Test
    public void testDirectUrlAccessTakesVisibilityIntoAccount() {
        this.assertTabPresent(BUG);
        this.assertTabNotPresent(NEW_FEATURE);
        this.flipVisibilityInFieldConfigEnterprise();
        this.assertTabNotPresent(BUG);
        this.assertTabPresent(NEW_FEATURE);
    }

    private void flipVisibilityInFieldConfigEnterprise() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("configure-Default Field Configuration");
        this.tester.clickLink("show_20");
        this.tester.clickLink("view_fieldlayouts");
        this.tester.clickLink("configure-Bug Field Configuration");
        this.tester.clickLink("hide_20");
    }

    private void assertTabPresent(String issueKey) {
        this.tester.gotoPage("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        this.textAssertions.assertTextSequence(this.locator.page(), new String[]{"Time Spent", BUG.equals(issueKey) ? "2 hours" : "1 hour", "No comment"});
    }

    private void assertTabNotPresent(String issueKey) {
        this.tester.gotoPage("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        this.tester.assertTextNotPresent("Time Spent");
        this.tester.assertTextNotPresent(BUG.equals(issueKey) ? "2 hours" : "1 hour");
        this.tester.assertTextNotPresent("No comment");
    }

    private void assertTabLinkNotPresent() {
        this.tester.assertLinkNotPresentWithText("Work Log");
    }

    private void assertTabLinkPresent() {
        this.tester.assertLinkPresentWithText("Work Log");
    }
}

