/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING})
@LoginAs(user="admin")
public class TestTimeTrackingInputValidation
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestTimeTrackingBase.xml");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("8", "5", "pretty", "hour", TimeTracking.Mode.MODERN);
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
    }

    @Test
    public void testTimeTrackingFieldRejectsRubbish() {
        this.navigation.issue().setOriginalEstimate("HSP-5", "[@asksajm1541%<><><<<();>)");
        this.textAssertions.assertTextPresent("The original estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate("HSP-5", "[#s#~@^%&&*^&*ksajm1541%<><><<<();>)");
        this.textAssertions.assertTextPresent("The remaining estimate specified is not valid.");
    }

    @Test
    public void testTimeTrackingAcceptsFractionalValues() {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "testTimeTrackingAcceptsFractionalValues");
        this.navigation.issue().setOriginalEstimate(key, "7.15h");
        this.navigation.issue().setRemainingEstimate(key, "7.15h");
        this.textAssertions.assertTextSequence(new IdLocator(this.getTester(), "tt_single_table_info"), "Estimated:", "7h 9m", "Remaining:", "7h 9m");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("8", "5", "hours", "hour", TimeTracking.Mode.MODERN);
        this.navigation.issue().viewIssue(key);
        this.textAssertions.assertTextSequence(new IdLocator(this.getTester(), "tt_single_table_info"), "Estimated:", "7.15h", "Remaining:", "7.15h");
        this.navigation.issue().setRemainingEstimate(key, "12m");
        this.textAssertions.assertTextSequence(new IdLocator(this.getTester(), "tt_single_table_info"), "Estimated:", "7.15h", "Remaining:", "0.2h");
        this.navigation.issue().setRemainingEstimate(key, "20m");
        this.textAssertions.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_orig"), "7.15h");
        this.textAssertions.assertTextPresent(new IdLocator(this.getTester(), "tt_single_values_remain"), "20m");
    }

    @Test
    public void testTimeTrackingRejectsInvalidTimeUnitSuffixes() {
        this.navigation.issue().setOriginalEstimate("HSP-5", "1y");
        this.textAssertions.assertTextPresent("The original estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate("HSP-5", "1ms");
        this.textAssertions.assertTextPresent("The remaining estimate specified is not valid.");
    }

    @Test
    public void testTimeTrackingAcceptsMoreThanOneEntryQualifiedByTheSameTimeUnit() {
        this.navigation.issue().setOriginalEstimate("HSP-5", "1w 2w");
        this.textAssertions.assertTextNotPresent("The original estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate("HSP-5", "1h 30h");
        this.textAssertions.assertTextNotPresent("The remaining estimate specified is not valid.");
    }

    @Test
    public void testTimeTrackingRejectsTimeUnitsNotQualifiedByANumber() {
        this.navigation.issue().setOriginalEstimate("HSP-5", "w 2d");
        this.textAssertions.assertTextPresent("The original estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate("HSP-5", "1h s");
        this.textAssertions.assertTextPresent("The remaining estimate specified is not valid.");
    }

    @Test
    public void testTimeTrackingAcceptsMoreThanOneEmptyTimeUnitSuffix() {
        this.navigation.issue().setOriginalEstimate("HSP-5", "6 10");
        this.textAssertions.assertTextPresent("The original estimate specified is not valid.");
        this.navigation.issue().setRemainingEstimate("HSP-5", "5 30");
        this.textAssertions.assertTextPresent("The remaining estimate specified is not valid.");
    }
}

