/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING})
@LoginAs(user="admin")
public class TestTimeTrackingIsEditableByUpdateIssueFieldFunction
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestTimeTrackingUpdateIssueFieldFunction.xml");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
    }

    @Test
    public void testCanEditRemainingEstimateOnResolve() {
        this.navigation.issue().resolveIssue("HSP-1", "Fixed", "Resolving the Issue as Fixed. This should set the remaining estimate to 0");
        this.assertTimeTrackingValuesAreEqualTo("1w", "0m", "3d");
    }

    @Test
    public void testCanEditOriginalEstimateOnClose() {
        this.navigation.issue().closeIssue("HSP-4", "Won't Fix", "Closing the Issue as Won't Fix. This should set the original estimate to 0");
        this.assertTimeTrackingValuesAreEqualTo("0m", "0m", "1w");
    }

    @Test
    public void testCanEditOriginalAndRemainingEstimateOnReopen() {
        this.navigation.issue().reopenIssue("HSP-2");
        this.assertTimeTrackingValuesAreEqualTo("2h", "2h", "Not Specified");
    }

    private void assertTimeTrackingValuesAreEqualTo(String originalEstimateValue, String remainingEstimateValue, String timeSpentValue) {
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_single_values_orig"), originalEstimateValue);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_single_values_remain"), remainingEstimateValue);
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "tt_single_values_spent"), timeSpentValue);
    }
}

