/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import java.util.LinkedList;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.springframework.ldap.core.support.LdapContextSource;

public class LdapOperationsHelper {
    private String server;
    private String userDn;
    private String password;
    private String baseDn;
    private boolean isActiveDirectory;

    public LdapOperationsHelper(String server, String userDn, String password, String baseDn, boolean activeDirectory) {
        this.server = server;
        this.userDn = userDn;
        this.password = password;
        this.baseDn = baseDn;
        this.isActiveDirectory = activeDirectory;
    }

    public DirContext setupLdapContext() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl((this.isActiveDirectory ? "ldaps://" : "ldap://") + this.server + ":" + (this.isActiveDirectory ? "636" : "389"));
        contextSource.setBase(this.baseDn);
        contextSource.setUserDn(this.userDn);
        contextSource.setPassword(this.password);
        contextSource.setPooled(true);
        try {
            contextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contextSource.getContext(this.userDn, this.password);
    }

    public void renameUser(String oldName, String newName) throws NamingException {
        DirContext ctx = this.setupLdapContext();
        ctx.rename("cn=" + oldName, "cn=" + newName);
        if (this.isActiveDirectory) {
            BasicAttributes attributes = new BasicAttributes();
            attributes.put("sAMAccountName", newName);
            ctx.modifyAttributes("cn=" + newName, 2, (Attributes)attributes);
        }
    }

    public void removeUser(String username) throws NamingException {
        DirContext ctx = this.setupLdapContext();
        ctx.unbind("cn=" + username);
    }

    public List<String> getListOfUsers() {
        DirContext ctx = this.setupLdapContext();
        LinkedList<String> list = new LinkedList<String>();
        NamingEnumeration<SearchResult> results = null;
        try {
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            results = ctx.search("", "(objectclass=person)", controls);
            while (results.hasMore()) {
                SearchResult searchResult = results.next();
                Attributes attributes = searchResult.getAttributes();
                Attribute attr = attributes.get("cn");
                String cn = (String)attr.get();
                list.add(cn);
            }
        }
        catch (NameNotFoundException controls) {
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception exception) {}
            }
        }
        return list;
    }
}

