/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.tpm.ldap.LdapUtil;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestTpmLdap
extends BaseJiraFuncTest {
    private static final String CARTOON_CHARACTERS_GROUP = "cartoon-characters";
    private static final String WILMA_USERNAME = "wilma";
    @Inject
    protected Administration administration;
    @Inject
    protected FuncTestLogger logger;
    @Inject
    protected Assertions assertions;
    @Inject
    protected LdapUtil ldapUtil;

    @Before
    public void createDirectory() throws InterruptedException {
        this.ldapUtil.createLdapDirectory();
    }

    @Test
    public void testAddAndDeleteUser() {
        if (this.assertions.getUserAssertions().userExists(WILMA_USERNAME)) {
            this.logger.log((Object)"User wilma was found - attempting to clean up before running test.");
            this.deleteUser(WILMA_USERNAME);
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist(WILMA_USERNAME);
        this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
        this.tester.setFormElement("username", WILMA_USERNAME);
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists(WILMA_USERNAME);
        this.assertions.getUserAssertions().assertUserDetails(WILMA_USERNAME, "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.deleteUser(WILMA_USERNAME);
        this.assertions.getUserAssertions().assertUserDoesNotExist(WILMA_USERNAME);
    }

    @Test
    public void testAddAndDeleteGroup() {
        this.assertions.getUserAssertions().assertGroupDoesNotExist("newGroup");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", "newGroup");
        this.tester.submit("add_group");
        this.tester.assertTextNotPresent("Error occurred adding group");
        this.assertions.getUserAssertions().assertGroupExists("newGroup");
        this.deleteGroup("newGroup");
        this.assertions.getUserAssertions().assertGroupDoesNotExist("newGroup");
    }

    @Test
    public void testLoginAsLdapUser() {
        this.setupUserWilma();
        this.navigation.logout();
        this.navigation.loginAttempt(WILMA_USERNAME, "fail");
        this.tester.assertTextPresent("your username and password are incorrect");
        this.navigation.login(WILMA_USERNAME, "password");
        this.tester.clickLink("header-details-user-fullname");
        this.assertions.assertNodeByIdHasText("up-user-title-name", "Wilma Flintstone");
        this.navigation.logout();
        this.navigation.login("admin");
        this.deleteUser(WILMA_USERNAME);
    }

    @Test
    public void testEditUser() {
        this.setupUserWilma();
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.setFormElement("userSearchFilter", "wil");
        this.tester.submit("");
        this.tester.clickLink("edituser_link_wilma");
        this.tester.setFormElement("fullname", "Betty Rubble");
        this.tester.setFormElement("email", "betty@example.com");
        this.tester.submit("Update");
        this.assertions.getUserAssertions().assertUserDetails(WILMA_USERNAME, "Betty Rubble", "betty@example.com", "LDAP Directory");
        this.deleteUser(WILMA_USERNAME);
    }

    @Test
    public void testAddAndRemoveUserToGroup() {
        this.setupUserWilma();
        this.addGroup(CARTOON_CHARACTERS_GROUP);
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.administration.usersAndGroups().addUserToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.assertions.getUserAssertions().assertUserBelongsToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.administration.usersAndGroups().removeUserFromGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("fred", CARTOON_CHARACTERS_GROUP);
        this.administration.usersAndGroups().addUserToGroup("fred", CARTOON_CHARACTERS_GROUP);
        this.assertions.getUserAssertions().assertUserBelongsToGroup("fred", CARTOON_CHARACTERS_GROUP);
        this.administration.usersAndGroups().removeUserFromGroup("fred", CARTOON_CHARACTERS_GROUP);
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup("fred", CARTOON_CHARACTERS_GROUP);
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup(WILMA_USERNAME, "jira-developers");
        this.administration.usersAndGroups().addUserToGroup(WILMA_USERNAME, "jira-developers");
        this.assertions.getUserAssertions().assertUserBelongsToGroup(WILMA_USERNAME, "jira-developers");
        this.administration.usersAndGroups().removeUserFromGroup(WILMA_USERNAME, "jira-developers");
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup(WILMA_USERNAME, "jira-developers");
        this.deleteUser(WILMA_USERNAME);
        this.deleteGroup(CARTOON_CHARACTERS_GROUP);
    }

    @Test
    public void testDeleteUserDoesNotRetainGroupMembership() throws Exception {
        this.setupUserWilma();
        this.addGroup(CARTOON_CHARACTERS_GROUP);
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.administration.usersAndGroups().addUserToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.assertions.getUserAssertions().assertUserBelongsToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.deleteUser(WILMA_USERNAME);
        this.setupUserWilma();
        this.ldapUtil.synchroniseDirectory(1);
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.deleteUser(WILMA_USERNAME);
        this.deleteGroup(CARTOON_CHARACTERS_GROUP);
    }

    @Test
    public void testDeleteUserWhenDirectoriesOverlap() {
        this.setupUserWilma();
        this.addGroup(CARTOON_CHARACTERS_GROUP);
        this.administration.usersAndGroups().addUserToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Disable"));
        this.assertions.getTextAssertions().assertTextPresent("LDAP Directory</span>  <em>(inactive)</em>");
        this.assertions.getUserAssertions().assertUserDoesNotExist(WILMA_USERNAME);
        this.setupUserWilma(this.ldapUtil.getInternalDirectoryName());
        this.assertions.getUserAssertions().assertUserDoesNotBelongToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.administration.usersAndGroups().addUserToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Enable"));
        this.assertions.getTextAssertions().assertTextNotPresent("LDAP Directory</span>  <em>(inactive)</em>");
        this.deleteUser(WILMA_USERNAME);
        this.assertions.getUserAssertions().assertUserExists(WILMA_USERNAME);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Disable"));
        this.assertions.getTextAssertions().assertTextPresent("LDAP Directory</span>  <em>(inactive)</em>");
        this.assertions.getUserAssertions().assertUserBelongsToGroup(WILMA_USERNAME, CARTOON_CHARACTERS_GROUP);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Enable"));
        this.deleteUser(WILMA_USERNAME);
        this.deleteGroup(CARTOON_CHARACTERS_GROUP);
    }

    private void setupUserWilma() {
        this.setupUserWilma("LDAP Directory");
    }

    private void setupUserWilma(String expectedDirectory) {
        if (this.assertions.getUserAssertions().userExists(WILMA_USERNAME)) {
            this.logger.log((Object)"User wilma was found - attempting to clean up before running test.");
            this.deleteUser(WILMA_USERNAME);
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist(WILMA_USERNAME);
        this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
        this.tester.setFormElement("username", WILMA_USERNAME);
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists(WILMA_USERNAME);
        this.assertions.getUserAssertions().assertUserDetails(WILMA_USERNAME, "Wilma Flintstone", "wilma@bedrock.com", expectedDirectory);
    }

    private void deleteUser(String username) {
        this.gotoViewUser(username);
        this.tester.clickLink("deleteuser_link");
        this.tester.submit("Delete");
    }

    private void gotoViewUser(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
    }

    private void addGroup(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", name);
        this.tester.submit("add_group");
        this.tester.assertTextNotPresent("Error occurred adding group");
        this.assertions.getUserAssertions().assertGroupExists(name);
    }

    private void deleteGroup(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("nameFilter", name);
        this.tester.submit("filter");
        this.tester.clickLink("del_" + name);
        this.tester.submit("Delete");
    }
}

