/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.tpm.ldap.LdapUtil;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebTable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestTpmLdapAdvanced
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;
    @Inject
    protected FuncTestLogger logger;
    @Inject
    protected Assertions assertions;
    @Inject
    protected LdapUtil ldapUtil;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void createDirectory() throws InterruptedException {
        this.ldapUtil.createLdapDirectory();
    }

    @Test
    public void testDisabledDirectory() throws Exception {
        String userName = "wilma";
        this.addUser("wilma", "password");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Disable"));
        this.assertions.getTextAssertions().assertTextPresent("LDAP Directory</span>  <em>(inactive)</em>");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Enable"));
        this.assertions.getTextAssertions().assertTextNotPresent("LDAP Directory (inactive)");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.deleteUser("wilma");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
    }

    @Test
    public void testSynchroniseDirectoryAfterEncryptionAlgorithmChange() throws Exception {
        String enabledEncryption = this.administration.advancedApplicationProperties().getApplicationProperty("crowd.encryption.encryptor.default");
        Assert.assertEquals((Object)"AES_CBC_PKCS5Padding", (Object)enabledEncryption);
        this.changeEncryptionAlgorithmAndCheckSynchronization("DES_CBC_PKCS5Padding");
        this.changeEncryptionAlgorithmAndCheckSynchronization("BASE64");
        this.changeEncryptionAlgorithmAndCheckSynchronization("DISABLED");
        this.administration.advancedApplicationProperties().setApplicationProperty("crowd.encryption.encryptor.default", "AES_CBC_PKCS5Padding");
    }

    @Test
    public void testSynchroniseDirectory() throws Exception {
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.logger.log((Object)"User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.ldapUtil.synchroniseDirectory(1);
        this.assertions.getTextAssertions().assertTextNotPresent("Never synchronised");
        if (this.ldapUtil.isActiveDirectory()) {
            this.logger.log((Object)"Attempting to add an Active Directory LDAP User Directory...");
            this.addActiveDirectory("LDAP Directory 2");
        } else {
            this.logger.log((Object)"Attempting to add an Open LDAP User Directory...");
            this.addOpenLdap("LDAP Directory 2");
        }
        WebTable table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "LDAP Directory");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 1, this.ldapUtil.getInternalDirectoryName());
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 1, "LDAP Directory 2");
        this.ldapUtil.synchroniseDirectory(3);
        this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
        this.tester.setFormElement("username", "wilma");
        this.tester.selectOption("directoryId", "LDAP Directory");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Disable"));
        this.assertions.getTextAssertions().assertTextPresent("LDAP Directory</span>  <em>(inactive)</em>");
        this.ldapUtil.synchroniseDirectory(3);
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory 2");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Enable"));
        this.assertions.getTextAssertions().assertTextNotPresent("LDAP Directory  <em>(inactive)</em>");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 3, "Disable"));
        this.navigation.clickLinkWithPost(UserDirectoryTable.getDirectoryListActionLink(this.tester, 3, "Remove"));
        this.deleteUser("wilma");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
    }

    @Test
    public void directorySynchronisationShouldWorkAfterSettingsHaveBeenEdit() throws Exception {
        boolean directoryPositionInList = true;
        String userName = "wilma";
        String password = "password";
        this.addUser("wilma", "password");
        this.ldapUtil.synchroniseDirectory(1);
        this.editSynchronisationSettings(1);
        this.testNewSettings("wilma");
        this.ldapUtil.synchroniseDirectory(1);
        this.testUserCanAuthenticate("wilma", "password");
    }

    private void addUser(String userName, String password) {
        if (this.assertions.getUserAssertions().userExists(userName)) {
            this.logger.log((Object)("User" + userName + "was found - attempting to clean up before running test."));
            this.deleteUser(userName);
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist(userName);
        this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
        this.tester.setFormElement("username", userName);
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", password);
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists(userName);
        this.assertions.getUserAssertions().assertUserDetails(userName, "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
    }

    private void editSynchronisationSettings(int directoryPositionInList) {
        this.openEditDirectorySettingsPage(directoryPositionInList);
        this.editAnyPropertyToTriggerUpdateOnDirectorySettings();
    }

    private void openEditDirectorySettingsPage(int directoryPositionInList) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.logger.log((Object)("Attempting to edit Directory " + directoryPositionInList));
        this.navigation.clickLink(UserDirectoryTable.getDirectoryListActionLink(this.tester, 1, "Edit"));
    }

    private void editAnyPropertyToTriggerUpdateOnDirectorySettings() {
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        String currentValue = this.tester.getDialog().getFormParameterValue("ldapPermissionOption");
        String newValue = currentValue.equals("READ_WRITE") ? "READ_ONLY" : "READ_WRITE";
        this.tester.setFormElement("ldapPermissionOption", newValue);
        this.tester.submit("save");
    }

    private void testNewSettings(String userName) {
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Test Remote Directory Connection");
        this.tester.setWorkingForm("troubleshoot-directory-form");
        this.tester.setFormElement("username", userName);
        this.tester.submit("test");
        this.testAllChecksSucceeded();
    }

    private void testAllChecksSucceeded() {
        ImmutableMap.of((Object)"connect", (Object)"Test basic connection : Succeeded", (Object)"get.user", (Object)"Test retrieve user : Succeeded", (Object)"get.memberships", (Object)"Test get user's memberships : Succeeded, 1 groups retrieved", (Object)"get.group", (Object)"Test retrieve group : Succeeded", (Object)"get.members", (Object)"Test get group members : Succeeded, 1 users retrieved", (Object)"authenticate", (Object)"Test user can authenticate : Not performed").entrySet().stream().forEach(test -> this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embedded.crowd.directory.test." + (String)test.getKey()), (String)test.getValue()));
    }

    private void testUserCanAuthenticate(String userName, String password) {
        this.navigation.logout();
        this.navigation.login(userName, password);
    }

    private void changeEncryptionAlgorithmAndCheckSynchronization(String algorithm) throws Exception {
        this.administration.advancedApplicationProperties().setApplicationProperty("crowd.encryption.encryptor.default", algorithm);
        String encryptionAfterChange = this.administration.advancedApplicationProperties().getApplicationProperty("crowd.encryption.encryptor.default");
        Assert.assertEquals((Object)algorithm, (Object)encryptionAfterChange);
        this.testSynchroniseDirectory();
    }

    private void addActiveDirectory(String name) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", name);
        this.tester.selectOption("type", "Microsoft Active Directory");
        this.tester.setFormElement("hostname", this.ldapUtil.getLdapServer());
        this.tester.setFormElement("port", "636");
        this.tester.checkCheckbox("useSSL", "true");
        this.tester.setFormElement("ldapUserdn", this.ldapUtil.getUserDn());
        this.tester.setFormElement("ldapPassword", this.ldapUtil.getPassword());
        this.tester.setFormElement("ldapBasedn", this.ldapUtil.getBaseDn());
        this.tester.setFormElement("ldapUserObjectclass", "user");
        this.tester.setFormElement("ldapUserFilter", "(&(objectCategory=Person)(sAMAccountName=*))");
        this.tester.setFormElement("ldapUserUsername", "sAMAccountName");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "unicodePwd");
        this.tester.setFormElement("ldapGroupObjectclass", "group");
        this.tester.setFormElement("ldapGroupFilter", "x");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "member");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.ldapUtil.assertExtendedTestPageAndReturnToDirectoryList();
    }

    private void addOpenLdap(String name) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.textAssertions.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", name);
        this.tester.selectOption("type", "OpenLDAP");
        this.tester.setFormElement("hostname", this.ldapUtil.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapUserdn", this.ldapUtil.getUserDn());
        this.tester.setFormElement("ldapBasedn", this.ldapUtil.getBaseDn());
        this.tester.setFormElement("ldapPassword", this.ldapUtil.getPassword());
        this.tester.setFormElement("ldapUserObjectclass", "inetorgperson");
        this.tester.setFormElement("ldapUserFilter", "(objectclass=inetorgperson)");
        this.tester.setFormElement("ldapUserUsername", "cn");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "userPassword");
        this.tester.setFormElement("ldapGroupObjectclass", "groupOfUniqueNames");
        int DirectoryAttributeValueLength = 3997;
        String longLdapGroupFilter = "(&" + StringUtils.repeat((String)"(objectclass=groupOfUniqueNames)", (int)(DirectoryAttributeValueLength / "(objectclass=groupOfUniqueNames)".length())) + ")";
        this.tester.setFormElement("ldapGroupFilter", longLdapGroupFilter);
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "uniqueMember");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.submit("test");
        this.textAssertions.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.ldapUtil.assertExtendedTestPageAndReturnToDirectoryList();
    }

    private void deleteUser(String username) {
        this.gotoViewUser(username);
        this.tester.clickLink("deleteuser_link");
        this.tester.submit("Delete");
    }

    private void gotoViewUser(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
    }
}

