/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.upgrade.ImmediateUpgradeTasksJsonBean;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70101;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build70102;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build800004;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build900000;
import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build900001;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST})
public class TestImmediateUpgradeTask
extends BaseJiraFuncTest {
    private static final ImmutableList<String> ALLOWED_IMMEDIATE_UPGRADE_TASKS = ImmutableList.of((Object)UpgradeTask_Build70101.class.getSimpleName(), (Object)UpgradeTask_Build70102.class.getSimpleName(), (Object)UpgradeTask_Build800004.class.getSimpleName(), (Object)UpgradeTask_Build900000.class.getSimpleName(), (Object)UpgradeTask_Build900001.class.getSimpleName());

    @Test
    public void checkImmediateTasksBreakingZDU() {
        ImmediateUpgradeTasksJsonBean immediateUpgradeTasksJsonBean = this.backdoor.upgradeControl().getImmediateUpgradeTasks();
        List<String> immediateTasks = immediateUpgradeTasksJsonBean.getImmediateUpgradeTasksNames();
        immediateTasks.removeAll((Collection<?>)ALLOWED_IMMEDIATE_UPGRADE_TASKS);
        MatcherAssert.assertThat((String)"Immediate tasks are allowed in platform releases only. They're ZDU breaking because no immediate tasks should run in the mixed mode.", immediateTasks, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }
}

