/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.admin.user.ViewUserPage;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@RestoreBlankInstance
public class TestAddUser
extends EmailBaseFuncTestCase {
    private static final String CREATE_USER_SUBMIT = "Create";
    private static final String TEST_USERNAME = "user1";
    private static final String TEST_FULL_NAME = "User1 Tested";
    private static final String TEST_EMAIL = "username1@email.com";
    private static final String TEST_PASSWORD = "evilwoman1";
    private static final String TEST_USERNAME_2 = "user2";
    private static final String TEST_FULL_NAME_2 = "User2 Tested";
    private static final String TEST_EMAIL_2 = "username2@email.com";
    private static final String CREATE_NEW_USER = "Create new user";
    @Inject
    protected TextAssertions textAssertions;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Assertions assertions;

    @Test
    @LoginAs(user="admin")
    public void formDecoratesEmptyDataWithMessages() {
        this.buildUser("", "", "");
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent(CREATE_NEW_USER);
        this.tester.assertTextPresent("You must specify a username.");
        this.tester.assertTextPresent("You must specify a full name.");
        this.tester.assertTextPresent("You must specify an email address.");
    }

    @Test
    @LoginAs(user="admin")
    public void systemRejectsDuplicateUserCreation() {
        this.checkSuccessUserCreate(false);
        this.buildUser(TEST_USERNAME, TEST_FULL_NAME, TEST_EMAIL);
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent("A user with that username already exists.");
    }

    @Test
    @LoginAs(user="admin")
    public void createAnotherRedirToItselfWithCheckboxPrechecked() {
        this.checkSuccessUserCreate(false, true);
        this.tester.assertFormElementEquals("createAnother", "true");
        this.setUpUser(TEST_USERNAME_2, TEST_FULL_NAME_2, TEST_EMAIL_2);
        this.tester.uncheckCheckbox("createAnother");
        this.tester.submit(CREATE_USER_SUBMIT);
        this.assertRedirectToUserBrowserAfterUserCreation(TEST_USERNAME, TEST_USERNAME_2);
        this.assertSuccessUserCreate(TEST_USERNAME_2, TEST_FULL_NAME_2, TEST_EMAIL_2);
    }

    @Test
    @LoginAs(user="admin")
    public void createUserSuccessPath() {
        this.checkSuccessUserCreate(false);
    }

    @Test
    @LoginAs(user="admin")
    public void systemRejectsInvalidEmail() {
        this.buildUser(TEST_USERNAME, TEST_FULL_NAME, "username.email.com");
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent("You must specify a valid email address.");
    }

    @Test
    @LoginAs(user="admin")
    public void testCreateUserPassword() {
        this.buildUser(TEST_USERNAME, TEST_FULL_NAME, TEST_EMAIL);
        this.tester.setFormElement("password", "password");
        this.tester.submit(CREATE_USER_SUBMIT);
        this.assertRedirectToUserBrowserAfterUserCreation(TEST_USERNAME);
        this.assertSuccessUserCreate(TEST_USERNAME, TEST_FULL_NAME, TEST_EMAIL);
    }

    @Test
    @LoginAs(user="fred")
    public void testNoPermission() {
        this.tester.gotoPage("http://localhost:8090/jira/secure/admin/user/AddUser!default.jspa");
        this.tester.assertTextPresent("Welcome to jWebTest JIRA installation");
        this.tester.assertTextNotPresent("Project: newproject");
        this.tester.assertTextNotPresent("Add a new project");
    }

    @Test
    @LoginAs(user="admin")
    public void createUserEmailIsSent() throws Exception {
        this.configureAndStartSmtpServer();
        this.checkSuccessUserCreate(true);
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        Assert.assertEquals((long)1L, (long)mimeMessages.length);
        MimeMessage msg = mimeMessages[0];
        msg.getContent();
        this.assertEmailBodyContainsLine(msg, ".*user1.*");
        this.assertEmailBodyContainsLine(msg, ".*User1 Tested.*");
        this.assertEmailBodyContains(msg, TEST_EMAIL);
        this.assertEmailBodyContains(msg, "Get started by setting your own password and logging in");
        this.assertEmailBodyContains(msg, "secure/ResetPassword!default.jspa?os_username=user1&amp;token=");
        this.assertEmailBodyDoesntContain(msg, TEST_PASSWORD);
    }

    private void buildUser(String username, String fullName, String email) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("create_user");
        this.setUpUser(username, fullName, email);
    }

    public void setUpUser(String username, String fullName, String email) {
        this.tester.assertTextPresent(CREATE_NEW_USER);
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("fullname", fullName);
        this.tester.setFormElement("email", email);
    }

    private void checkSuccessUserCreate(boolean sendEmail) {
        this.checkSuccessUserCreate(sendEmail, false);
    }

    private void checkSuccessUserCreate(boolean sendEmail, boolean createAnother) {
        this.buildUser(TEST_USERNAME, TEST_FULL_NAME, TEST_EMAIL);
        this.tester.setFormElement("password", TEST_PASSWORD);
        if (sendEmail) {
            this.tester.checkCheckbox("sendEmail", "true");
        }
        if (createAnother) {
            this.tester.checkCheckbox("createAnother", "true");
        } else {
            this.tester.assertCheckboxNotSelected("createAnother");
        }
        this.tester.submit(CREATE_USER_SUBMIT);
        if (!createAnother) {
            this.tester.assertTextPresent(TEST_FULL_NAME);
            this.assertRedirectToUserBrowserAfterUserCreation(TEST_USERNAME);
            this.assertSuccessUserCreate(TEST_USERNAME, TEST_FULL_NAME, TEST_EMAIL);
        }
    }

    private void assertRedirectToUserBrowserAfterUserCreation(String ... createdUsers) {
        String params = Arrays.stream(createdUsers).map(s -> String.format("createdUser=%s", s)).collect(Collectors.joining("&"));
        Assert.assertEquals((Object)(Navigation.AdminSection.USER_BROWSER.getUrl() + "?" + params + "#userCreatedFlag"), (Object)this.navigation.getCurrentPage());
    }

    private void assertSuccessUserCreate(String username, String fullName, String email) {
        this.navigation.gotoPageWithParams(ViewUserPage.class, ViewUserPage.generateViewUserQueryParameters(username));
        this.tester.assertTextPresent("User: " + fullName);
        String[] userDetails = new String[]{"Username:", username, "Full name:", fullName, "Email:", email};
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), userDetails);
    }

    @Test
    @LoginAs(user="admin")
    public void testNewUsersNotAddedToNestedGroups() {
        try {
            this.addEditNestedGroups();
            this.checkSuccessUserCreate(false);
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.clickLink(TEST_USERNAME);
            this.tester.assertTextPresent("jira-users");
            this.tester.assertTextNotPresent("accounts");
            this.tester.assertTextNotPresent("sales");
            this.tester.assertTextNotPresent("customer-service");
        }
        finally {
            this.resetAdminPassword();
        }
    }

    private void addEditNestedGroups() {
        this.toggleNestedGroups(true);
        this.addGroup("accounts");
        this.addGroup("sales");
        this.addGroup("customer-service");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.clickLink("edit_nested_groups");
        this.tester.assertTextPresent("This page allows you to edit nested group memberships.");
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("selectedGroupsStr", "jira-users");
        this.selectMultiOption("childrenToAssignStr", "accounts");
        this.selectMultiOption("childrenToAssignStr", "sales");
        this.selectMultiOption("childrenToAssignStr", "customer-service");
        this.tester.submit("assign");
    }

    public void selectMultiOption(String selectName, String option) {
        String value = this.tester.getDialog().getValueForOption(selectName, option);
        this.tester.checkCheckbox(selectName, value);
    }

    private void addGroup(String groupName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", groupName);
        this.tester.submit("add_group");
    }

    public void toggleNestedGroups(boolean enable) {
        this.navigation.gotoAdmin();
        this.tester.gotoPage("/plugins/servlet/embedded-crowd/directories/list");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this, this.logger, this.assertions);
        WebLink link = userDirectoryTable.getTableCell(1, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        if (enable) {
            this.tester.checkCheckbox("nestedGroupsEnabled", "true");
        } else {
            this.tester.checkCheckbox("nestedGroupsEnabled", "false");
        }
        this.tester.submit("save");
    }

    public void resetAdminPassword() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("admin");
        this.tester.clickLinkWithText("Set Password");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.submit("Update");
    }
}

