/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.meterware.httpunit.WebTable;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestDeleteGroup
extends BaseJiraFuncTest {
    private static final String ADMIN_GROUP_2 = "jira-admin-2";
    private static final String ADMIN_USER = "admin";
    private static final String OTHER_GROUP = "jira-developers";
    private static final String ADMIN_GROUP = "jira-administrators";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Test
    @RestoreBlankInstance
    public void testOneAdminGroupOneNonAdminGroup() {
        this.testGroupIsNotDeletable(ADMIN_GROUP);
        this.attemptToDeleteGroup(OTHER_GROUP);
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent(OTHER_GROUP);
    }

    @Test
    @RestoreBlankInstance
    public void testTwoAdminGroupsUserIsMemberOfOne() {
        this.backdoor.usersAndGroups().addGroup(ADMIN_GROUP_2);
        this.administration.addGlobalPermission(GlobalPermissionKey.SYSTEM_ADMIN, ADMIN_GROUP_2);
        this.testGroupIsNotDeletable(ADMIN_GROUP);
        this.attemptToDeleteGroup(ADMIN_GROUP_2);
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent(ADMIN_GROUP_2);
    }

    @Test
    @RestoreBlankInstance
    public void testTwoSysAdminGroupsUserIsMemberOfBoth() {
        this.backdoor.usersAndGroups().addGroup(ADMIN_GROUP_2);
        this.administration.addGlobalPermission(GlobalPermissionKey.SYSTEM_ADMIN, ADMIN_GROUP_2);
        this.administration.usersAndGroups().addUserToGroup(ADMIN_USER, ADMIN_GROUP_2);
        this.attemptToDeleteGroup(ADMIN_GROUP);
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent(ADMIN_GROUP);
        this.testGroupIsNotDeletable(ADMIN_GROUP_2);
    }

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testNoSysAdminGroupOneAdminGroupOneOther() {
        try {
            this.testGroupIsNotDeletable(ADMIN_GROUP);
            this.attemptToDeleteGroup(OTHER_GROUP);
            this.tester.submit("Delete");
            this.tester.assertTextNotPresent(OTHER_GROUP);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testNoSysAdminGroupTwoAdminGroupUserIsMemberOfBoth() {
        try {
            this.backdoor.usersAndGroups().addGroup(ADMIN_GROUP_2);
            this.giveAdminPermission(ADMIN_GROUP_2);
            this.administration.usersAndGroups().addUserToGroup(ADMIN_USER, ADMIN_GROUP_2);
            this.attemptToDeleteGroup(ADMIN_GROUP);
            this.tester.submit("Delete");
            this.tester.assertTextNotPresent(ADMIN_GROUP);
            this.testGroupIsNotDeletable(ADMIN_GROUP_2);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testDeleteSysAdminGroupAsAdmin() {
        try {
            this.tester.gotoPage("/secure/admin/user/DeleteGroup!default.jspa?name=jira-sys-admins");
            this.tester.assertTextPresent("Cannot delete group, only System Administrators can delete groups associated with the System Administrators global permission.");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testSysAdminGroupsOperationsDoNotShowToAdmins() throws SAXException {
        try {
            this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
            int actionsCol = 4;
            WebTable groupTable = this.tester.getDialog().getResponse().getTableWithID("group_browser_table");
            this.assertions.getTableAssertions().assertTableCellHasText(groupTable, 1, 0, ADMIN_GROUP);
            this.assertions.getTableAssertions().assertTableCellHasText(groupTable, 1, 4, "Delete");
            this.assertions.getTableAssertions().assertTableCellHasText(groupTable, 1, 4, "Edit members");
            this.tester.assertLinkPresent("del_jira-administrators");
            this.tester.assertLinkPresent("edit_members_of_jira-administrators");
            this.assertions.getTableAssertions().assertTableCellHasText(groupTable, 2, 0, OTHER_GROUP);
            this.assertions.getTableAssertions().assertTableCellHasText(groupTable, 2, 4, "Delete");
            this.assertions.getTableAssertions().assertTableCellHasText(groupTable, 2, 4, "Edit members");
            this.tester.assertLinkPresent("del_jira-developers");
            this.tester.assertLinkPresent("edit_members_of_jira-developers");
            this.assertions.getTableAssertions().assertTableCellHasText(groupTable, 3, 0, "jira-sys-admins");
            Assert.assertTrue((String)"shouldn't have delete operation", (!groupTable.getCellAsText(3, 4).contains("Delete") ? 1 : 0) != 0);
            Assert.assertTrue((String)"shouldn't have edit operation", (!groupTable.getCellAsText(3, 4).contains("Edit members") ? 1 : 0) != 0);
            this.tester.assertLinkNotPresent("del_jira-sys-admins");
            this.tester.assertLinkNotPresent("edit_members_of_jira-sys-admins");
            this.assertions.getTableAssertions().assertTableCellHasText(groupTable, 4, 0, "jira-users");
            this.assertions.getTableAssertions().assertTableCellHasText(groupTable, 4, 4, "Delete");
            this.assertions.getTableAssertions().assertTableCellHasText(groupTable, 4, 4, "Edit members");
            this.tester.assertLinkPresent("del_jira-users");
            this.tester.assertLinkPresent("edit_members_of_jira-users");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @Restore(value="TestDeleteGroupSwapGroup.xml")
    public void testDeleteGroupSwapGroup() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertTextPresent("Test Comment Visibility");
        this.attemptToDeleteGroup(ADMIN_GROUP);
        this.tester.selectOption("swapGroup", "other-admins");
        this.tester.submit("Delete");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertTextPresent("Test Comment Visibility");
    }

    @Test
    @Restore(value="TestDeleteGroupSwapGroup.xml")
    public void testDeleteGroupSwapGroupSameGroup() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertTextPresent("Test Comment Visibility");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/DeleteGroup.jspa?name=jira-administrators&swapGroup=jira-administrators"));
        this.tester.assertTextPresent("You cannot swap comments/worklogs to the group you are deleting.");
    }

    @Test
    @RestoreBlankInstance
    @LoginAs(user="fred")
    public void testDeleteGroupAsFred() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/DeleteGroup!default.jspa?name=jira-administrators"));
        this.tester.assertTextPresent("my login on this computer");
    }

    @Test
    @RestoreBlankInstance
    public void testDeleteInvalidGroup() {
        this.tester.gotoPage(this.page.addXsrfToken("/secure/admin/user/DeleteGroup.jspa?name=invalid"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The group 'invalid' is not a valid group.");
    }

    private void testGroupIsNotDeletable(@Nonnull String groupName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        CssLocator element = this.locator.css("#del_" + groupName);
        if (!element.exists()) {
            Assert.fail((String)("Expected element with id not found in response: [del_" + groupName + "]"));
        }
    }

    private void attemptToDeleteGroup(String groupName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        String linkId = "del_" + groupName;
        this.tester.clickLink(linkId);
    }

    private void giveAdminPermission(String groupName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
        this.tester.selectOption("globalPermType", "Jira Administrators");
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "jiraform", "Add");
        formParameterUtil.addOptionToHtmlSelect("groupName", new String[]{groupName});
        formParameterUtil.setFormElement("groupName", groupName);
        formParameterUtil.submitForm();
        this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
    }
}

