/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.user.DeleteUserPage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.PermissionSchemesMatcher;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.testkit.beans.PermissionSchemeBean;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestDeleteUserAndPermissions
extends BaseJiraFuncTest {
    private static final String TWO_PROJECTS_WITH_SUBSCRIPTIONS = "TestDeleteUserAndPermissions.xml";
    private static final Long FREDS_PERMISSION_SCHEME_ID = 10000L;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreData(TWO_PROJECTS_WITH_SUBSCRIPTIONS);
        this.administration.addGlobalPermission(33, "jira-users");
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.reporter.field");
    }

    @After
    public void tearDownTest() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.reporter.field");
        this.administration.removeGlobalPermission(33, "jira-users");
    }

    @Test
    public void testDeleteUserNotPossibleWithAssignedIssue() {
        this.logger.log((Object)"Test Delete User Not Possible With Assigned Issue");
        this.logger.log((Object)"Making sure that you can't see the other issue");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Seen issue");
        this.tester.assertTextNotPresent("Unseen issue");
        this.logger.log((Object)"Ensuring that you're unable to delete fred and that the correct number of issues are shown");
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("fred"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("fred")));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromErrorFieldNamed(DeleteUserPage.ASSIGNED_ISSUES), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromErrorFieldNamed(DeleteUserPage.REPORTED_ISSUES), (Matcher)Matchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromWarningFieldNamed(DeleteUserPage.SHARED_FILTERS), (Matcher)Matchers.equalTo((Object)"1"));
    }

    @Test
    public void testDeleteUserRemoveFromPermissionAndNotificationSchemes() {
        this.logger.log((Object)"Test delete user with shared filters");
        this.assertFredHasPermissionsAssigned();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("Test Issue Security Scheme");
        this.tester.assertTextPresent("fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.tester.assertTextPresent("fred");
        this.tester.assertLinkPresent("del_10050");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.backdoor.permissionSchemes().addUserPermission(FREDS_PERMISSION_SCHEME_ID.longValue(), ProjectPermissions.EDIT_ISSUES, "admin");
        this.backdoor.permissionSchemes().addUserPermission(FREDS_PERMISSION_SCHEME_ID.longValue(), ProjectPermissions.BROWSE_PROJECTS, "admin");
        this.backdoor.permissionSchemes().addUserPermission(FREDS_PERMISSION_SCHEME_ID.longValue(), ProjectPermissions.MODIFY_REPORTER, "admin");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("reporter", "admin");
        this.tester.submit("Update");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("reporter", "admin");
        this.tester.selectOption("assignee", "Administrator");
        this.tester.submit("Update");
        this.logger.log((Object)"Deleting Fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("fred");
        this.tester.clickLink("deleteuser_link");
        this.tester.assertTextPresent("Delete User");
        this.tester.submit("Delete");
        this.assertions.assertNodeByIdExists("user_browser_table");
        this.tester.assertTextNotPresent("fred");
        this.assertFredHasNoPermissionsAssigned();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("Test Issue Security Scheme");
        this.tester.assertTextNotPresent("fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.tester.assertTextNotPresent("fred");
        this.tester.assertLinkNotPresent("del_10050");
    }

    @Test
    public void testCannotSelfDestruct() {
        this.administration.restoreBlankInstance();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParametersWithXsrf("admin", this.page));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeleteSelfError(), (Matcher)Matchers.equalTo((Object)"You cannot delete the currently logged in user."));
        deleteUserPage.confirmNoDeleteButtonPresent();
    }

    @Test
    public void testAdminCannotDeleteSysadmin() {
        this.administration.restoreBlankInstance();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        try {
            this.administration.usersAndGroups().addUser("sysadmin2");
            this.administration.usersAndGroups().addUserToGroup("sysadmin2", "jira-administrators");
            this.administration.usersAndGroups().addUser("nonsystemadmin");
            this.administration.usersAndGroups().addGroup("nonsystemadmins");
            this.administration.usersAndGroups().addUserToGroup("nonsystemadmin", "nonsystemadmins");
            this.administration.addGlobalPermission(0, "nonsystemadmins");
            this.navigation.login("nonsystemadmin");
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.assertLinkNotPresent("deleteuser_link_sysadmin2");
            DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParametersWithXsrf("sysadmin2", this.page));
            MatcherAssert.assertThat((Object)deleteUserPage.getNonAdminDeletingSysAdminErrorMessage(), (Matcher)Matchers.equalTo((Object)"As a user with Jira Administrators permission, you cannot delete users with Jira System Administrators permission."));
            deleteUserPage.confirmNoDeleteButtonPresent();
            deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParametersWithXsrf("sysadmin2", this.page) + "&confirm=true");
            MatcherAssert.assertThat((Object)deleteUserPage.getNonAdminDeletingSysAdminErrorMessage(), (Matcher)Matchers.equalTo((Object)"As a user with Jira Administrators permission, you cannot delete users with Jira System Administrators permission."));
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.assertLinkPresent("sysadmin2");
        }
        finally {
            this.navigation.login("admin");
        }
    }

    private void assertFredHasPermissionsAssigned() {
        this.assertFredHasNoPermissionsAssignedInPermissionScheme(0L);
        PermissionSchemeBean permissionScheme = this.backdoor.permissionSchemes().getAssignedPermissions(FREDS_PERMISSION_SCHEME_ID.longValue());
        this.assertHasPermission(permissionScheme, ProjectPermissions.ADMINISTER_PROJECTS);
        this.assertHasPermission(permissionScheme, ProjectPermissions.BROWSE_PROJECTS);
        this.assertHasPermission(permissionScheme, ProjectPermissions.CREATE_ISSUES);
        this.assertHasPermission(permissionScheme, ProjectPermissions.EDIT_ISSUES);
        this.assertHasPermission(permissionScheme, ProjectPermissions.SCHEDULE_ISSUES);
        this.assertHasPermission(permissionScheme, ProjectPermissions.MOVE_ISSUES);
        this.assertHasPermission(permissionScheme, ProjectPermissions.ASSIGNABLE_USER);
        this.assertHasPermission(permissionScheme, ProjectPermissions.RESOLVE_ISSUES);
        this.assertHasPermission(permissionScheme, ProjectPermissions.CLOSE_ISSUES);
        this.assertHasPermission(permissionScheme, ProjectPermissions.MODIFY_REPORTER);
        this.assertHasPermission(permissionScheme, ProjectPermissions.DELETE_ALL_COMMENTS);
        this.assertHasPermission(permissionScheme, ProjectPermissions.DELETE_ISSUES);
        this.assertHasPermission(permissionScheme, ProjectPermissions.WORK_ON_ISSUES);
        this.assertHasPermission(permissionScheme, ProjectPermissions.LINK_ISSUES);
        this.assertHasPermission(permissionScheme, ProjectPermissions.CREATE_ATTACHMENTS);
        this.assertHasPermission(permissionScheme, ProjectPermissions.DELETE_ALL_ATTACHMENTS);
        this.assertHasPermission(permissionScheme, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS);
        this.assertHasPermission(permissionScheme, ProjectPermissions.MANAGE_WATCHERS);
        this.assertHasPermission(permissionScheme, ProjectPermissions.SET_ISSUE_SECURITY);
    }

    private void assertHasPermission(PermissionSchemeBean permissionScheme, ProjectPermissionKey permission) {
        Assert.assertTrue((String)("Fred should have " + permission.permissionKey() + " permission"), (boolean)PermissionSchemesMatcher.hasPermission(permission.permissionKey(), JiraPermissionHolderType.USER.getKey(), "fred").matches((Object)permissionScheme));
    }

    private void assertFredHasNoPermissionsAssigned() {
        this.assertFredHasNoPermissionsAssignedInPermissionScheme(0L);
        this.assertFredHasNoPermissionsAssignedInPermissionScheme(FREDS_PERMISSION_SCHEME_ID);
    }

    private void assertFredHasNoPermissionsAssignedInPermissionScheme(Long schemeId) {
        PermissionSchemeBean permissionScheme = this.backdoor.permissionSchemes().getAssignedPermissions(schemeId.longValue());
        Assert.assertTrue((String)("Fred should have no permissions in the " + permissionScheme.getName() + " permission scheme"), (boolean)PermissionSchemesMatcher.hasPermissionCount(JiraPermissionHolderType.USER.getKey(), "fred", 0).matches((Object)permissionScheme));
    }
}

