/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS, Category.ROLES, Category.USERS_AND_GROUPS})
@Restore(value="TestEditUserProjectRoles.xml")
@LoginAs(user="admin")
public class TestEditUserProjectRoles
extends BaseJiraFuncTest {
    @Test
    public void testNoProjectAssociationsForViewPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("tester");
        this.tester.clickLink("viewprojectroles_link");
        this.tester.assertTextPresent("There are currently no project role associations for this user.");
    }

    @Test
    public void testRemoveAssociationFromProject() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("admin");
        this.tester.clickLink("viewprojectroles_link");
        this.tester.clickLinkWithText("Edit Project Roles");
        this.tester.assertTextPresent("monkey");
        this.tester.assertTextPresent("homosapien");
        this.tester.uncheckCheckbox("10001_10011");
        this.tester.submit("Save");
        this.tester.assertTextPresent("homosapien");
        this.tester.assertTextNotPresent("monkey");
        this.tester.clickLinkWithText("Edit Project Roles");
        this.tester.assertTextInTable("projecttable", "homosapien");
        this.tester.assertTextNotInTable("projecttable", "monkey");
    }

    @Test
    public void testGlobalAdminCanRemoveAnyoneFromRole() {
        this.navigation.gotoAdmin();
        this.backdoor.getTestkit().projectRole().deleteGroup("DKY", "Administrators", "jira-administrators");
        this.backdoor.getTestkit().projectRole().deleteGroup("HSP", "Administrators", "jira-developers");
        this.backdoor.permissionSchemes().addProjectRolePermission(0L, ProjectPermissions.ADMINISTER_PROJECTS, 10002L);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.gotoPage("/secure/admin/user/ViewUserProjectRoles!default.jspa?returnUrl=UserBrowser.jspa&name=admin");
        this.tester.clickLinkWithText("Edit Project Roles");
        this.tester.uncheckCheckbox("10000_10011");
        this.tester.uncheckCheckbox("10001_10011");
        this.tester.submit("Save");
        this.tester.assertTextNotPresent("You can not remove a user/group that will result in completely removing yourself from this role.");
        this.tester.assertTextPresent("View Project Roles for User");
    }

    @Test
    public void testGroupAssociationPresentInEditProjectRolesForUser() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("admin");
        this.tester.clickLink("viewprojectroles_link");
        this.tester.assertTextPresent("jira-developers");
    }

    @Test
    public void testGroupAssociationPresentInViewProjectRolesForUser() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("barney");
        this.tester.clickLink("viewprojectroles_link");
        this.tester.assertTextPresent("jira-developers");
    }
}

