/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
@LoginAs(user="admin")
public class TestMultiUserPicker
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testMultiUserPickerWithStrangeUsername() {
        this.administration.restoreBlankInstance();
        this.administration.usersAndGroups().addUser("${uname}", "password", "${fullname}", "user@example.com");
        this.tester.gotoPage("secure/popups/UserPickerBrowser.jspa?formName=jiraform&multiSelect=true");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.textAssertions.assertTextNotPresent(locator, "System Error");
        this.textAssertions.assertTextPresent(locator, "${uname}");
        this.textAssertions.assertTextPresent(locator, "admin");
    }
}

