/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestUserProperties
extends BaseJiraFuncTest {
    protected static final String USER_BOB_BROWSER = "/secure/admin/user/EditUserProperties.jspa?name=bob";
    protected static final String DELETE_PROP = "delete_testprop";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.administration.restoreBlankInstance();
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.goToBobPropertiesPage();
    }

    @Test
    public void testAddUserProperty() {
        this.addBobProperty("testprop", "testvalue");
        this.goToBobPropertiesPage();
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "testprop", "testvalue");
    }

    @Test
    public void testDuplicateProperty() {
        this.addBobProperty("testprop", "testvalue1");
        this.addBobProperty("testprop", "testvalue2");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".error[data-field=key]"), "This 'key' already exists for the user.");
    }

    @Test
    public void testDeleteUserProperty() {
        this.addBobProperty("testprop", "testvalue");
        this.tester.gotoPage(USER_BOB_BROWSER);
        this.tester.clickLink(DELETE_PROP);
        this.tester.assertTextPresent("Delete Property: testprop");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("currently has no properties");
    }

    @Test
    public void testInvalidCharactersForProperty() {
        this.addBobProperty("testprop!", "testvalue");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".error[data-field=key]"), "The 'key' can only contain alphanumeric characters");
    }

    @Test
    public void testKeyExceedsCharacterLengthCheck() {
        this.addBobProperty(StringUtils.repeat((String)"x", (int)251), "testvalue");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".error[data-field=key]"), "The 'key' length must be less than 200 characters");
    }

    @Test
    public void testValueExceedCharacterLengthCheck() {
        this.addBobProperty("testproperty", StringUtils.repeat((String)"x", (int)251));
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".error[data-field=value]"), "The 'value' length must be less than 250 characters");
    }

    @Test
    public void testKeyIsEmptyCheck() {
        this.addBobProperty("", "testvalue");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".error[data-field=key]"), "The 'key' cannot be empty");
    }

    @Test
    public void testValueIsEmptyCheck() {
        this.addBobProperty("testproperty", "");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".error[data-field=value]"), "The 'value' cannot be empty");
    }

    @Test
    public void testValueIsHtmlEncoded() {
        this.addBobProperty("testproperty", "<blink>Annoying</blink>");
        this.tester.assertTextPresent("&lt;blink&gt;Annoying&lt;/blink&gt;");
        this.tester.assertTextNotPresent("<blink>Annoying</blink>");
    }

    private void addBobProperty(String key, String value) {
        this.goToBobPropertiesPage();
        this.tester.setFormElement("key", key);
        this.tester.setFormElement("value", value);
        this.tester.submit();
    }

    private void goToBobPropertiesPage() {
        this.tester.gotoPage(USER_BOB_BROWSER);
        this.tester.assertTextPresent("Bob The Builder");
    }
}

