/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
@LoginAs(user="admin")
public class TestUserResolver
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testFindByFullNameExists() {
        List<String> results = this.backdoor.userManager().userKeysByFullName("Administrator");
        Assert.assertEquals(results, Arrays.asList("admin"));
    }

    @Test
    public void testFindByFullNameCaseInsensitive() {
        List<String> results = this.backdoor.userManager().userKeysByFullName("ADMINISTRATOR");
        Assert.assertEquals(results, Arrays.asList("admin"));
    }

    @Test
    public void testFindByFullNameNotFound() {
        List<String> results = this.backdoor.userManager().userKeysByFullName("IDoNotExist");
        Assert.assertEquals(results, Collections.emptyList());
    }

    @Test
    public void testFindByEmailExists() {
        List<String> results = this.backdoor.userManager().userKeysByEmail("admin@example.com");
        Assert.assertEquals(results, Arrays.asList("admin"));
    }

    @Test
    public void testFindByEmailCaseInsensitive() {
        List<String> results = this.backdoor.userManager().userKeysByEmail("ADMIN@EXAMPLE.COM");
        Assert.assertEquals(results, Arrays.asList("admin"));
    }

    @Test
    public void testFindByEmailNotFound() {
        List<String> results = this.backdoor.userManager().userKeysByEmail("iDoNotExist@nowhere.com");
        Assert.assertEquals(results, Collections.emptyList());
    }
}

