/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.FilterSubscriptionControl;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient;
import com.atlassian.scheduler.config.JobRunnerKey;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.ANONYMIZE_USER})
@RestoreBlankInstance
public class TestAnonymizeUserData
extends BaseJiraFuncTest {
    private UserAnonymizeControl userAnonymizeControl;

    @Before
    public void setUp() {
        this.userAnonymizeControl = new UserAnonymizeControl(this.environmentData);
        this.backdoor.usersAndGroups().addUser("john", "secret", "John Doe", "john@example.com");
        this.backdoor.project().addProject("Project", "PROJ", "admin");
    }

    @Test
    public void testAnonymizeUserProfile() {
        UserDTO userBefore = this.backdoor.usersAndGroups().getUserByName("john");
        this.userAnonymizeControl.anonymize(userBefore.getKey(), false, null, null, "admin");
        UserDTO userAfter = this.getUserById(userBefore.getId());
        String expectedEmail = String.format("JIRAUSER%d@jira.invalid", userBefore.getId());
        Assert.assertEquals((Object)expectedEmail, (Object)userAfter.getEmail());
        Assert.assertTrue((boolean)userAfter.getDisplayName().matches("user-[0-9a-f]{5}"));
    }

    @Test
    public void testAnonymizeDeletedUser() {
        UserDTO userBeforeDelete = this.backdoor.usersAndGroups().getUserByName("john");
        long userId = userBeforeDelete.getId();
        this.backdoor.usersAndGroups().deleteUser("john");
        UserAnonymizeControl.AnonymizePerformResult result = this.userAnonymizeControl.anonymize(userBeforeDelete.getKey(), false, null, null, "admin");
        UserDTO userDeletedAnonymized = this.backdoor.usersAndGroups().getUserByNameEvenWhenUnknown(result.getUserNameNew());
        Assert.assertEquals((long)userId, (long)userDeletedAnonymized.getId());
    }

    @Test
    public void testRemoveRelatedEntities() {
        UserDTO userBefore = this.backdoor.usersAndGroups().getUserByName("john");
        long filter = Long.parseLong(this.backdoor.filters().createFilter("", "all issues"));
        ((FilterSubscriptionControl)this.backdoor.filterSubscriptions().loginAs("john", "secret")).addSubscription(filter, null, "0 0 1 ? * *", true);
        ((ProjectRoleClient)this.backdoor.projectRole().loginAs("admin")).addActors("PROJ", "Administrators", new String[0], new String[]{"john"});
        UserAnonymizeControl.AnonymizePerformResult result = this.userAnonymizeControl.anonymize(userBefore.getKey(), false, null, null, "admin");
        Assert.assertThat(((FilterSubscriptionControl)this.backdoor.filterSubscriptions().loginAs("admin")).forFilter(filter), (Matcher)Matchers.empty());
        Assert.assertThat(this.backdoor.scheduler().getJobsByJobRunnerKey(JobRunnerKey.of((String)"com.atlassian.jira.issue.subscription.DefaultSubscriptionManager")), (Matcher)Matchers.empty());
        Assert.assertThat((Object)this.backdoor.projectRole().get("PROJ", "Administrators").getActors(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"john")))));
    }

    private UserDTO getUserById(long id) {
        return this.backdoor.usersAndGroups().getAllUsers().stream().filter(user -> user.getId() == id).findFirst().get();
    }
}

