/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.backdoor.ColumnControl;
import com.atlassian.jira.functest.framework.backdoor.EventClient;
import com.atlassian.jira.functest.framework.backdoor.FilterInfo;
import com.atlassian.jira.functest.framework.backdoor.FiltersClient;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.ResourceRef;
import com.atlassian.jira.testkit.beans.UserDTO;
import com.atlassian.jira.testkit.client.DashboardControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ChangeLog;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.FieldMetaData;
import com.atlassian.jira.testkit.client.restclient.Filter;
import com.atlassian.jira.testkit.client.restclient.FilterClient;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.IssueType;
import com.atlassian.jira.testkit.client.restclient.PageBean;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.VotesClient;
import com.atlassian.jira.testkit.client.restclient.WatchersClient;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.AvatarFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.ColumnLayoutFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.CustomFieldDefaultValueFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.FavouriteAssociationsFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.OAuthspTokenFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.ProjectComponentFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.ProjectFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.ProjectRoleActorFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.SchemePermissionsFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.SearchRequestUserFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.SharePermissionsFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.UserHistoryItemFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.UserKeyFKChangedEvent;
import com.atlassian.jira.user.anonymize.handlers.key.info.events.UserKeyInPortalPageFKChangedEvent;
import com.atlassian.jira.webtests.ztests.user.anonymize.ForeignKeysClient;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AnyOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REFERENCE_PLUGIN, Category.ACTIVE_OBJECTS, Category.PLUGINS})
@LoginAs(user="admin")
@Restore(value="anonymizationForeignKeys.xml")
public class TestForeignKeysChange
extends BaseJiraFuncTest {
    private static final String FRED_NORMAL_FULL_NAME = "Fred Normal";
    private static final String ADMINISTRATOR_FULL_NAME = "Administrator";
    private static final String REPORTER_FIELD_ID = "reporter";
    private static final String ASSIGNEE_FIELD_ID = "assignee";
    private static final String SINGLE_USER_PICKER_FIELD_ID = "selected-user";
    private static final String MULTI_USER_PICKER_FIELD_ID = "multi-user";
    private static final String JIRA_SYSTEM_FIELD = "jira";
    private static final String JIRA_CUSTOM_FIELD = "custom";
    private ForeignKeysClient foreignKeysClient;
    private UserAnonymizeControl userAnonymizeControl;
    private EventClient.EventPoller eventPoller;
    private FilterClient filterClient;
    private IssueClient issueClient;

    @Before
    public void setUp() {
        this.foreignKeysClient = new ForeignKeysClient(this.getEnvironmentData());
        this.userAnonymizeControl = new UserAnonymizeControl(this.getEnvironmentData());
        this.filterClient = new FilterClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        this.backdoor.permissions().addGlobalPermission(22, "jira-users");
        this.eventPoller = this.backdoor.events().createPoller();
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void checkIssueChangeHistoryAnonymized() {
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.backdoor.userProfile().changeUserLanguage("fred", "pl_PL");
        this.backdoor.issues().assignIssue("HSP-1", "fred");
        this.backdoor.issues().assignIssue("HSP-1", "admin");
        this.backdoor.issues().loginAs("fred").setIssueFields("HSP-1", new IssueFields().customField(Long.valueOf(10000L), (Object)ImmutableMap.of((Object)"name", (Object)"fred"))).loginAs("admin");
        UserDTO fred = this.backdoor.usersAndGroups().getUserByName("fred");
        SearchResult reporterSearchResponse = this.backdoor.search().getSearch(new SearchRequest().jql("reporter was fred"));
        Assert.assertThat((Object)reporterSearchResponse.issues, (Matcher)Matchers.hasSize((int)1));
        SearchResult assigneeSearchResponse = this.backdoor.search().getSearch(new SearchRequest().jql("assignee was fred"));
        Assert.assertThat((Object)assigneeSearchResponse.issues, (Matcher)Matchers.hasSize((int)2));
        Issue issue = this.backdoor.issues().getIssue("ANON-2", new Issue.Expand[]{Issue.Expand.changelog});
        List changeItemsBefore = issue.changelog.histories.stream().flatMap(history -> history.items.stream()).collect(Collectors.toList());
        Assert.assertThat(changeItemsBefore, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, ASSIGNEE_FIELD_ID, "admin", "fred", ADMINISTRATOR_FULL_NAME, FRED_NORMAL_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, REPORTER_FIELD_ID, "admin", "fred", ADMINISTRATOR_FULL_NAME, FRED_NORMAL_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, SINGLE_USER_PICKER_FIELD_ID, "fred", "admin", FRED_NORMAL_FULL_NAME, ADMINISTRATOR_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, "[admin]", "[admin, fred]", ADMINISTRATOR_FULL_NAME, "Administrator, Fred Normal")), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, null, "[admin]", null, ADMINISTRATOR_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, SINGLE_USER_PICKER_FIELD_ID, null, "fred", null, FRED_NORMAL_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, "[admin, fred]", "[fred, fred1, fred2]", "Administrator, Fred Normal", "Fred Normal, Fred Normal 1, Fred Normal 2")), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, "translated single", "admin", "fred", ADMINISTRATOR_FULL_NAME, FRED_NORMAL_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, "translated multi", "[fred, fred1, fred2]", (Matcher<String>)this.matchesEmptyStringOrNull(), "Fred Normal, Fred Normal 1, Fred Normal 2", (Matcher<String>)this.matchesEmptyStringOrNull()))}));
        Issue issueHsp = this.backdoor.issues().getIssue("HSP-1", new Issue.Expand[]{Issue.Expand.changelog});
        Assert.assertThat(issueHsp.changelog.histories.stream().flatMap(history -> history.items.stream()).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, ASSIGNEE_FIELD_ID, "admin", "fred", ADMINISTRATOR_FULL_NAME, FRED_NORMAL_FULL_NAME)), (Matcher)Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, ASSIGNEE_FIELD_ID, "fred", "admin", FRED_NORMAL_FULL_NAME, ADMINISTRATOR_FULL_NAME))));
        ChangeLog.Author issueHspAuthor = ((ChangeLog.History)issueHsp.changelog.histories.get((int)7)).author;
        Assert.assertThat((Object)issueHspAuthor.key, (Matcher)Matchers.equalTo((Object)fred.getKey()));
        UserAnonymizeControl.AnonymizePerformResult anonymizeResult = this.userAnonymizeControl.anonymize("fred", false, null, null, "admin");
        this.backdoor.indexing().reindexAll();
        UserDTO userAfterAnonymize = this.backdoor.usersAndGroups().getUserByName(anonymizeResult.getUserNameNew());
        this.shouldFailWithException(() -> this.backdoor.search().getSearch(new SearchRequest().jql("reporter was fred")));
        this.shouldFailWithException(() -> this.backdoor.search().getSearch(new SearchRequest().jql("assignee was fred")));
        Issue issueAfter = this.backdoor.issues().getIssue("ANON-2", new Issue.Expand[]{Issue.Expand.changelog});
        List changeItemsAfter = issueAfter.changelog.histories.stream().flatMap(history -> history.items.stream()).collect(Collectors.toList());
        Assert.assertThat(changeItemsAfter, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, REPORTER_FIELD_ID, "admin", userAfterAnonymize.getKey(), ADMINISTRATOR_FULL_NAME, userAfterAnonymize.getKey())), Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, ASSIGNEE_FIELD_ID, "admin", userAfterAnonymize.getKey(), ADMINISTRATOR_FULL_NAME, userAfterAnonymize.getKey())), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, SINGLE_USER_PICKER_FIELD_ID, userAfterAnonymize.getKey(), "admin", userAfterAnonymize.getKey(), ADMINISTRATOR_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, "[admin]", String.format("[admin, %s]", userAfterAnonymize.getKey()), ADMINISTRATOR_FULL_NAME, String.format("Administrator, %s", userAfterAnonymize.getKey()))), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, null, "[admin]", null, ADMINISTRATOR_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, SINGLE_USER_PICKER_FIELD_ID, null, userAfterAnonymize.getKey(), null, userAfterAnonymize.getKey())), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, String.format("[admin, %s]", userAfterAnonymize.getKey()), String.format("[%s, fred1, fred2]", userAfterAnonymize.getKey()), String.format("Administrator, %s", userAfterAnonymize.getKey()), String.format("%s, Fred Normal 1, Fred Normal 2", userAfterAnonymize.getKey()))), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, "translated single", "admin", userAfterAnonymize.getKey(), ADMINISTRATOR_FULL_NAME, userAfterAnonymize.getKey())), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, "translated multi", String.format("[%s, fred1, fred2]", userAfterAnonymize.getKey()), (Matcher<String>)this.matchesEmptyStringOrNull(), String.format("%s, Fred Normal 1, Fred Normal 2", userAfterAnonymize.getKey()), (Matcher<String>)this.matchesEmptyStringOrNull()))}));
        Issue issueHspAfter = this.backdoor.issues().getIssue("HSP-1", new Issue.Expand[]{Issue.Expand.changelog});
        Assert.assertThat(issueHspAfter.changelog.histories.stream().flatMap(history -> history.items.stream()).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, ASSIGNEE_FIELD_ID, "admin", userAfterAnonymize.getKey(), ADMINISTRATOR_FULL_NAME, userAfterAnonymize.getKey())), (Matcher)Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, ASSIGNEE_FIELD_ID, userAfterAnonymize.getKey(), "admin", userAfterAnonymize.getKey(), ADMINISTRATOR_FULL_NAME))));
        ChangeLog.Author issueHspAuthorAfter = ((ChangeLog.History)issueHspAfter.changelog.histories.get((int)7)).author;
        Assert.assertThat((Object)issueHspAuthorAfter.key, (Matcher)Matchers.equalTo((Object)userAfterAnonymize.getKey()));
        SearchResult newReporterSearchResponseAfter = this.backdoor.search().getSearch(new SearchRequest().jql("reporter was " + userAfterAnonymize.getUsername()));
        Assert.assertThat((Object)newReporterSearchResponseAfter.issues, (Matcher)Matchers.hasSize((int)1));
        SearchResult newAssigneeSearchResponseAfter = this.backdoor.search().getSearch(new SearchRequest().jql("assignee was " + userAfterAnonymize.getUsername()));
        Assert.assertThat((Object)newAssigneeSearchResponseAfter.issues, (Matcher)Matchers.hasSize((int)2));
        UserAnonymizeControl.AnonymizePerformResult fred1Result = this.userAnonymizeControl.anonymize("fred1", false, null, null, "admin");
        Assert.assertThat(this.backdoor.issues().getIssue((String)"ANON-2", (Issue.Expand[])new Issue.Expand[]{Issue.Expand.changelog}).changelog.histories.stream().flatMap(history -> history.items.stream()).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, "translated multi", String.format("[%s, %s, fred2]", userAfterAnonymize.getKey(), fred1Result.getUserKeyNew()), (Matcher<String>)this.matchesEmptyStringOrNull()))}));
        UserAnonymizeControl.AnonymizePerformResult fred2Result = this.userAnonymizeControl.anonymize("fred2", false, null, null, "admin");
        Assert.assertThat(this.backdoor.issues().getIssue((String)"ANON-2", (Issue.Expand[])new Issue.Expand[]{Issue.Expand.changelog}).changelog.histories.stream().flatMap(history -> history.items.stream()).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, "translated multi", String.format("[%s, %s, %s]", userAfterAnonymize.getKey(), fred1Result.getUserKeyNew(), fred2Result.getUserKeyNew()), (Matcher<String>)this.matchesEmptyStringOrNull()))}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void commentsShouldBeAnonymized() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("ANON", "test comments anonymization");
        Comment comment = (Comment)this.backdoor.issues().loginAs((String)"fred").commentIssueWithVisibility((String)issue.key, (String)"comment", (String)"role", (String)"Users").body;
        this.backdoor.issues().loginAs("fred").updateComment(issue.key, comment.id, "edited", "role", "Users");
        List commentsBefore = this.backdoor.issues().getIssue(issue.key).getComments();
        Assert.assertThat((Object)commentsBefore.size(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)((Comment)commentsBefore.get((int)0)).author.key, (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)((Comment)commentsBefore.get((int)0)).updateAuthor.key, (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)((Comment)commentsBefore.get((int)0)).body, (Matcher)Matchers.equalTo((Object)"edited"));
        UserAnonymizeControl.AnonymizePerformResult result = this.userAnonymizeControl.anonymize("fred", false, null, null, "admin");
        List commentsAfter = this.backdoor.issues().loginAs("admin").getIssue(issue.key).getComments();
        Assert.assertThat((Object)commentsAfter.size(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)((Comment)commentsAfter.get((int)0)).author.key, (Matcher)Matchers.equalTo((Object)result.getUserKeyNew()));
        Assert.assertThat((Object)((Comment)commentsAfter.get((int)0)).updateAuthor.key, (Matcher)Matchers.equalTo((Object)result.getUserKeyNew()));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void workLogsShouldBeAnonymized() {
        WorklogClient worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        IssueCreateResponse issue = this.backdoor.issues().createIssue("ANON", "test work logs anonymization");
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        worklog.comment = "comment";
        worklog = (Worklog)((WorklogClient)worklogClient.loginAs((String)"fred")).post((String)issue.key, (Worklog)worklog).body;
        worklog.timeSpent = "2h";
        worklog.timeSpentSeconds = null;
        worklog.comment = "edited";
        worklogClient.put(issue.key, worklog);
        worklog = worklogClient.get(issue.key, worklog.id);
        Assert.assertThat((Object)worklog.author.key, (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)worklog.updateAuthor.key, (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)worklog.timeSpent, (Matcher)Matchers.equalTo((Object)"2h"));
        Assert.assertThat((Object)worklog.comment, (Matcher)Matchers.equalTo((Object)"edited"));
        UserAnonymizeControl.AnonymizePerformResult result = this.userAnonymizeControl.anonymize("fred", false, null, null, "admin");
        worklog = ((WorklogClient)worklogClient.loginAs("admin")).get(issue.key, worklog.id);
        Assert.assertThat((Object)worklog.author.key, (Matcher)Matchers.equalTo((Object)result.getUserKeyNew()));
        Assert.assertThat((Object)worklog.updateAuthor.key, (Matcher)Matchers.equalTo((Object)result.getUserKeyNew()));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void votesShouldBeAnonymized() {
        VotesClient votesClient = new VotesClient((JIRAEnvironmentData)this.environmentData);
        IssueCreateResponse issue = this.backdoor.issues().createIssue("ANON", "test votes anonymization");
        ((VotesClient)votesClient.loginAs("fred")).postResponse(issue.key);
        Assert.assertThat(this.getVotersKeys(votesClient, issue.key), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"fred"}));
        UserAnonymizeControl.AnonymizePerformResult result = this.userAnonymizeControl.anonymize("fred", false, null, null, "admin");
        Assert.assertThat(this.getVotersKeys((VotesClient)votesClient.loginAs("admin"), issue.key), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{result.getUserKeyNew()}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void watchesShouldBeAnonymized() {
        WatchersClient watchersClient = new WatchersClient((JIRAEnvironmentData)this.environmentData);
        IssueCreateResponse issue = this.backdoor.issues().createIssue("ANON", "test watches anonymization");
        ((WatchersClient)watchersClient.loginAs("fred")).postResponse(issue.key, "fred");
        Assert.assertThat(this.getWatchersKeys(watchersClient, issue.key), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"admin", "fred"}));
        UserAnonymizeControl.AnonymizePerformResult result = this.userAnonymizeControl.anonymize("fred", false, null, null, "admin");
        Assert.assertThat(this.getWatchersKeys((WatchersClient)watchersClient.loginAs("admin"), issue.key), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"admin", result.getUserKeyNew()}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void checkWildcardUser() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("ANON", "test wildcard user");
        this.backdoor.usersAndGroups().addUser("%");
        this.backdoor.usersAndGroups().getUserByName("%");
        this.backdoor.usersAndGroups().addUserToGroup("%", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        this.backdoor.issues().assignIssue(issue.key, "fred");
        this.backdoor.issues().assignIssue(issue.key, "%");
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().reporter(ResourceRef.withName((String)"fred")));
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().reporter(ResourceRef.withName((String)"%")));
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().customField(Long.valueOf(10000L), (Object)ImmutableMap.of()));
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().customField(Long.valueOf(10000L), (Object)ImmutableMap.of((Object)"name", (Object)"fred")));
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().customField(Long.valueOf(10000L), (Object)ImmutableMap.of((Object)"name", (Object)"%")));
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().customField(Long.valueOf(10100L), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"name", (Object)"%"), (Object)ImmutableMap.of((Object)"name", (Object)"fred"))));
        Issue issueBefore = this.backdoor.issues().getIssue(issue.key, new Issue.Expand[]{Issue.Expand.changelog});
        Assert.assertThat(issueBefore.changelog.histories.stream().flatMap(history -> history.items.stream()).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, ASSIGNEE_FIELD_ID, "admin", "fred", ADMINISTRATOR_FULL_NAME, FRED_NORMAL_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, ASSIGNEE_FIELD_ID, "fred", "%", FRED_NORMAL_FULL_NAME, "%")), Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, REPORTER_FIELD_ID, "admin", "fred", ADMINISTRATOR_FULL_NAME, FRED_NORMAL_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, REPORTER_FIELD_ID, "fred", "%", FRED_NORMAL_FULL_NAME, "%")), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, SINGLE_USER_PICKER_FIELD_ID, "fred", (Matcher<String>)Matchers.isEmptyOrNullString())), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, SINGLE_USER_PICKER_FIELD_ID, null, "fred")), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, SINGLE_USER_PICKER_FIELD_ID, "fred", "%")), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, "[fred1]", "[%, fred]"))}));
        UserAnonymizeControl.AnonymizePerformResult anonymizeResult = this.userAnonymizeControl.anonymize("%", false, null, null, "admin");
        UserDTO userAfterAnonymize = this.backdoor.usersAndGroups().getUserByName(anonymizeResult.getUserNameNew());
        Issue issueAfter = this.backdoor.issues().getIssue(issue.key, new Issue.Expand[]{Issue.Expand.changelog});
        Assert.assertThat(issueAfter.changelog.histories.stream().flatMap(history -> history.items.stream()).collect(Collectors.toList()), (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, ASSIGNEE_FIELD_ID, "admin", "fred", ADMINISTRATOR_FULL_NAME, FRED_NORMAL_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, ASSIGNEE_FIELD_ID, "fred", userAfterAnonymize.getKey(), FRED_NORMAL_FULL_NAME, userAfterAnonymize.getKey())), Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, REPORTER_FIELD_ID, "admin", "fred", ADMINISTRATOR_FULL_NAME, FRED_NORMAL_FULL_NAME)), Matchers.hasItem(this.matchesHistory(JIRA_SYSTEM_FIELD, REPORTER_FIELD_ID, "fred", userAfterAnonymize.getKey(), FRED_NORMAL_FULL_NAME, userAfterAnonymize.getKey())), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, SINGLE_USER_PICKER_FIELD_ID, "fred", (Matcher<String>)Matchers.isEmptyOrNullString())), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, SINGLE_USER_PICKER_FIELD_ID, null, "fred")), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, SINGLE_USER_PICKER_FIELD_ID, "fred", userAfterAnonymize.getKey())), Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, "[fred1]", String.format("[%s, fred]", userAfterAnonymize.getKey())))}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void componentUpdateCacheShouldBeInvalidatedAfterUserKeyChange() {
        String newKey = "fred_new_key";
        Component component = this.backdoor.components().create(new Component().project("ANON").name("Fred's component").leadUserName("fred"));
        Component componentBefore = this.backdoor.components().get("" + component.id);
        List<Component> projectComponentsBefore = this.backdoor.project().getComponentsForProject("ANON");
        Assert.assertThat((Object)componentBefore.lead.key, (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat(projectComponentsBefore, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)projectComponentsBefore.get((int)0).lead.key, (Matcher)Matchers.equalTo((Object)"fred"));
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertEventPublished(ProjectComponentFKChangedEvent.class);
        Component componentAfter = this.backdoor.components().get("" + component.id);
        List<Component> projectComponentsAfter = this.backdoor.project().getComponentsForProject("ANON");
        Assert.assertThat((Object)componentAfter.lead.key, (Matcher)Matchers.equalTo((Object)"fred_new_key"));
        Assert.assertThat(projectComponentsAfter, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)projectComponentsAfter.get((int)0).lead.key, (Matcher)Matchers.equalTo((Object)"fred_new_key"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void favouriteAssociationsCacheShouldBeInvalidatedAfterUserKeyChange() {
        String newKey = "fred_new_key";
        ((FiltersClient)this.backdoor.filters().loginAs("fred")).createFilter("project = ANON", "Fred's loves ANON project", true);
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertEventPublished(FavouriteAssociationsFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void avatarCacheShouldBeInvalidatedAfterUserKeyChange() {
        String newKey = "fred_new_key";
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred1", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertEventPublished(AvatarFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void columnLayoutCacheShouldBeInvalidatedAfterUserKeyChange() {
        this.backdoor.columnControl().setUserColumns("fred", (List<String>)ImmutableList.of((Object)"issuetype", (Object)"issuekey", (Object)"summary"));
        this.backdoor.columnControl().getUserColumns("fred");
        UserAnonymizeControl.AnonymizePerformResult result = this.userAnonymizeControl.anonymize("fred");
        this.assertEventPublished(ColumnLayoutFKChangedEvent.class);
        Assert.assertThat((Object)this.backdoor.columnControl().getUserColumns(result.getUserNameNew()).size(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)this.backdoor.columnControl().getUserColumns(result.getUserNameNew()).get(0), (Matcher)Matchers.equalTo((Object)new ColumnControl.ColumnItem("issuekey", "Key")));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void portalPageCacheShouldBeInvalidatedAfterUserKeyChange() {
        DashboardControl.Dashboard dashboard = this.backdoor.dashboard().createDashboard("fred2", "A test dashboard", "asdfasdg", Layout.AA, false, false);
        this.backdoor.dashboard().getDashboard(dashboard.getId().longValue());
        this.backdoor.dashboard().getOwnedDashboard("fred");
        UserAnonymizeControl.AnonymizePerformResult anonymizeResult = this.userAnonymizeControl.anonymize("fred2", false, "fred2", "fred2", "admin");
        this.assertEventPublished(UserKeyInPortalPageFKChangedEvent.class);
        Optional byId = ((DashboardControl)this.backdoor.dashboard().loginAs("admin")).getDashboard(dashboard.getId().longValue(), anonymizeResult.getUserNameNew());
        Assert.assertTrue((boolean)byId.isPresent());
        Assert.assertThat((Object)((DashboardControl.Dashboard)byId.get()).getOwner(), (Matcher)Matchers.equalTo((Object)anonymizeResult.getUserNameNew()));
        List byOwner = this.backdoor.dashboard().getOwnedDashboard(anonymizeResult.getUserNameNew());
        Assert.assertThat((Object)byOwner.size(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)((DashboardControl.Dashboard)byOwner.get(0)).getId(), (Matcher)Matchers.equalTo((Object)dashboard.getId()));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void filtersCacheShouldBeInvalidatedAfterUserKeyChange() {
        this.backdoor.usersAndGroups().addUserToGroup("admin", "jira-users");
        String filterId = this.backdoor.filters().createFilter("status != Closed order by updated desc", "some filter", "fred2", "jira-users");
        this.backdoor.filters().getFilter(Long.parseLong(filterId));
        UserAnonymizeControl.AnonymizePerformResult anonymizeResult = this.userAnonymizeControl.anonymize("fred2", false, "fred2", "fred2", "admin");
        FilterInfo filter = this.backdoor.filters().getFilter(Long.parseLong(filterId));
        Assert.assertThat((Object)filter.owner, (Matcher)Matchers.is((Object)anonymizeResult.getUserNameNew()));
        this.assertEventPublished(SearchRequestUserFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void permissionSchemeCacheShouldBeInvalidatedAfterUserKeyChange() {
        String newKey = "fred_new_key";
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.ARCHIVE_ISSUES, "fred");
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertEventPublished(SchemePermissionsFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void userHistoryCacheShouldBeInvalidatedAfterUserKeyChange() {
        String newKey = "fred_new_key";
        SearchResult searchBeginning = ((SearchClient)this.backdoor.search().loginAs("fred")).getSearch(new SearchRequest().jql("issuekey in issueHistory() ORDER BY lastViewed DESC"));
        Assert.assertThat((Object)searchBeginning.issues, (Matcher)Matchers.empty());
        this.backdoor.issues().loginAs("fred").getIssue("ANON-2", true, new Issue.Expand[0]);
        SearchResult searchWithIssueInHistory = ((SearchClient)this.backdoor.search().loginAs("fred")).getSearch(new SearchRequest().jql("issuekey in issueHistory() ORDER BY lastViewed DESC"));
        Assert.assertThat((Object)searchWithIssueInHistory.issues, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((Issue)searchWithIssueInHistory.issues.get((int)0)).key, (Matcher)Matchers.equalTo((Object)"ANON-2"));
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        SearchResult searchAfter = ((SearchClient)this.backdoor.search().loginAs("fred")).getSearch(new SearchRequest().jql("issuekey in issueHistory() ORDER BY lastViewed DESC"));
        Assert.assertThat((Object)searchAfter.issues, (Matcher)Matchers.empty());
        this.assertEventPublished(UserHistoryItemFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void projectRoleActorCacheShouldBeInvalidatedAfterUserKeyChange() {
        String newKey = "fred_new_key";
        ProjectRole usersRolesBefore = this.backdoor.projectRole().get("ANON", "Users");
        Assert.assertThat((Object)usersRolesBefore.actors, (Matcher)Matchers.hasItem(this.projectActor("fred", FRED_NORMAL_FULL_NAME)));
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        ProjectRole usersRolesAfter = this.backdoor.projectRole().get("ANON", "Users");
        Assert.assertThat((Object)usersRolesAfter.actors, (Matcher)Matchers.hasItem(this.projectActor("fred_new_key", "fred_new_key")));
        this.assertEventPublished(ProjectRoleActorFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void oauthspTokenCacheShouldBeInvalidatedAfterUserKeyChange() {
        String newKey = "fred_new_key";
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertEventPublished(OAuthspTokenFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void sharePermissionCacheShouldBeInvalidatedAfterUserKeyChange() {
        String newKey = "fred_new_key";
        String filterId = this.createFilter();
        this.addFilterPermissions(filterId, "fred");
        Filter filterBefore = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertThat((Object)filterBefore.sharePermissions, (Matcher)Matchers.hasSize((int)1));
        Filter.FilterPermission permissionBefore = (Filter.FilterPermission)filterBefore.sharePermissions.get(0);
        Assert.assertThat((Object)permissionBefore.type, (Matcher)Matchers.equalTo((Object)"user"));
        Assert.assertThat((Object)permissionBefore.user, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)permissionBefore.user.name, (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)permissionBefore.user.key, (Matcher)Matchers.equalTo((Object)"fred"));
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        Filter filterAfter = this.filterClient.get(filterId, new Filter.Expand[0]);
        Assert.assertThat((Object)filterAfter.sharePermissions, (Matcher)Matchers.hasSize((int)1));
        Filter.FilterPermission permissionAfter = (Filter.FilterPermission)filterAfter.sharePermissions.get(0);
        Assert.assertThat((Object)permissionAfter.type, (Matcher)Matchers.equalTo((Object)"user-unknown"));
        Assert.assertThat((Object)permissionAfter.user, (Matcher)Matchers.nullValue());
        this.assertEventPublished(SharePermissionsFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void cfDefaultValuesForSingleUserPickerShouldBeInvalidatedAfterUserKeyChange() {
        String newKey = "fred_new_key";
        long cfId = 10000L;
        this.assertCreateMetaDefaultValueContains(10000L, Matchers.hasEntry((Object)"key", (Object)"fred"));
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertCreateMetaDefaultValueContains(10000L, Matchers.hasEntry((Object)"key", (Object)"fred_new_key"));
        this.assertEventPublished(CustomFieldDefaultValueFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void cfDefaultValuesForMultiUserPickerShouldBeInvalidatedAfterUserKeyChange() {
        String oldKey = "fred1";
        String newKey = "fred_new_key";
        long cfId = 10100L;
        this.assertCreateMetaDefaultValueContains(10100L, Matchers.contains((Matcher)Matchers.hasEntry((Object)"key", (Object)"fred1")));
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred1", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        this.assertCreateMetaDefaultValueContains(10100L, Matchers.contains((Matcher)Matchers.hasEntry((Object)"key", (Object)"fred_new_key")));
        this.assertEventPublished(CustomFieldDefaultValueFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void projectCacheShouldBeInvalidatedAfterUserKeyChange() {
        this.backdoor.project().setProjectLead(10110L, "fred");
        String newKey = "fred_new_key";
        Project projectBefore = this.backdoor.project().getProject("ANON");
        Assert.assertThat((Object)projectBefore.lead.key, (Matcher)Matchers.equalTo((Object)"fred"));
        ParsedResponse response = this.foreignKeysClient.triggerUpdate("fred", "fred_new_key");
        Assert.assertEquals((long)200L, (long)response.statusCode);
        Project projectAfter = this.backdoor.project().getProject("ANON");
        Assert.assertThat((Object)projectAfter.lead.key, (Matcher)Matchers.equalTo((Object)"fred_new_key"));
        this.assertEventPublished(ProjectFKChangedEvent.class);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=806000)
    public void issueHistoryStringForMultiUserPicker() {
        String username = "user, name";
        String displayName = "Some, display, name";
        this.backdoor.usersAndGroups().addUser("user, name", "test", "Some, display, name", "test@jira.invalid");
        UserDTO user1 = this.backdoor.usersAndGroups().getUserByName("user, name");
        String username2 = "user, name2";
        String displayName2 = "Some, display, name2";
        this.backdoor.usersAndGroups().addUser("user, name2", "test", "Some, display, name2", "test@jira.invalid");
        UserDTO user2 = this.backdoor.usersAndGroups().getUserByName("user, name2");
        IssueCreateResponse issue = this.backdoor.issues().createIssue("ANON", "test watches anonymization");
        String keyWithEscapedCommas = this.keyWithEscapedCommas(user1.getKey());
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().customField(Long.valueOf(10100L), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"name", (Object)keyWithEscapedCommas))));
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().customField(Long.valueOf(10100L), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"name", (Object)"admin"), (Object)ImmutableMap.of((Object)"name", (Object)keyWithEscapedCommas))));
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().customField(Long.valueOf(10100L), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"name", (Object)"admin"))));
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().customField(Long.valueOf(10100L), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"name", (Object)keyWithEscapedCommas), (Object)ImmutableMap.of((Object)"name", (Object)this.keyWithEscapedCommas(user2.getKey())))));
        this.backdoor.issues().setIssueFields(issue.key, new IssueFields().customField(Long.valueOf(10100L), (Object)ImmutableList.of()));
        UserDTO withNewName = new UserDTO(user1.isActive(), user1.getDirectoryId(), user1.getDisplayName().toUpperCase(), user1.getEmail(), user1.getKey(), user1.getName(), user1.getUsername(), Long.valueOf(user1.getId()));
        this.backdoor.usersAndGroups().updateUser(withNewName);
        UserDTO withNewName2 = new UserDTO(user2.isActive(), user2.getDirectoryId(), "Not matching display name", user2.getEmail(), user2.getKey(), user2.getName(), user2.getUsername(), Long.valueOf(user2.getId()));
        this.backdoor.usersAndGroups().updateUser(withNewName2);
        UserAnonymizeControl.AnonymizePerformResult anonymizeResult = this.userAnonymizeControl.anonymize(user1.getKey(), false, null, null, "admin");
        this.backdoor.indexing().reindexAll();
        UserDTO userAfterAnonymize = this.backdoor.usersAndGroups().getUserByName(anonymizeResult.getUserNameNew());
        Issue issueAfter = this.backdoor.issues().getIssue(issue.key, new Issue.Expand[]{Issue.Expand.changelog});
        List changeItemsAfter = issueAfter.changelog.histories.stream().flatMap(history -> history.items.stream()).collect(Collectors.toList());
        Assert.assertThat(changeItemsAfter, (Matcher)Matchers.allOf((Matcher)Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, "[fred1]", String.format("[%s]", userAfterAnonymize.getKey()), "Fred Normal 1", String.format("%s", userAfterAnonymize.getKey()))), (Matcher)Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, String.format("[%s]", userAfterAnonymize.getKey()), String.format("[admin, %s]", userAfterAnonymize.getKey()), userAfterAnonymize.getKey(), String.format("Administrator, %s", userAfterAnonymize.getKey()))), (Matcher)Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, String.format("[admin, %s]", userAfterAnonymize.getKey()), "[admin]", String.format("Administrator, %s", userAfterAnonymize.getKey()), ADMINISTRATOR_FULL_NAME)), (Matcher)Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, "[admin]", String.format("[%s, %s]", userAfterAnonymize.getKey(), "user, name2"), ADMINISTRATOR_FULL_NAME, String.format("%s, %s", userAfterAnonymize.getKey(), "Some, display, name2"))), (Matcher)Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, String.format("[%s, %s]", userAfterAnonymize.getKey(), "user, name2"), (Matcher<String>)this.matchesEmptyStringOrNull(), String.format("%s, %s", userAfterAnonymize.getKey(), "Some, display, name2"), (Matcher<String>)this.matchesEmptyStringOrNull()))));
        UserAnonymizeControl.AnonymizePerformResult anonymizeResult2 = this.userAnonymizeControl.anonymize(user2.getKey(), false, null, null, "admin");
        this.backdoor.indexing().reindexAll();
        UserDTO userAfterAnonymize2 = this.backdoor.usersAndGroups().getUserByName(anonymizeResult2.getUserNameNew());
        Issue issueAfter2 = this.backdoor.issues().getIssue(issue.key, new Issue.Expand[]{Issue.Expand.changelog});
        List changeItemsAfter2 = issueAfter2.changelog.histories.stream().flatMap(history -> history.items.stream()).collect(Collectors.toList());
        Assert.assertThat(changeItemsAfter2, (Matcher)Matchers.allOf((Matcher)Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, "[fred1]", String.format("[%s]", userAfterAnonymize.getKey()), "Fred Normal 1", String.format("%s", userAfterAnonymize.getKey()))), (Matcher)Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, String.format("[%s]", userAfterAnonymize.getKey()), String.format("[admin, %s]", userAfterAnonymize.getKey()), userAfterAnonymize.getKey(), String.format("Administrator, %s", userAfterAnonymize.getKey()))), (Matcher)Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, String.format("[admin, %s]", userAfterAnonymize.getKey()), "[admin]", String.format("Administrator, %s", userAfterAnonymize.getKey()), ADMINISTRATOR_FULL_NAME)), (Matcher)Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, "[admin]", String.format("[%s, %s]", userAfterAnonymize.getKey(), userAfterAnonymize2.getKey()), ADMINISTRATOR_FULL_NAME, String.format("%s, %s", userAfterAnonymize.getKey(), "Some, display, name2"))), (Matcher)Matchers.hasItem(this.matchesHistory(JIRA_CUSTOM_FIELD, MULTI_USER_PICKER_FIELD_ID, String.format("[%s, %s]", userAfterAnonymize.getKey(), userAfterAnonymize2.getKey()), (Matcher<String>)this.matchesEmptyStringOrNull(), String.format("%s, %s", userAfterAnonymize.getKey(), "Some, display, name2"), (Matcher<String>)this.matchesEmptyStringOrNull()))));
    }

    private List<String> getVotersKeys(VotesClient votesClient, String issueKey) {
        return votesClient.get((String)issueKey).voters.stream().map(user -> user.key).collect(Collectors.toList());
    }

    private List<String> getWatchersKeys(WatchersClient watchersClient, String issueKey) {
        return watchersClient.get((String)issueKey).watchers.stream().map(user -> user.key).collect(Collectors.toList());
    }

    private Matcher<Object> projectActor(String name, String displayName) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)name)), (Matcher)Matchers.hasProperty((String)"displayName", (Matcher)Matchers.equalTo((Object)displayName)));
    }

    private void addFilterPermissions(String filterId, String userKey) {
        ParsedResponse addPermissionResponse = this.filterClient.postFilterPermission(filterId, new FilterClient.FilterPermissionInputBean("user", null, null, null, userKey, true, true));
        Assert.assertThat((Object)addPermissionResponse.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.CREATED.code));
    }

    private String createFilter() {
        Filter filter1 = new Filter();
        filter1.name = "Admin's ANON filter";
        filter1.jql = "project=ANON";
        filter1.description = "test description";
        filter1.favourite = true;
        ParsedResponse filterResponse = this.filterClient.postFilterResponse(filter1, new Filter.Expand[0]);
        Assert.assertThat((Object)filterResponse.statusCode, (Matcher)Matchers.equalTo((Object)HttpStatus.OK.code));
        return ((Filter)filterResponse.body).id;
    }

    private <T> void assertCreateMetaDefaultValueContains(long cfId, Matcher<T> matcher) {
        PageBean issueTypePage = this.issueClient.getCreateIssueMetaProjectIssueTypes("ANON", Long.valueOf(0L), Integer.valueOf(1));
        IssueType issueType = (IssueType)issueTypePage.getValues().get(0);
        PageBean fieldMetaDataPage = this.issueClient.getCreateIssueMetaFields("ANON", issueType.id, Long.valueOf(0L), Integer.valueOf(100));
        FieldMetaData fieldUserPicker = null;
        for (FieldMetaData fieldMetaData : fieldMetaDataPage.getValues()) {
            if (fieldMetaData.schema == null || fieldMetaData.schema.customId == null || fieldMetaData.schema.customId != cfId) continue;
            fieldUserPicker = fieldMetaData;
            break;
        }
        if (fieldUserPicker == null) {
            throw new AssertionError((Object)("Not found field with key: " + cfId + ". Fields found: " + fieldMetaDataPage.getValues()));
        }
        Object fieldUserPickerDefaultValue = fieldUserPicker.defaultValue;
        Assert.assertThat((Object)fieldUserPickerDefaultValue, matcher);
    }

    private AnyOf<String> matchesEmptyStringOrNull() {
        return Matchers.anyOf((Matcher)Matchers.equalTo((Object)""), (Matcher)CoreMatchers.nullValue(String.class));
    }

    private Matcher<ChangeLog.HistoryItem> matchesHistory(String fieldType, String field, String from, String to) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"fieldtype", (Matcher)Matchers.equalTo((Object)fieldType)), (Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)field)), (Matcher)Matchers.hasProperty((String)"from", (Matcher)Matchers.equalTo((Object)from)), (Matcher)Matchers.hasProperty((String)"to", (Matcher)Matchers.equalTo((Object)to)));
    }

    private Matcher<ChangeLog.HistoryItem> matchesHistory(String fieldType, String field, String from, String to, String fromString, String toString) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"fieldtype", (Matcher)Matchers.equalTo((Object)fieldType)), (Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)field)), (Matcher)Matchers.hasProperty((String)"from", (Matcher)Matchers.equalTo((Object)from)), (Matcher)Matchers.hasProperty((String)"to", (Matcher)Matchers.equalTo((Object)to)), (Matcher)Matchers.hasProperty((String)"fromString", (Matcher)Matchers.equalTo((Object)fromString)), (Matcher)Matchers.hasProperty((String)"toString", (Matcher)Matchers.equalTo((Object)toString)));
    }

    private Matcher<ChangeLog.HistoryItem> matchesHistory(String fieldType, String field, String from, Matcher<String> toMatcher) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"fieldtype", (Matcher)Matchers.equalTo((Object)fieldType)), (Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)field)), (Matcher)Matchers.hasProperty((String)"from", (Matcher)Matchers.equalTo((Object)from)), (Matcher)Matchers.hasProperty((String)"to", toMatcher));
    }

    private Matcher<ChangeLog.HistoryItem> matchesHistory(String fieldType, String field, String from, Matcher<String> toMatcher, String fromString, Matcher<String> toStringMatcher) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"fieldtype", (Matcher)Matchers.equalTo((Object)fieldType)), (Matcher)Matchers.hasProperty((String)"field", (Matcher)Matchers.equalTo((Object)field)), (Matcher)Matchers.hasProperty((String)"from", (Matcher)Matchers.equalTo((Object)from)), (Matcher)Matchers.hasProperty((String)"to", toMatcher), (Matcher)Matchers.hasProperty((String)"fromString", (Matcher)Matchers.equalTo((Object)fromString)), (Matcher)Matchers.hasProperty((String)"toString", toStringMatcher));
    }

    private void shouldFailWithException(Runnable runnable) {
        try {
            runnable.run();
            Assert.fail((String)"should fail on jql query");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void assertEventPublished(Class<? extends UserKeyFKChangedEvent> event) {
        Assert.assertThat(this.eventPoller.events(), (Matcher)Matchers.hasItem((Object)event.getName()));
    }

    private String keyWithEscapedCommas(String key) {
        return key.replaceAll(",", "\\\\,");
    }
}

