/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.anonymize;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraRestTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.UserAnonymizeControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.user.anonymization.AffectedEntityBean;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationProgressBean;
import com.atlassian.jira.rest.v2.user.anonymization.UserAnonymizationValidationBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.ANONYMIZE_USER})
@LoginAs(user="admin")
@RestoreBlankInstance
public class TestUserAnonymizationResource
extends BaseJiraRestTest {
    private static final String EXPAND_AFFECTED_ENTITIES = "affectedEntities";
    private static final String SHOW_ENTITIES = "Show entities";
    private static final String SHOW_ENTITIES_URL = "http://www.atlassian.com";
    static final String OTHER_USERNAME = "JIRAUSER10100";
    static final String OTHER_USERKEY = "JIRAUSER10100";
    private static final String MISSING_USERKEY = "missingkey";
    private UserAnonymizeControl userAnonymizeControl;
    private WorklogClient worklogClient;
    @Inject
    private FuncTestLogger logger;

    @Before
    public void setUp() {
        this.userAnonymizeControl = new UserAnonymizeControl(this.environmentData);
        this.worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
    }

    @Test
    public void validateShouldReturnValidationErrors() {
        String adminUserKey = this.backdoor.usersAndGroups().getUserByName("admin").getKey();
        try {
            this.userAnonymizeControl.validateUserAnonymization(adminUserKey, EXPAND_AFFECTED_ENTITIES);
            Assert.fail((String)"Expected a 400 response due to a failed validation");
        }
        catch (WebApplicationException e) {
            Assert.assertThat((Object)e.getResponse().getStatusInfo(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST));
            UserAnonymizationValidationBean validationBean = (UserAnonymizationValidationBean)e.getResponse().readEntity(UserAnonymizationValidationBean.class);
            Assert.assertNull((Object)validationBean.getUserName());
            Assert.assertNull((Object)validationBean.getDisplayName());
            Assert.assertFalse((boolean)validationBean.isDeleted());
            Assert.assertNull((Object)validationBean.getEmail());
            Assert.assertThat((Object)validationBean.getUserKey(), (Matcher)Matchers.equalTo((Object)adminUserKey));
            Assert.assertThat((Object)validationBean.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
            Assert.assertThat((Object)validationBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)validationBean.getAffectedEntities().size(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)validationBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertTrue((boolean)validationBean.getErrors().containsKey("GENERAL"));
            Assert.assertThat((Object)((ErrorCollection)validationBean.getErrors().get("GENERAL")).getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"You can't anonymize yourself."}));
            Assert.assertThat((Object)validationBean.getOperations(), (Matcher)Matchers.empty());
        }
    }

    @SinceBuildRule.SinceBuild(buildNumber=806000)
    @Restore(value="MNSTR-2800.xml")
    @Test
    public void validateRerunShouldReturnValidationErrors() {
        String otherUserKey = this.backdoor.usersAndGroups().getUserByName("JIRAUSER10100").getKey();
        String fredUserKey = this.backdoor.usersAndGroups().getUserByName("fred").getKey();
        try {
            this.userAnonymizeControl.validateUserAnonymizationRerun(otherUserKey, fredUserKey, "JIRAUSER10100", EXPAND_AFFECTED_ENTITIES);
            Assert.fail((String)"Expected a 400 response due to a failed validation");
        }
        catch (WebApplicationException e) {
            Assert.assertThat((Object)e.getResponse().getStatusInfo(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST));
            UserAnonymizationValidationBean validationBean = (UserAnonymizationValidationBean)e.getResponse().readEntity(UserAnonymizationValidationBean.class);
            Assert.assertNull((Object)validationBean.getUserName());
            Assert.assertNull((Object)validationBean.getDisplayName());
            Assert.assertFalse((boolean)validationBean.isDeleted());
            Assert.assertNull((Object)validationBean.getEmail());
            Assert.assertThat((Object)validationBean.getUserKey(), (Matcher)Matchers.equalTo((Object)otherUserKey));
            Assert.assertThat((Object)validationBean.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
            Assert.assertThat((Object)validationBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)validationBean.getAffectedEntities().size(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)validationBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertTrue((boolean)validationBean.getErrors().containsKey("GENERAL"));
            Assert.assertThat((Object)((ErrorCollection)validationBean.getErrors().get("GENERAL")).getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"There's another user with this user key: fred"}));
            Assert.assertThat((Object)validationBean.getOperations(), (Matcher)Matchers.empty());
        }
    }

    @SinceBuildRule.SinceBuild(buildNumber=806000)
    @Restore(value="MNSTR-2800.xml")
    @Test
    public void validateRerunShouldReturnAffectedEntitiesForOldUserKey() throws InterruptedException {
        this.waitForAOTasksToFinish();
        String otherUserKey = this.backdoor.usersAndGroups().getUserByName("JIRAUSER10100").getKey();
        UserAnonymizationValidationBean validationBean = this.userAnonymizeControl.validateUserAnonymizationRerun(otherUserKey, MISSING_USERKEY, "JIRAUSER10100", EXPAND_AFFECTED_ENTITIES);
        Assert.assertThat((Object)validationBean.getUserName(), (Matcher)Matchers.equalTo((Object)"JIRAUSER10100"));
        Assert.assertThat((Object)validationBean.getDisplayName(), (Matcher)Matchers.equalTo((Object)"JIRAUSER10100"));
        Assert.assertFalse((boolean)validationBean.isDeleted());
        Assert.assertThat((Object)validationBean.getEmail(), (Matcher)Matchers.equalTo((Object)"toanonymize@example.com"));
        Assert.assertThat((Object)validationBean.getUserKey(), (Matcher)Matchers.equalTo((Object)"JIRAUSER10100"));
        Assert.assertThat((Object)validationBean.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)validationBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getAffectedEntities().size(), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.MANUAL), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.MANUAL, "Some entity to be updated manually", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.ANONYMIZE), (Matcher)Matchers.hasItems((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User key entries in the database", null, null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Some entity to be anonymized", null, null, null)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.TRANSFER_OWNERSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Some entity that ownership will be transferred to other user", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Some entity that ownership will be transferred to other user", null, null, null)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.REMOVE), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.REMOVE, "Some entity to be removed", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.REMOVE, "Some entity to be removed", null, null, null)}));
        Assert.assertThat((Object)validationBean.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"USER_KEY_CHANGE_PLUGIN_POINTS", "USER_DISABLE", "USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS", "USER_ANONYMIZE_PLUGIN_POINTS", "USER_EXTERNAL_ID_CHANGE"}));
    }

    @Test
    public void validateShouldReturnAffectedEntities() throws InterruptedException {
        this.waitForAOTasksToFinish();
        String fredUserKey = this.backdoor.usersAndGroups().getUserByName("fred").getKey();
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        Long projectId = this.backdoor.project().getProjectId("MKY");
        this.backdoor.project().setProjectLead(projectId, "fred");
        this.backdoor.project().setProjectDefaultAssignee(projectId, true);
        Project project = this.backdoor.project().getProject("MKY");
        Assert.assertThat((Object)project.lead.name, (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)project.assigneeType, (Matcher)Matchers.equalTo((Object)Project.AssigneeType.PROJECT_LEAD));
        this.backdoor.components().create(new Component().project("MKY").name("some component").leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD));
        this.backdoor.components().create(new Component().project("HSP").name("another component").leadUserName("fred").assigneeType(Component.AssigneeType.PROJECT_DEFAULT));
        this.backdoor.issues().createIssue("MKY", "Summary", "fred");
        this.backdoor.issues().commentIssue("MKY-1", "Hey [~fred]!");
        Worklog worklog = this.getMockWorklog();
        this.worklogClient.post("MKY-1", worklog);
        UserAnonymizationValidationBean validationBean = this.userAnonymizeControl.validateUserAnonymization(fredUserKey, EXPAND_AFFECTED_ENTITIES);
        Assert.assertThat((Object)validationBean.getExpand(), (Matcher)Matchers.equalTo((Object)EXPAND_AFFECTED_ENTITIES));
        Assert.assertThat((Object)validationBean.getUserName(), (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)validationBean.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Fred Normal"));
        Assert.assertFalse((boolean)validationBean.isDeleted());
        Assert.assertThat((Object)validationBean.getEmail(), (Matcher)Matchers.equalTo((Object)"fred@example.com"));
        Assert.assertThat((Object)validationBean.getUserKey(), (Matcher)Matchers.equalTo((Object)fredUserKey));
        Assert.assertThat((Object)validationBean.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)validationBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getAffectedEntities().size(), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.TRANSFER_OWNERSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Component Lead", Long.valueOf(2L), null, null), new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Project Lead", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Some entity that ownership will be transferred to other user", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Some entity that ownership will be transferred to other user", null, null, null)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.ANONYMIZE), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User Profile", Long.valueOf(1L), "User Profile", this.getBaseUrl() + "/secure/ViewProfile.jspa?name=fred"), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User key entries in the database", null, null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Some entity to be anonymized", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Some entity to be anonymized", null, null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Comments", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Work logs", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Full name in issue history", null, null, null)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.MANUAL), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.MANUAL, "Some entity to be updated manually", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.REMOVE), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.REMOVE, "Notifications (recipients)", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.REMOVE, "Some entity to be removed", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.REMOVE, "Some entity to be removed", null, null, null)}));
        Assert.assertThat((Object)validationBean.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"USER_NAME_CHANGE", "USER_KEY_CHANGE_PLUGIN_POINTS", "USER_KEY_CHANGE", "USER_DISABLE", "USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS", "USER_NAME_CHANGE_PLUGIN_POINTS", "USER_ANONYMIZE_PLUGIN_POINTS", "USER_EXTERNAL_ID_CHANGE"}));
    }

    @Test
    public void validateShouldHandleDeletedUser() {
        String userToBeDeleted = "userToBeDeleted";
        this.backdoor.usersAndGroups().addUser("userToBeDeleted");
        String userToBeDeletedKey = this.backdoor.usersAndGroups().getUserByName("userToBeDeleted").getKey();
        this.backdoor.usersAndGroups().deleteUser("userToBeDeleted");
        UserAnonymizationValidationBean validationBean = this.userAnonymizeControl.validateUserAnonymization(userToBeDeletedKey, null);
        Assert.assertThat((Object)validationBean.getExpand(), (Matcher)Matchers.equalTo((Object)EXPAND_AFFECTED_ENTITIES));
        Assert.assertThat((Object)validationBean.getUserName(), (Matcher)Matchers.equalTo((Object)"userToBeDeleted".toLowerCase()));
        Assert.assertThat((Object)validationBean.getDisplayName(), (Matcher)Matchers.equalTo((Object)"userToBeDeleted".toLowerCase()));
        Assert.assertTrue((boolean)validationBean.isDeleted());
        Assert.assertThat((Object)validationBean.getEmail(), (Matcher)Matchers.equalTo((Object)"?"));
        Assert.assertThat((Object)validationBean.getUserKey(), (Matcher)Matchers.equalTo((Object)userToBeDeletedKey));
        Assert.assertThat((Object)validationBean.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)validationBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getAffectedEntities(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)validationBean.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"USER_NAME_CHANGE", "USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS", "USER_NAME_CHANGE_PLUGIN_POINTS", "USER_ANONYMIZE_PLUGIN_POINTS"}));
    }

    @Test
    public void whenGetAffectedEntitiesParameterIsFalseThenValidateShouldNotReturnAffectedEntities() {
        String fredUserKey = this.backdoor.usersAndGroups().getUserByName("fred").getKey();
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
        Long projectId = this.backdoor.project().getProjectId("MKY");
        this.backdoor.project().setProjectLead(projectId, "fred");
        this.backdoor.project().setProjectDefaultAssignee(projectId, true);
        Project project = this.backdoor.project().getProject("MKY");
        Assert.assertThat((Object)project.lead.name, (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)project.assigneeType, (Matcher)Matchers.equalTo((Object)Project.AssigneeType.PROJECT_LEAD));
        this.backdoor.components().create(new Component().project("MKY").name("some component").leadUserName("fred").assigneeType(Component.AssigneeType.COMPONENT_LEAD));
        this.backdoor.components().create(new Component().project("HSP").name("another component").leadUserName("fred").assigneeType(Component.AssigneeType.PROJECT_DEFAULT));
        this.backdoor.issues().createIssue("MKY", "Summary", "fred");
        this.backdoor.issues().commentIssue("MKY-1", "Hey [~fred]!");
        Worklog worklog = this.getMockWorklog();
        this.worklogClient.post("MKY-1", worklog);
        UserAnonymizationValidationBean validationBean = this.userAnonymizeControl.validateUserAnonymization(fredUserKey, null);
        Assert.assertThat((Object)validationBean.getExpand(), (Matcher)Matchers.equalTo((Object)EXPAND_AFFECTED_ENTITIES));
        Assert.assertThat((Object)validationBean.getUserName(), (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)validationBean.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Fred Normal"));
        Assert.assertFalse((boolean)validationBean.isDeleted());
        Assert.assertThat((Object)validationBean.getEmail(), (Matcher)Matchers.equalTo((Object)"fred@example.com"));
        Assert.assertThat((Object)validationBean.getUserKey(), (Matcher)Matchers.equalTo((Object)fredUserKey));
        Assert.assertThat((Object)validationBean.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)validationBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getAffectedEntities(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)validationBean.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"USER_NAME_CHANGE", "USER_KEY_CHANGE_PLUGIN_POINTS", "USER_KEY_CHANGE", "USER_DISABLE", "USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS", "USER_NAME_CHANGE_PLUGIN_POINTS", "USER_ANONYMIZE_PLUGIN_POINTS", "USER_EXTERNAL_ID_CHANGE"}));
    }

    @SinceBuildRule.SinceBuild(buildNumber=806000)
    @Restore(value="anonymization-rerun-from-anonymization-step.xml")
    @Test
    public void validateShouldReturnAffectedEntitiesOnReRunFromAnonymizationStep() throws InterruptedException {
        this.waitForAOTasksToFinish();
        String fredUserKey = this.backdoor.usersAndGroups().getUserByName("fred").getKey();
        UserAnonymizationValidationBean validationBean = this.userAnonymizeControl.validateUserAnonymizationRerun(fredUserKey, null, null, EXPAND_AFFECTED_ENTITIES);
        Assert.assertThat((Object)validationBean.getUserName(), (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)validationBean.getUserKey(), (Matcher)Matchers.equalTo((Object)fredUserKey));
        Assert.assertFalse((boolean)validationBean.isDeleted());
        Assert.assertThat((Object)validationBean.getEmail(), (Matcher)Matchers.endsWith((String)"fred@example.com"));
        Assert.assertThat((Object)validationBean.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)validationBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getAffectedEntities().size(), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.ANONYMIZE), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User key entries in the database", null, null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User Profile", Long.valueOf(1L), "User Profile", this.getBaseUrl() + "/secure/ViewProfile.jspa?name=fred"), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Some entity to be anonymized", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Some entity to be anonymized", null, null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Comments", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Work logs", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Text fields", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Mentions in issue history", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Full name in issue history", null, null, null)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.MANUAL), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.MANUAL, "Some entity to be updated manually", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.REMOVE), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.REMOVE, "Some entity to be removed", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.REMOVE, "Some entity to be removed", null, null, null)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.TRANSFER_OWNERSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Some entity that ownership will be transferred to other user", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Some entity that ownership will be transferred to other user", null, null, null)}));
        Assert.assertThat((Object)validationBean.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"USER_NAME_CHANGE", "USER_KEY_CHANGE_PLUGIN_POINTS", "USER_KEY_CHANGE", "USER_NAME_CHANGE_PLUGIN_POINTS", "USER_ANONYMIZE_PLUGIN_POINTS", "USER_EXTERNAL_ID_CHANGE", "USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS"}));
    }

    @SinceBuildRule.SinceBuild(buildNumber=806000)
    @Restore(value="anonymization-rerun-from-username-step.xml")
    @Test
    public void validateShouldReturnErrorsOnReRunFromUsernameChangeStep() throws InterruptedException {
        this.waitForAOTasksToFinish();
        String fredUserKey = this.backdoor.usersAndGroups().getUserByName("JIRAUSER10100").getKey();
        try {
            this.userAnonymizeControl.validateUserAnonymizationRerun(fredUserKey, null, null, EXPAND_AFFECTED_ENTITIES);
            Assert.fail((String)"Expected a 400 response because we didn't pass old user key and old username");
        }
        catch (WebApplicationException e) {
            Assert.assertThat((Object)e.getResponse().getStatusInfo(), (Matcher)Matchers.equalTo((Object)Response.Status.BAD_REQUEST));
            UserAnonymizationValidationBean validationBean = (UserAnonymizationValidationBean)e.getResponse().readEntity(UserAnonymizationValidationBean.class);
            Assert.assertThat((Object)validationBean.getUserKey(), (Matcher)Matchers.equalTo((Object)fredUserKey));
            Assert.assertThat((Object)validationBean.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
            Assert.assertThat((Object)validationBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)validationBean.getOperations().size(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)validationBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)2));
            Assert.assertTrue((boolean)validationBean.getErrors().containsKey("USER_KEY_CHANGE_PLUGIN_POINTS"));
            Assert.assertThat((Object)((ErrorCollection)validationBean.getErrors().get("USER_KEY_CHANGE_PLUGIN_POINTS")).getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"The new user key needs to be different from the original one."}));
            Assert.assertTrue((boolean)validationBean.getErrors().containsKey("USER_NAME_CHANGE_PLUGIN_POINTS"));
            Assert.assertThat((Object)((ErrorCollection)validationBean.getErrors().get("USER_NAME_CHANGE_PLUGIN_POINTS")).getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"The new username needs to be different from the original one."}));
        }
    }

    @SinceBuildRule.SinceBuild(buildNumber=806000)
    @Restore(value="anonymization-rerun-from-username-step.xml")
    @Test
    public void validateShouldReturnAffectedEntitiesOnReRunFromUsernameChangeStep() throws InterruptedException {
        this.waitForAOTasksToFinish();
        String fredUserKey = this.backdoor.usersAndGroups().getUserByName("JIRAUSER10100").getKey();
        UserAnonymizationValidationBean validationBean = this.userAnonymizeControl.validateUserAnonymizationRerun(fredUserKey, "fred", "fred", EXPAND_AFFECTED_ENTITIES);
        Assert.assertThat((Object)validationBean.getUserName(), (Matcher)Matchers.equalTo((Object)"JIRAUSER10100"));
        Assert.assertThat((Object)validationBean.getUserKey(), (Matcher)Matchers.equalTo((Object)fredUserKey));
        Assert.assertThat((Object)validationBean.getEmail(), (Matcher)Matchers.endsWith((String)"fred@example.com"));
        Assert.assertFalse((boolean)validationBean.isDeleted());
        Assert.assertThat((Object)validationBean.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)validationBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getAffectedEntities().size(), (Matcher)Matchers.equalTo((Object)4));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.ANONYMIZE), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User key entries in the database", null, null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Some entity to be anonymized", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Some entity to be anonymized", null, null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Comments", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Work logs", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Text fields", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Mentions in issue history", Long.valueOf(1L), null, null), new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "Full name in issue history", null, null, null)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.MANUAL), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.MANUAL, "Some entity to be updated manually", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.REMOVE), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.REMOVE, "Some entity to be removed", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.REMOVE, "Some entity to be removed", null, null, null)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.TRANSFER_OWNERSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Some entity that ownership will be transferred to other user", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Some entity that ownership will be transferred to other user", null, null, null)}));
        Assert.assertThat((Object)validationBean.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"USER_KEY_CHANGE_PLUGIN_POINTS", "USER_NAME_CHANGE_PLUGIN_POINTS", "USER_ANONYMIZE_PLUGIN_POINTS", "USER_EXTERNAL_ID_CHANGE", "USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS"}));
    }

    @SinceBuildRule.SinceBuild(buildNumber=806000)
    @Restore(value="anonymization-rerun-from-username-step.xml")
    @Test
    public void validateShouldAllowSkippingOperationsOnReRun() throws InterruptedException {
        this.waitForAOTasksToFinish();
        String fredUserKey = this.backdoor.usersAndGroups().getUserByName("JIRAUSER10100").getKey();
        UserAnonymizationValidationBean validationBean = this.userAnonymizeControl.validateUserAnonymizationRerun(fredUserKey, "JIRAUSER10100", "JIRAUSER10100", EXPAND_AFFECTED_ENTITIES);
        Assert.assertThat((Object)validationBean.getUserName(), (Matcher)Matchers.equalTo((Object)"JIRAUSER10100"));
        Assert.assertThat((Object)validationBean.getUserKey(), (Matcher)Matchers.equalTo((Object)fredUserKey));
        Assert.assertThat((Object)validationBean.getEmail(), (Matcher)Matchers.endsWith((String)"fred@example.com"));
        Assert.assertFalse((boolean)validationBean.isDeleted());
        Assert.assertThat((Object)validationBean.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)validationBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)validationBean.getAffectedEntities().size(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.ANONYMIZE), (Matcher)Matchers.hasItem((Object)new AffectedEntityBean(AffectedEntityType.ANONYMIZE, "User Profile", Long.valueOf(1L), "User Profile", this.getBaseUrl() + "/secure/ViewProfile.jspa?name=JIRAUSER10100")));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.REMOVE), (Matcher)Matchers.hasItems((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.REMOVE, "Some entity to be removed", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.REMOVE, "Some entity to be removed", null, null, null)}));
        Assert.assertThat(validationBean.getAffectedEntities().get(AffectedEntityType.TRANSFER_OWNERSHIP), (Matcher)Matchers.containsInAnyOrder((Object[])new AffectedEntityBean[]{new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Some entity that ownership will be transferred to other user", Long.valueOf(123L), SHOW_ENTITIES, SHOW_ENTITIES_URL), new AffectedEntityBean(AffectedEntityType.TRANSFER_OWNERSHIP, "Some entity that ownership will be transferred to other user", null, null, null)}));
        Assert.assertThat((Object)validationBean.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"USER_ANONYMIZE_PLUGIN_POINTS", "USER_EXTERNAL_ID_CHANGE", "USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS"}));
    }

    @SinceBuildRule.SinceBuild(buildNumber=806000)
    @Restore(value="anonymization-rerun-from-username-step.xml")
    @Test
    public void reRunShouldAllowSkippingOperations() throws InterruptedException {
        this.waitForAOTasksToFinish();
        String fredUserKey = this.backdoor.usersAndGroups().getUserByName("JIRAUSER10100").getKey();
        String adminUserKey = this.backdoor.usersAndGroups().getUserByName("admin").getKey();
        this.userAnonymizeControl.scheduleUserAnonymizationRerun(fredUserKey, adminUserKey, "JIRAUSER10100", "JIRAUSER10100");
        UserAnonymizationProgressBean progressBean = this.userAnonymizeControl.fetchFinishedProgressResult();
        Assert.assertThat((Object)progressBean.getUserKey(), (Matcher)Matchers.equalTo((Object)fredUserKey));
        Assert.assertThat((Object)progressBean.getUserName(), (Matcher)Matchers.equalTo((Object)"JIRAUSER10100"));
        Assert.assertThat((Object)progressBean.getFullName(), (Matcher)Matchers.equalTo((Object)"Fred Normal"));
        Assert.assertThat((Object)progressBean.getProgressUrl(), (Matcher)Matchers.startsWith((String)"/rest/api/2/user/anonymization/progress?taskId="));
        Assert.assertThat((Object)progressBean.getStartTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getSubmittedTime()));
        Assert.assertThat((Object)progressBean.getFinishTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getStartTime()));
        Assert.assertThat((Object)progressBean.getStatus(), (Matcher)Matchers.equalTo((Object)UserAnonymizationProgressBean.AnonymizationStatus.COMPLETED));
        Assert.assertThat((Object)progressBean.getCurrentProgress(), (Matcher)Matchers.equalTo((Object)100L));
        Assert.assertNotNull((Object)progressBean.getCurrentSubTask());
        Assert.assertThat((Object)progressBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)progressBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)progressBean.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"USER_ANONYMIZE_PLUGIN_POINTS", "USER_EXTERNAL_ID_CHANGE", "USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS"}));
        Assert.assertThat((Object)progressBean.isRerun(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void getProgressShouldReturnValidationErrors() {
        String adminUserKey = this.backdoor.usersAndGroups().getUserByName("admin").getKey();
        this.userAnonymizeControl.scheduleUserAnonymization(adminUserKey, "fred");
        UserAnonymizationProgressBean progressBean = this.userAnonymizeControl.fetchFinishedProgressResult();
        Assert.assertThat((Object)progressBean.getUserKey(), (Matcher)Matchers.equalTo((Object)adminUserKey));
        Assert.assertThat((Object)progressBean.getUserName(), (Matcher)Matchers.equalTo((Object)"admin"));
        Assert.assertThat((Object)progressBean.getFullName(), (Matcher)Matchers.equalTo((Object)"Administrator"));
        Assert.assertThat((Object)progressBean.getProgressUrl(), (Matcher)Matchers.startsWith((String)"/rest/api/2/user/anonymization/progress?taskId="));
        Assert.assertThat((Object)progressBean.getStartTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getSubmittedTime()));
        Assert.assertThat((Object)progressBean.getFinishTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getStartTime()));
        Assert.assertThat((Object)progressBean.getStatus(), (Matcher)Matchers.equalTo((Object)UserAnonymizationProgressBean.AnonymizationStatus.COMPLETED));
        Assert.assertThat((Object)progressBean.getCurrentProgress(), (Matcher)Matchers.equalTo((Object)100L));
        Assert.assertThat((Object)progressBean.getCurrentSubTask(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)progressBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)progressBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)progressBean.getErrors().containsKey("GENERAL"));
        Assert.assertThat((Object)((ErrorCollection)progressBean.getErrors().get("GENERAL")).getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"You can't anonymize yourself."}));
        Assert.assertThat((Object)progressBean.getOperations(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)progressBean.isRerun(), (Matcher)Matchers.equalTo((Object)false));
    }

    @SinceBuildRule.SinceBuild(buildNumber=806000)
    @Restore(value="MNSTR-2800.xml")
    @Test
    public void getProgressShouldReturnValidationErrorsOnRerun() {
        String adminUserKey = this.backdoor.usersAndGroups().getUserByName("admin").getKey();
        String otherUserKey = this.backdoor.usersAndGroups().getUserByName("JIRAUSER10100").getKey();
        String fredUserKey = this.backdoor.usersAndGroups().getUserByName("fred").getKey();
        this.userAnonymizeControl.scheduleUserAnonymizationRerun(otherUserKey, adminUserKey, fredUserKey, "JIRAUSER10100");
        UserAnonymizationProgressBean progressBean = this.userAnonymizeControl.fetchFinishedProgressResult();
        Assert.assertThat((Object)progressBean.getUserKey(), (Matcher)Matchers.equalTo((Object)fredUserKey));
        Assert.assertThat((Object)progressBean.getUserName(), (Matcher)Matchers.equalTo((Object)"JIRAUSER10100"));
        Assert.assertThat((Object)progressBean.getFullName(), (Matcher)Matchers.equalTo((Object)"JIRAUSER10100"));
        Assert.assertThat((Object)progressBean.getProgressUrl(), (Matcher)Matchers.startsWith((String)"/rest/api/2/user/anonymization/progress?taskId="));
        Assert.assertThat((Object)progressBean.getStartTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getSubmittedTime()));
        Assert.assertThat((Object)progressBean.getFinishTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getStartTime()));
        Assert.assertThat((Object)progressBean.getStatus(), (Matcher)Matchers.equalTo((Object)UserAnonymizationProgressBean.AnonymizationStatus.COMPLETED));
        Assert.assertThat((Object)progressBean.getCurrentProgress(), (Matcher)Matchers.equalTo((Object)100L));
        Assert.assertThat((Object)progressBean.getCurrentSubTask(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)progressBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)progressBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)progressBean.getErrors().containsKey("GENERAL"));
        Assert.assertThat((Object)((ErrorCollection)progressBean.getErrors().get("GENERAL")).getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"There's another user with this user key: fred"}));
        Assert.assertThat((Object)progressBean.getOperations(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)progressBean.isRerun(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void getProgressShouldReturnFinishedOperationResult() throws InterruptedException {
        this.waitForAOTasksToFinish();
        String fredUserKey = this.backdoor.usersAndGroups().getUserByName("fred").getKey();
        String adminUserKey = this.backdoor.usersAndGroups().getUserByName("admin").getKey();
        this.userAnonymizeControl.scheduleUserAnonymization(fredUserKey, adminUserKey);
        UserAnonymizationProgressBean progressBean = this.userAnonymizeControl.fetchFinishedProgressResult();
        Assert.assertThat((Object)progressBean.getUserKey(), (Matcher)Matchers.equalTo((Object)fredUserKey));
        Assert.assertThat((Object)progressBean.getUserName(), (Matcher)Matchers.equalTo((Object)"fred"));
        Assert.assertThat((Object)progressBean.getFullName(), (Matcher)Matchers.equalTo((Object)"Fred Normal"));
        Assert.assertThat((Object)progressBean.getProgressUrl(), (Matcher)Matchers.startsWith((String)"/rest/api/2/user/anonymization/progress?taskId="));
        Assert.assertThat((Object)progressBean.getStartTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getSubmittedTime()));
        Assert.assertThat((Object)progressBean.getFinishTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getStartTime()));
        Assert.assertThat((Object)progressBean.getStatus(), (Matcher)Matchers.equalTo((Object)UserAnonymizationProgressBean.AnonymizationStatus.COMPLETED));
        Assert.assertThat((Object)progressBean.getCurrentProgress(), (Matcher)Matchers.equalTo((Object)100L));
        Assert.assertNotNull((Object)progressBean.getCurrentSubTask());
        Assert.assertThat((Object)progressBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)progressBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)progressBean.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"USER_NAME_CHANGE", "USER_KEY_CHANGE_PLUGIN_POINTS", "USER_KEY_CHANGE", "USER_DISABLE", "USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS", "USER_NAME_CHANGE_PLUGIN_POINTS", "USER_ANONYMIZE_PLUGIN_POINTS", "USER_EXTERNAL_ID_CHANGE"}));
        Assert.assertThat((Object)progressBean.isRerun(), (Matcher)Matchers.equalTo((Object)false));
    }

    @SinceBuildRule.SinceBuild(buildNumber=806000)
    @Restore(value="MNSTR-2800.xml")
    @Test
    public void getProgressShouldReturnFinishedOperationResultOnRerunAndChangeAssignee() throws InterruptedException {
        this.waitForAOTasksToFinish();
        String adminUserKey = this.backdoor.usersAndGroups().getUserByName("admin").getKey();
        String otherUserKey = this.backdoor.usersAndGroups().getUserByName("JIRAUSER10100").getKey();
        this.userAnonymizeControl.scheduleUserAnonymizationRerun(otherUserKey, adminUserKey, MISSING_USERKEY, "JIRAUSER10100");
        Issue issueWithMissingUser = this.backdoor.issues().getIssue("HSP-2");
        Assert.assertThat((Object)issueWithMissingUser.fields.assignee.key, (Matcher)Matchers.equalTo((Object)MISSING_USERKEY));
        UserAnonymizationProgressBean progressBean = this.userAnonymizeControl.fetchFinishedProgressResult();
        Assert.assertThat((Object)progressBean.getUserKey(), (Matcher)Matchers.equalTo((Object)MISSING_USERKEY));
        Assert.assertThat((Object)progressBean.getUserName(), (Matcher)Matchers.equalTo((Object)"JIRAUSER10100"));
        Assert.assertThat((Object)progressBean.getFullName(), (Matcher)Matchers.equalTo((Object)"JIRAUSER10100"));
        Assert.assertThat((Object)progressBean.getProgressUrl(), (Matcher)Matchers.startsWith((String)"/rest/api/2/user/anonymization/progress?taskId="));
        Assert.assertThat((Object)progressBean.getStartTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getSubmittedTime()));
        Assert.assertThat((Object)progressBean.getFinishTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)progressBean.getStartTime()));
        Assert.assertThat((Object)progressBean.getStatus(), (Matcher)Matchers.equalTo((Object)UserAnonymizationProgressBean.AnonymizationStatus.COMPLETED));
        Assert.assertThat((Object)progressBean.getCurrentProgress(), (Matcher)Matchers.equalTo((Object)100L));
        Assert.assertThat((Object)progressBean.getCurrentSubTask(), (Matcher)Matchers.startsWith((String)"Changing user key in reference plugin"));
        Assert.assertThat((Object)progressBean.getWarnings().size(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)progressBean.getWarnings().containsKey("com.atlassian.jira.user.anonymize:user-profile-anonymization-handler"));
        Assert.assertThat((Object)((ErrorCollection)progressBean.getWarnings().get("com.atlassian.jira.user.anonymize:user-profile-anonymization-handler")).getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{"This user doesn't exist: missingkey"}));
        Assert.assertThat((Object)progressBean.getErrors().size(), (Matcher)Matchers.equalTo((Object)0));
        Issue issueWithMissingUserAfter = this.backdoor.issues().getIssue("HSP-2");
        Assert.assertThat((Object)issueWithMissingUserAfter.fields.assignee.key, (Matcher)Matchers.equalTo((Object)otherUserKey));
        Assert.assertThat((Object)progressBean.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"USER_KEY_CHANGE_PLUGIN_POINTS", "USER_DISABLE", "USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS", "USER_ANONYMIZE_PLUGIN_POINTS", "USER_EXTERNAL_ID_CHANGE"}));
        Assert.assertThat((Object)progressBean.isRerun(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Nonnull
    private String getBaseUrl() {
        return this.getEnvironmentData().getBaseUrl().toString();
    }

    private Worklog getMockWorklog() {
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        worklog.visibility = new Visibility();
        worklog.comment = "You did a lot, [~fred]!";
        return worklog;
    }

    private void waitForAOTasksToFinish() throws InterruptedException {
        int waitSeconds = 10;
        this.logger.log((Object)"Sleeping 10s to make sure AO tasks are finished");
        Thread.sleep(10000L);
    }
}

