/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.page.IssueSearchPage;
import com.atlassian.jira.functest.framework.page.ViewIssuePage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.table.HtmlTable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.ISSUES})
@LoginAs(user="admin")
public class TestUserRenameOnIssuePrintableView
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUpTest() {
        this.administration.restoreData("user_rename.xml");
    }

    @Test
    public void testPrintableViewWithRenamedUsers() {
        this.navigation.issue().viewPrintable("COW-1");
        this.assertPrintableViewUserLink("word_assignee_betty", "betty", "Betty Boop");
        this.assertPrintableViewUserLink("word_reporter_cat", "cat", "Crazy Cat");
        this.assertPrintableViewUser("multiuser_cf_admin", "admin", "Adam Ant");
        this.assertPrintableViewUser("multiuser_cf_bb", "bb", "Bob Belcher");
        this.assertPrintableViewUser("user_cf_cc", "cc", "Candy Chaos");
        this.navigation.issue().viewPrintable("COW-3");
        this.assertPrintableViewUserLink("word_assignee_bb", "bb", "Bob Belcher");
        this.assertPrintableViewUserLink("word_reporter_cc", "cc", "Candy Chaos");
        this.assertPrintableViewUser("multiuser_cf_admin", "admin", "Adam Ant");
        this.assertPrintableViewUser("multiuser_cf_betty", "betty", "Betty Boop");
        this.assertPrintableViewUser("user_cf_cat", "cat", "Crazy Cat");
        IssueSearchPage issueSearchPage = this.navigation.issueNavigator().runPrintableSearch("");
        HtmlTable searchResultsTable = issueSearchPage.getResultsTable();
        HtmlTable.Row row = searchResultsTable.getRow(2);
        this.assertTableUsername("bb", row, "Assignee");
        this.assertTableUsername("cc", row, "Reporter");
        this.assertTableUsername("cat", row, "Tester");
        this.assertTableUsernames(Arrays.asList("admin", "betty"), row, "CC");
        row = searchResultsTable.getRow(4);
        this.assertTableUsername("betty", row, "Assignee");
        this.assertTableUsername("cat", row, "Reporter");
        this.assertTableUsername("cc", row, "Tester");
        this.assertTableUsernames(Arrays.asList("admin", "bb"), row, "CC");
    }

    @Test
    public void testPrintableViewBeforeAndAfterAnotherRename() {
        this.navigation.issue().viewPrintable("COW-1");
        this.assertPrintableViewUser("user_cf_cc", "cc", "Candy Chaos");
        this.navigation.issue().viewPrintable("COW-3");
        this.assertPrintableViewUserLink("word_reporter_cc", "cc", "Candy Chaos");
        this.navigation.gotoPage("secure/admin/user/EditUser!default.jspa?editName=cc");
        this.tester.setFormElement("username", "candy");
        this.tester.submit("Update");
        Assert.assertEquals((Object)"/secure/admin/user/ViewUser.jspa?name=candy", (Object)this.navigation.getCurrentPage());
        Assert.assertEquals((Object)"candy", (Object)this.locator.id("username").getText());
        this.navigation.issue().viewPrintable("COW-1");
        this.assertPrintableViewUser("user_cf_candy", "candy", "Candy Chaos");
        this.navigation.issue().viewPrintable("COW-3");
        this.assertPrintableViewUserLink("word_reporter_candy", "candy", "Candy Chaos");
        IssueSearchPage issueSearchPage = this.navigation.issueNavigator().runPrintableSearch("");
        HtmlTable searchResultsTable = issueSearchPage.getResultsTable();
        this.assertTableUsername("candy", searchResultsTable.getRow(2), "Reporter");
        this.assertTableUsername("candy", searchResultsTable.getRow(4), "Tester");
    }

    private void assertPrintableViewText(String id, String expectedValue) {
        Assert.assertEquals((Object)expectedValue, (Object)this.locator.id(id).getText());
    }

    private void assertPrintableViewUser(String id, String username, String fullName) {
        Element span = (Element)this.locator.id(id).getNode();
        Assert.assertNotNull((Object)span);
        Assert.assertEquals((Object)username, (Object)span.getAttribute("rel"));
        this.assertPrintableViewText(id, fullName);
        Assert.assertEquals((Object)"span", (Object)span.getTagName());
        Assert.assertFalse((boolean)span.hasAttribute("href"));
    }

    private void assertPrintableViewUserLink(String id, String username, String fullName) {
        Element link = (Element)this.locator.id(id).getNode();
        Assert.assertNotNull((Object)link);
        Assert.assertEquals((Object)username, (Object)link.getAttribute("rel"));
        this.assertPrintableViewText(id, fullName);
        Assert.assertEquals((Object)"a", (Object)link.getTagName());
        Assert.assertTrue((boolean)link.getAttribute("href").endsWith("name=" + username));
    }

    private void assertTableUsername(String username, HtmlTable.Row row, String heading) {
        Node cellNode = row.getCellNodeForHeading(heading);
        Assert.assertEquals((Object)username, (Object)ViewIssuePage.getRelUsername(cellNode));
    }

    private void assertTableUsernames(List<String> usernames, HtmlTable.Row row, String heading) {
        Node cellNode = row.getCellNodeForHeading(heading);
        Assert.assertEquals(usernames, ViewIssuePage.getRelUsernames(cellNode));
    }

    private Document getDocument() throws IOException, DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(this.tester.getDialog().getResponse().getInputStream());
    }
}

