/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.user.EditUserPage;
import com.atlassian.jira.functest.framework.page.IssueSearchPage;
import com.atlassian.jira.functest.framework.page.ManageWatchersPage;
import com.atlassian.jira.functest.framework.page.ViewIssuePage;
import com.atlassian.jira.functest.framework.page.ViewVotersPage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.table.HtmlTable;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.ISSUES, Category.ISSUE_NAVIGATOR})
@LoginAs(user="admin")
public class TestUserRenameOnIssues
extends BaseJiraFuncTest {
    private static final int ISSUE_COW_2 = 10100;
    private static final int ISSUE_COW_3 = 10101;
    private static final int ISSUE_COW_4 = 10200;
    private static final int CF_CC = 10200;
    private static final int CF_TESTER = 10300;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUpTest() {
        this.administration.restoreData("user_rename.xml");
    }

    @Test
    public void testUserRenameOnIssues() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        Assert.assertEquals((Object)"Betty Boop", (Object)viewIssuePage.getAssignee());
        Assert.assertEquals((Object)"Crazy Cat", (Object)viewIssuePage.getReporter());
        Assert.assertEquals((Object)"Adam Ant, Bob Belcher", (Object)viewIssuePage.getCustomFieldValue(10200));
        Assert.assertEquals((Object)"Candy Chaos", (Object)viewIssuePage.getCustomFieldValue(10300));
        viewIssuePage = this.navigation.issue().viewIssue("COW-3");
        Assert.assertEquals((Object)"Bob Belcher", (Object)viewIssuePage.getAssignee());
        Assert.assertEquals((Object)"Candy Chaos", (Object)viewIssuePage.getReporter());
        Assert.assertEquals((Object)"Adam Ant, Betty Boop", (Object)viewIssuePage.getCustomFieldValue(10200));
        Assert.assertEquals((Object)"Crazy Cat", (Object)viewIssuePage.getCustomFieldValue(10300));
        IssueSearchPage issueSearchPage = this.navigation.issueNavigator().runSearch("");
        System.out.println("getCurrentPage() = " + this.navigation.getCurrentPage());
        HtmlTable searchResultsTable = issueSearchPage.getResultsTable();
        Assert.assertEquals((Object)"COW-3", (Object)searchResultsTable.getRow(2).getCellForHeading("Key"));
        Assert.assertEquals((Object)"Bob Belcher", (Object)searchResultsTable.getRow(2).getCellForHeading("Assignee"));
        Assert.assertEquals((Object)"Candy Chaos", (Object)searchResultsTable.getRow(2).getCellForHeading("Reporter"));
        Assert.assertEquals((Object)"Crazy Cat", (Object)searchResultsTable.getRow(2).getCellForHeading("Tester"));
        Assert.assertEquals((Object)"Adam Ant, Betty Boop", (Object)searchResultsTable.getRow(2).getCellForHeading("CC"));
        Assert.assertEquals((Object)"COW-1", (Object)searchResultsTable.getRow(4).getCellForHeading("Key"));
        Assert.assertEquals((Object)"Betty Boop", (Object)searchResultsTable.getRow(4).getCellForHeading("Assignee"));
        Assert.assertEquals((Object)"Crazy Cat", (Object)searchResultsTable.getRow(4).getCellForHeading("Reporter"));
        Assert.assertEquals((Object)"Candy Chaos", (Object)searchResultsTable.getRow(4).getCellForHeading("Tester"));
        Assert.assertEquals((Object)"Adam Ant, Bob Belcher", (Object)searchResultsTable.getRow(4).getCellForHeading("CC"));
    }

    private void doWatchAndVoteAsBetty() throws Exception {
        this.navigation.logout();
        this.navigation.login("betty");
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-3");
        Assert.assertEquals((long)0L, (long)viewIssuePage.getVoteCount());
        viewIssuePage = viewIssuePage.toggleVote();
        Assert.assertEquals((long)1L, (long)viewIssuePage.getVoteCount());
        Assert.assertEquals((Object)true, (Object)viewIssuePage.hasVoted());
        viewIssuePage = viewIssuePage.toggleVote();
        Assert.assertEquals((long)0L, (long)viewIssuePage.getVoteCount());
        Assert.assertEquals((Object)false, (Object)viewIssuePage.hasVoted());
        viewIssuePage = viewIssuePage.toggleVote();
        Assert.assertEquals((long)1L, (long)viewIssuePage.getWatcherCount());
        viewIssuePage = viewIssuePage.toggleWatch();
        Assert.assertEquals((long)2L, (long)viewIssuePage.getWatcherCount());
        Assert.assertEquals((Object)true, (Object)viewIssuePage.isWatching());
        viewIssuePage = this.navigation.issue().viewIssue("COW-2");
        Assert.assertEquals((Object)true, (Object)viewIssuePage.isWatching());
        Assert.assertEquals((long)3L, (long)viewIssuePage.getWatcherCount());
        viewIssuePage = viewIssuePage.toggleWatch();
        Assert.assertEquals((long)2L, (long)viewIssuePage.getWatcherCount());
        Assert.assertEquals((Object)false, (Object)viewIssuePage.isWatching());
        viewIssuePage.toggleVote();
    }

    private void doWatchAndVoteAsBob() throws Exception {
        this.navigation.logout();
        this.navigation.login("bb");
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-4");
        Assert.assertEquals((long)0L, (long)viewIssuePage.getVoteCount());
        viewIssuePage = viewIssuePage.toggleVote();
        Assert.assertEquals((long)1L, (long)viewIssuePage.getVoteCount());
        Assert.assertEquals((Object)true, (Object)viewIssuePage.hasVoted());
        viewIssuePage = viewIssuePage.toggleVote();
        Assert.assertEquals((long)0L, (long)viewIssuePage.getVoteCount());
        Assert.assertEquals((Object)false, (Object)viewIssuePage.hasVoted());
        viewIssuePage = viewIssuePage.toggleVote();
        Assert.assertEquals((long)1L, (long)viewIssuePage.getWatcherCount());
        viewIssuePage = viewIssuePage.toggleWatch();
        Assert.assertEquals((long)2L, (long)viewIssuePage.getWatcherCount());
        Assert.assertEquals((Object)true, (Object)viewIssuePage.isWatching());
        viewIssuePage = this.navigation.issue().viewIssue("COW-2");
        Assert.assertEquals((Object)true, (Object)viewIssuePage.isWatching());
        Assert.assertEquals((long)2L, (long)viewIssuePage.getWatcherCount());
        viewIssuePage = viewIssuePage.toggleWatch();
        Assert.assertEquals((long)1L, (long)viewIssuePage.getWatcherCount());
        Assert.assertEquals((Object)false, (Object)viewIssuePage.isWatching());
        viewIssuePage.toggleVote();
    }

    @Test
    public void testWatchersAndVoters() throws Exception {
        ManageWatchersPage manageWatchersPage = this.navigation.gotoPageWithParams(ManageWatchersPage.class, "id=10100");
        List<String> watchers = manageWatchersPage.getCurrentWatchers();
        Assert.assertEquals(Arrays.asList("Adam Ant (admin)"), watchers);
        manageWatchersPage = manageWatchersPage.addWatchers("betty");
        watchers = manageWatchersPage.getCurrentWatchers();
        Assert.assertEquals(Arrays.asList("Adam Ant (admin)", "Betty Boop (betty)"), watchers);
        manageWatchersPage = manageWatchersPage.addWatchers("bb");
        watchers = manageWatchersPage.getCurrentWatchers();
        Assert.assertEquals(Arrays.asList("Adam Ant (admin)", "Betty Boop (betty)", "Bob Belcher (bb)"), watchers);
        try {
            this.doWatchAndVoteAsBetty();
            this.doWatchAndVoteAsBob();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin");
        }
        Assert.assertEquals(Arrays.asList("Betty Boop (betty)", "Bob Belcher (bb)"), this.votersFor(10100));
        Assert.assertEquals(Arrays.asList("Betty Boop (betty)"), this.votersFor(10101));
        Assert.assertEquals(Arrays.asList("Bob Belcher (bb)"), this.votersFor(10200));
    }

    @Test
    public void testVotingOnOwnIssue() throws Exception {
        this.navigation.login("cat");
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-2");
        Assert.assertFalse((String)"Renamed user shouldn't be able to vote on its own issue", (boolean)viewIssuePage.canVote());
        viewIssuePage = this.navigation.issue().viewIssue("COW-3");
        Assert.assertTrue((String)"Renamed user should be able to vote on someone else's issue", (boolean)viewIssuePage.canVote());
        this.navigation.logout();
        this.navigation.login("cc");
        viewIssuePage = this.navigation.issue().viewIssue("COW-3");
        Assert.assertFalse((String)"Recycled user shouldn't be able to vote on its own issue", (boolean)viewIssuePage.canVote());
        viewIssuePage = this.navigation.issue().viewIssue("COW-2");
        Assert.assertTrue((String)"Recycled user should be able to vote on someone else's issue", (boolean)viewIssuePage.canVote());
    }

    @Test
    public void testRenameUser() throws Exception {
        ViewIssuePage viewIssuePage;
        try {
            this.navigation.logout();
            this.navigation.login("cc");
            viewIssuePage = this.navigation.issue().viewIssue("COW-4");
            viewIssuePage = viewIssuePage.toggleVote();
            viewIssuePage.toggleWatch();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin");
        }
        viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        Assert.assertEquals((Object)"Crazy Cat", (Object)viewIssuePage.getReporter());
        Assert.assertEquals((Object)"Candy Chaos", (Object)viewIssuePage.getCustomFieldValue(10300));
        Assert.assertEquals(Arrays.asList("Candy Chaos (cc)"), this.votersFor(10200));
        Assert.assertEquals(Arrays.asList("Adam Ant (admin)", "Candy Chaos (cc)"), this.watchersFor(10200));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cc");
        editUserPage.setUsername("candy");
        editUserPage.submitUpdate();
        Assert.assertEquals((Object)"/secure/admin/user/ViewUser.jspa?name=candy", (Object)this.navigation.getCurrentPage());
        Assert.assertEquals((Object)"candy", (Object)this.locator.id("username").getText());
        viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        Assert.assertEquals((Object)"Crazy Cat", (Object)viewIssuePage.getReporter());
        Assert.assertEquals((Object)"Candy Chaos", (Object)viewIssuePage.getCustomFieldValue(10300));
        Assert.assertEquals(Arrays.asList("Candy Chaos (candy)"), this.votersFor(10200));
        Assert.assertEquals(Arrays.asList("Adam Ant (admin)", "Candy Chaos (candy)"), this.watchersFor(10200));
    }

    @Test
    public void testRenameUserValidation() throws Exception {
        this.navigation.gotoPage("secure/admin/user/EditUser!default.jspa?editName=cc");
        this.tester.setFormElement("username", "");
        this.tester.submit("Update");
        Assert.assertEquals((Object)"You must specify a username.", (Object)this.locator.id("user-edit-username-error").getText());
        this.tester.setFormElement("username", "betty");
        this.tester.submit("Update");
        Assert.assertEquals((Object)"A user with that username already exists.", (Object)this.locator.id("user-edit-username-error").getText());
        this.tester.setFormElement("username", "i<3u");
        this.tester.submit("Update");
        Assert.assertEquals((Object)"The username must not contain '<', '>' or '&'.", (Object)this.locator.id("user-edit-username-error").getText());
        this.tester.setFormElement("username", "bet>");
        this.tester.submit("Update");
        Assert.assertEquals((Object)"The username must not contain '<', '>' or '&'.", (Object)this.locator.id("user-edit-username-error").getText());
        this.tester.setFormElement("username", "yes&no");
        this.tester.submit("Update");
        Assert.assertEquals((Object)"The username must not contain '<', '>' or '&'.", (Object)this.locator.id("user-edit-username-error").getText());
    }

    private List<String> watchersFor(int issueId) {
        return this.navigation.gotoPageWithParams(ManageWatchersPage.class, "id=" + issueId).getCurrentWatchers();
    }

    private List<String> votersFor(int issueId) {
        return this.navigation.gotoPageWithParams(ViewVotersPage.class, "id=" + issueId).getCurrentVoters();
    }
}

