/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.PROJECTS})
@LoginAs(user="admin")
public class TestUserRenameOnProjectRoles
extends BaseJiraFuncTest {
    private static final String USERS_ROLE_ID = "10000";
    private static final String DEVELOPERS_ROLE_ID = "10001";
    private static final String ADMINISTRATORS_ROLE_ID = "10002";
    private static final String BATMAN_ROLE_ID = "10100";
    private static final String EDIT_ROLES_FOR_USER_URL = "secure/admin/user/EditUserProjectRoles!default.jspa?name=%s";
    private static final String VIEW_ROLES_FOR_USER_URL = "secure/admin/user/ViewUserProjectRoles!default.jspa?name=%s";
    private static final String ROLE_CHECKBOX_ID = "10000_%s";
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("user_rename_project_roles.xml");
    }

    @Test
    public void testJqlFunctionsFindRenamedProjectRoleMembers() {
        this.makeUserBatman("bw");
        this.renameUser("bw", "thedarkknight");
        this.renameUser("bruce", "bw");
        this.navigation.login("bw", "bruce");
        this.tester.gotoPage("rest/api/2/search?jql=project%20in%20projectsWhereUserHasRole(\"Batman\")");
        this.tester.assertTextPresent("\"total\":0");
        this.navigation.login("thedarkknight", "bw");
        this.tester.gotoPage("rest/api/2/search?jql=project%20in%20projectsWhereUserHasRole(\"Batman\")");
        this.tester.assertTextPresent("\"total\":1");
    }

    @Test
    public void testRenamedUserRetainsProjectRoles() {
        this.makeUserBatman("bw");
        this.assertUserIsBatmanEverywhere("bw", "Batman Wayne", true);
        this.renameUser("bw", "thedarkknight");
        this.assertUserIsBatmanEverywhere("thedarkknight", "Batman Wayne", true);
        this.retireUserFromBatmanRole("thedarkknight");
        this.assertUserIsBatmanEverywhere("thedarkknight", "Batman Wayne", false);
        this.renameUser("bruce", "bw");
        this.makeUserBatman("bw");
        this.assertUserIsBatmanEverywhere("bw", "Bruce Wayne", true);
    }

    @Test
    public void testRenamedUserRetainsGroupMembership() {
        this.administration.usersAndGroups().addGroup("super-heroes");
        this.administration.usersAndGroups().addUserToGroup("bw", "super-heroes");
        this.backdoor.projectRole().addActors("COW", "Batman", new String[]{"super-heroes"}, null);
        this.navigation.gotoPage(String.format(VIEW_ROLES_FOR_USER_URL, "bw"));
        this.tester.assertElementPresent("10000_10100_group");
        Assert.assertTrue((boolean)this.backdoor.usersAndGroups().isUserInGroup("bw", "super-heroes"));
        this.renameUser("bw", "thedarkknight");
        this.navigation.gotoPage(String.format(VIEW_ROLES_FOR_USER_URL, "thedarkknight"));
        this.tester.assertElementPresent("10000_10100_group");
        Assert.assertTrue((boolean)this.backdoor.usersAndGroups().isUserInGroup("thedarkknight", "super-heroes"));
        this.renameUser("bruce", "bw");
        this.navigation.gotoPage(String.format(VIEW_ROLES_FOR_USER_URL, "bw"));
        this.tester.assertElementNotPresent("10000_10100_group");
        Assert.assertFalse((boolean)this.backdoor.usersAndGroups().isUserInGroup("bw", "super-heroes"));
    }

    @Test
    public void testRenamedUserRemainsDefaultRoleUser() {
        this.navigation.gotoPage(String.format("secure/project/UserRoleActorAction.jspa?projectRoleId=%s", BATMAN_ROLE_ID));
        this.tester.setFormElement("userNames", "bw");
        this.tester.submit("add");
        this.textAssertions.assertTextPresent(this.locator.id("watcher_link_bw"), "Batman Wayne");
        this.renameUser("bw", "thedarkknight");
        this.navigation.gotoPage(String.format("secure/project/UserRoleActorAction.jspa?projectRoleId=%s", BATMAN_ROLE_ID));
        this.textAssertions.assertTextPresent(this.locator.id("watcher_link_thedarkknight"), "Batman Wayne");
        this.tester.assertElementNotPresent("watcher_linke_bw");
    }

    private void makeUserBatman(String userName) {
        this.navigation.gotoPage(String.format(EDIT_ROLES_FOR_USER_URL, userName));
        this.tester.checkCheckbox(String.format(ROLE_CHECKBOX_ID, BATMAN_ROLE_ID));
        this.tester.submit("Save");
    }

    private void retireUserFromBatmanRole(String userName) {
        this.navigation.gotoPage(String.format(EDIT_ROLES_FOR_USER_URL, userName));
        this.tester.uncheckCheckbox(String.format(ROLE_CHECKBOX_ID, BATMAN_ROLE_ID));
        this.tester.submit("Save");
    }

    private void assertUserIsBatmanEverywhere(String userName, String expectedDisplayName, boolean shouldBeBatman) {
        this.navigation.gotoPage(String.format(EDIT_ROLES_FOR_USER_URL, userName));
        if (shouldBeBatman) {
            this.tester.assertCheckboxSelected(String.format(ROLE_CHECKBOX_ID, BATMAN_ROLE_ID));
        } else {
            this.tester.assertCheckboxNotSelected(String.format(ROLE_CHECKBOX_ID, BATMAN_ROLE_ID));
        }
        this.navigation.gotoPage(String.format(VIEW_ROLES_FOR_USER_URL, userName));
        if (shouldBeBatman) {
            Assert.assertTrue((String)"Role not shown on view roles page", (boolean)this.locator.id("10000_10100_direct").exists());
        } else {
            Assert.assertTrue((String)"Role wrongly shown on view roles page", (boolean)this.locator.id("10000_10100_none").exists());
        }
        List<ProjectRole.Actor> restBatmen = this.getBatmenViaREST();
        if (shouldBeBatman) {
            Assert.assertEquals((Object)expectedDisplayName, (Object)restBatmen.get((int)0).displayName);
        } else {
            Assert.assertEquals((long)restBatmen.size(), (long)0L);
        }
    }

    private List<ProjectRole.Actor> getBatmenViaREST() {
        return this.backdoor.projectRole().get((String)"COW", (String)"Batman").actors;
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }
}

