/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.WorkflowSchemes;
import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebResponse;
import java.util.Map;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
@Restore(value="TestDraftWorkflow.xml")
public class TestDraftWorkflow
extends BaseJiraFuncTest {
    @Inject
    private WorkflowSchemes workflowSchemes;
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    @After
    public void tearDown() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    @Test
    @Restore(value="TestDraftWorkflowFunnyNames.xml")
    public void testPublishDraftWorkflowWithFunnyNames() {
        this.administration.workflows().goTo().createDraft("Funny&Name").add("In Progress", "In Progress");
        Assert.assertTrue((boolean)this.administration.workflows().goTo().active().drafts().contains("Funny&Name"));
        this.administration.workflows().view("Funny&Name");
        this.tester.assertTextNotPresent("In Progress");
        this.administration.workflows().goTo().workflowSteps("Funny&Name");
        this.tester.assertTextPresent("In Progress");
        this.administration.workflows().goTo().publishDraft("Funny&Name").cancel();
        Assert.assertTrue((boolean)this.administration.workflows().active().drafts().contains("Funny&Name"));
        this.administration.workflows().goTo().publishDraft("Funny&Name").backupOriginalWorkflowAs("overwritten workflowDude").publish();
        this.administration.workflows().goTo();
        Assert.assertFalse((boolean)this.administration.workflows().active().drafts().contains("Funny&Name"));
        Assert.assertTrue((boolean)this.administration.workflows().inactive().contains("overwritten workflowDude"));
        this.tester.clickLink("steps_live_Funny&Name");
        this.tester.assertTextPresent("In Progress");
        this.administration.workflows().goTo().edit("overwritten workflowDude").textView().goTo();
        this.tester.assertTextNotInTable("steps_table", "In Progress");
    }

    @Test
    public void testPublishDraftWorkflow() {
        this.administration.workflows().goTo().createDraft("Workflow1").add("In Progress", "In Progress");
        Assert.assertTrue((boolean)this.administration.workflows().goTo().active().drafts().contains("Workflow1"));
        this.administration.workflows().view("Workflow1");
        this.tester.assertTextNotPresent("In Progress");
        this.administration.workflows().goTo().workflowSteps("Workflow1");
        this.tester.assertTextPresent("In Progress");
        this.administration.workflows().goTo().publishDraft("Workflow1").cancel();
        Assert.assertTrue((boolean)this.administration.workflows().active().drafts().contains("Workflow1"));
        this.administration.workflows().goTo().publishDraft("Workflow1").backupOriginalWorkflowAs("overwritten workflowDude").publish();
        this.administration.workflows().goTo();
        Assert.assertFalse((boolean)this.administration.workflows().active().drafts().contains("Workflow1"));
        Assert.assertTrue((boolean)this.administration.workflows().inactive().contains("overwritten workflowDude"));
        this.tester.clickLink("steps_live_Workflow1");
        this.tester.assertTextPresent("In Progress");
        this.administration.workflows().goTo().edit("overwritten workflowDude").textView().goTo();
        this.tester.assertTextNotInTable("steps_table", "In Progress");
    }

    @Test
    public void testPublishDraftWithoutBackup() {
        this.administration.workflows().goTo().createDraft("Workflow1").add("In Progress", "In Progress");
        Assert.assertTrue((boolean)this.administration.workflows().goTo().active().drafts().contains("Workflow1"));
        this.administration.workflows().goTo().publishDraft("Workflow1").publish();
        this.administration.workflows().goTo();
        Assert.assertFalse((boolean)this.administration.workflows().active().drafts().contains("Workflow1"));
        Assert.assertFalse((boolean)this.administration.workflows().inactive().contains("Copy of Workflow1"));
    }

    @Test
    public void testHideDeleteLink() {
        this.administration.workflows().goTo();
        this.administration.workflows().createDraft("Workflow1");
        this.tester.assertLinkNotPresent("delete_step_1");
        this.navigation.clickLinkWithExactText("Open");
        this.tester.assertLinkNotPresent("del_step");
        this.administration.workflows().goTo().workflowSteps("Workflow1").add("ClosedStep", "Closed");
        this.tester.assertTextInTable("steps_table", "ClosedStep");
        this.tester.assertLinkPresent("delete_step_2");
        this.tester.clickLinkWithText("ClosedStep");
        this.tester.assertLinkPresent("del_step");
        this.administration.workflows().goTo().workflowSteps("Workflow1");
        this.tester.clickLink("delete_step_2");
        this.tester.assertTextPresent("Delete Workflow Step: ClosedStep");
        this.tester.submit("Delete");
        this.tester.assertTextNotInTable("steps_table", "ClosedStep");
    }

    @Test
    public void testEditStatusDisabled() {
        this.administration.workflows().goTo();
        this.administration.workflows().createDraft("Workflow1");
        this.tester.assertTextInTable("steps_table", "Open");
        this.tester.assertTextNotInTable("steps_table", "EditedStep");
        this.tester.clickLink("edit_step_1");
        this.assertions.assertNodeExists(new CssLocator(this.tester, "select[name=stepStatus][disabled]"));
        this.tester.setFormElement("stepName", "EditedStep");
        this.tester.submit("Update");
        this.tester.assertTextInTable("steps_table", "EditedStep");
        this.tester.setFormElement("stepName", "ClosedStep");
        this.tester.selectOption("stepStatus", "Closed");
        this.tester.submit("Add");
        this.tester.assertTextNotInTable("steps_table", "Reopened");
        this.tester.assertTextNotInTable("steps_table", "ClosedStepEdit");
        this.tester.clickLink("edit_step_2");
        this.assertions.assertNodeDoesNotExist(new CssLocator(this.tester, "select[name=stepStatus][disabled]"));
        this.tester.setFormElement("stepName", "ClosedStepEdit");
        this.tester.selectOption("stepStatus", "Reopened");
        this.tester.submit("Update");
        this.tester.assertTextInTable("steps_table", "Reopened");
        this.tester.assertTextInTable("steps_table", "ClosedStepEdit");
    }

    @Test
    public void testEditValidation() {
        this.administration.workflows().goTo().createDraft("Workflow1");
        this.tester.gotoPage(this.page.addXsrfToken("secure/admin/workflows/EditWorkflowStep.jspa?workflowMode=draft&workflowName=Workflow1&workflowStep=1&stepStatus=Closed&stepName=sweet"));
        this.tester.assertTextPresent("Cannot change the status of an existing step on a draft workflow");
    }

    @Test
    public void testDeleteDraftValidation() {
        this.administration.workflows().goTo().createDraft("Workflow1");
        this.tester.gotoPage("secure/admin/workflows/DeleteWorkflowStep!default.jspa?workflowMode=draft&workflowName=Workflow1&workflowStep=1");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Cannot delete an existing step on a draft workflow.");
    }

    @Test
    public void testDeleteValidation() {
        this.administration.workflows().goTo();
        this.tester.gotoPage("secure/admin/workflows/DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow1&workflowStep=1");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Cannot delete step. This workflow is not editable.");
    }

    @Test
    public void testWorkflowDraftName() {
        this.administration.workflows().goTo().createDraft("Workflow1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Workflow1", "Draft"});
        this.tester.setFormElement("stepName", "Dude");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("Add Transition");
        this.tester.setFormElement("transitionName", "testTransition");
        this.tester.submit("Add");
        this.navigation.clickLinkWithExactText("Open");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Workflows", "Workflow1 (Draft)", "Step: Open"});
        this.tester.clickLinkWithText("testTransition");
        this.tester.assertTextPresent("Transition: testTransition");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Workflows", "Workflow1 (Draft)", "Transition: testTransition"});
        this.navigation.clickLinkWithExactText("Open");
        this.tester.clickLink("view_properties_1");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"View", "workflow steps", "of", "Workflow1 (Draft)"});
        this.tester.clickLink("workflows");
        this.tester.clickLink("steps_live_Workflow1");
        this.tester.assertTextNotPresent("(Draft)");
        this.navigation.clickLinkWithExactText("Open");
        this.tester.assertTextNotPresent("(Draft)");
        this.tester.clickLink("view_properties_1");
        this.tester.assertTextNotPresent("(Draft)");
        this.tester.clickLinkWithText("workflow steps");
        this.navigation.clickLinkWithExactText("Open");
        this.tester.clickLink("view_transition_1");
        this.tester.assertTextNotPresent("(Draft)");
    }

    @Test
    public void testDeleteLinkNotShownForInitialTransition() {
        this.administration.workflows().goTo();
        this.administration.workflows().goTo().copyWorkflow("jira", "Copy of jira");
        this.administration.workflows().goTo().edit("Copy of jira").textView().goTo();
        this.navigation.clickLinkWithExactText("Open");
        this.tester.clickLinkWithText("Start Progress");
        this.tester.assertTextPresent("Transition: Start Progress");
        this.tester.assertLinkPresent("delete_transition");
        this.navigation.clickLinkWithExactText("Open");
        this.tester.clickLink("view_transition_1");
        this.tester.assertTextPresent("Transition: Create Issue");
        this.tester.assertLinkNotPresent("delete_transition");
    }

    @Test
    public void testAddTransitionForStepWithNoTransitions() {
        this.administration.workflows().goTo().createDraft("Workflow1");
        this.tester.assertLinkPresentWithText("Add Transition");
        this.tester.setFormElement("stepName", "Dude");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("Add Transition");
        this.tester.setFormElement("transitionName", "New Transition");
        this.tester.submit("Add");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Edit Workflow", "Workflow1"});
        this.tester.assertTextPresent("New Transition");
    }

    @Test
    @Restore(value="TestOverwriteInvalidWorkflow.xml")
    public void testOverWriteWorkflowWithNewTransitionFromStatusWithoutOutgoingTransitions() {
        this.administration.workflows().goTo().publishDraft("Workflow1").publish();
        this.assertions.getURLAssertions().assertCurrentURLEndsWith("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Workflow1");
        this.tester.assertLinkPresent("draft-workflow-trigger");
        this.tester.assertLinkPresentWithText("Edit");
    }

    @Test
    public void testCreateAndDeleteDraftWorkflow() {
        this.administration.workflows().goTo().createDraft("Workflow1");
        this.administration.workflows().goTo();
        Assert.assertTrue((boolean)this.administration.workflows().active().contains("Workflow1"));
        Assert.assertTrue((boolean)this.administration.workflows().active().drafts().contains("Workflow1"));
        this.administration.workflows().goTo().edit("Workflow1");
        this.tester.clickLinkWithText("Discard");
        this.tester.assertTextPresent("Discard Draft Workflow");
        this.tester.assertTextPresent("Confirm that you want to discard the draft workflow <strong>Workflow1</strong>.");
        this.tester.submit("Delete");
        this.administration.workflows().goTo();
        Assert.assertTrue((boolean)this.administration.workflows().active().contains("Workflow1"));
        Assert.assertFalse((boolean)this.administration.workflows().active().drafts().contains("Workflow1"));
    }

    @Test
    public void testWorkflowCachingHeaders() {
        this.administration.workflows().goTo();
        this.tester.clickLink("steps_live_jira");
        this.tester.clickLink("xml_jira");
        WebResponse response = this.tester.getDialog().getResponse();
        Assert.assertEquals((Object)"", (Object)response.getHeaderField("Pragma"));
        String cacheControl = response.getHeaderField("Cache-Control");
        Assert.assertTrue((boolean)cacheControl.contains("private"));
        Assert.assertTrue((boolean)cacheControl.contains("must-revalidate"));
        Assert.assertTrue((boolean)cacheControl.contains("max-age"));
        this.assertions.getRequestAssertions().assertResponseCanBeCached();
    }

    @Test
    @Restore(value="TestDeactivateDraftWorkflowEnterprise.xml")
    public void testDeactivateDraftWorkflow() {
        this.administration.workflows().goTo();
        Assert.assertTrue((boolean)this.administration.workflows().active().contains("Workflow1"));
        Assert.assertTrue((boolean)this.administration.workflows().active().drafts().contains("Workflow1"));
        Assert.assertTrue((boolean)Iterables.all((Iterable)Iterables.filter((Iterable)((Object)this.administration.workflows().active()), ViewWorkflows.WorkflowItemsList.Predicates.byName("Workflow1")), ViewWorkflows.WorkflowItemsList.Predicates.schemesEqual((Iterable<String>)ImmutableMultiset.of((Object)"WorkflowScheme_Workflow1", (Object)"A second scheme"))));
        Assert.assertTrue((boolean)this.administration.workflows().active().contains("Workflow3"));
        Assert.assertTrue((boolean)this.administration.workflows().active().drafts().contains("Workflow3"));
        Assert.assertTrue((boolean)Iterables.all((Iterable)Iterables.filter((Iterable)((Object)this.administration.workflows().active()), ViewWorkflows.WorkflowItemsList.Predicates.byName("Workflow3")), ViewWorkflows.WorkflowItemsList.Predicates.schemesEqual((Iterable<String>)ImmutableMultiset.of((Object)"A second scheme"))));
        this.administration.workflows().goTo().view("Workflow1");
        this.tester.assertTextNotPresent("NewDraftStep");
        this.administration.workflows().goTo().workflowSteps("Workflow1");
        this.tester.assertTextPresent("NewDraftStep");
        this.administration.workflows().goTo().view("Workflow3");
        this.tester.assertTextNotPresent("AnotherNewDraftStep");
        this.administration.workflows().goTo().workflowSteps("Workflow3");
        this.tester.assertTextPresent("AnotherNewDraftStep");
        this.administration.project().associateWorkflowScheme("monkey", "Default");
        this.administration.workflows().goTo();
        Assert.assertEquals((long)Iterables.size((Iterable)Iterables.filter((Iterable)((Object)this.administration.workflows().inactive()), ViewWorkflows.WorkflowItemsList.Predicates.byName("Copy of Workflow3"))), (long)1L);
        Assert.assertTrue((boolean)Iterables.all((Iterable)Iterables.filter((Iterable)((Object)this.administration.workflows().inactive()), ViewWorkflows.WorkflowItemsList.Predicates.byName("Copy of Workflow3")), (Predicate)Predicates.and(ViewWorkflows.WorkflowItemsList.Predicates.byDescription("(This copy was automatically generated from a draft, when workflow 'Workflow3' was made inactive.)"), ViewWorkflows.WorkflowItemsList.Predicates.schemesEqual((Iterable<String>)ImmutableMultiset.of()))));
        this.administration.workflows().workflowSteps("Copy of Workflow3");
        this.tester.assertTextPresent("AnotherNewDraftStep");
        this.administration.workflows().goTo();
        Assert.assertTrue((boolean)this.administration.workflows().inactive().contains("Workflow3"));
        Assert.assertTrue((boolean)Iterables.all((Iterable)Iterables.filter((Iterable)((Object)this.administration.workflows().active()), ViewWorkflows.WorkflowItemsList.Predicates.byName("Workflow3")), ViewWorkflows.WorkflowItemsList.Predicates.schemesEqual((Iterable<String>)ImmutableMultiset.of((Object)"A second scheme"))));
        this.administration.workflows().workflowSteps("Workflow3");
        this.tester.assertTextNotPresent("AnotherNewDraftStep");
        this.administration.project().associateWorkflowScheme("homosapien", "Default", (Map<String, String>)ImmutableMap.of(), true);
        this.workflowSchemes.waitForSuccessfulWorkflowSchemeMigration("homosapien", "Default");
        this.administration.workflows().goTo();
        Assert.assertEquals((long)Iterables.size((Iterable)Iterables.filter((Iterable)((Object)this.administration.workflows().inactive()), ViewWorkflows.WorkflowItemsList.Predicates.byName("Copy of Workflow1"))), (long)1L);
        Assert.assertTrue((boolean)Iterables.all((Iterable)Iterables.filter((Iterable)((Object)this.administration.workflows().inactive()), ViewWorkflows.WorkflowItemsList.Predicates.byName("Copy of Workflow1")), (Predicate)Predicates.and(ViewWorkflows.WorkflowItemsList.Predicates.byDescription("(This copy was automatically generated from a draft, when workflow 'Workflow1' was made inactive.)"), ViewWorkflows.WorkflowItemsList.Predicates.schemesEqual((Iterable<String>)ImmutableMultiset.of()))));
        this.administration.workflows().workflowSteps("Copy of Workflow1");
        this.tester.assertTextPresent("NewDraftStep");
        this.administration.workflows().goTo();
        Assert.assertTrue((boolean)this.administration.workflows().inactive().contains("Workflow1"));
        Assert.assertTrue((boolean)Iterables.all((Iterable)Iterables.filter((Iterable)((Object)this.administration.workflows().active()), ViewWorkflows.WorkflowItemsList.Predicates.byName("Workflow1")), ViewWorkflows.WorkflowItemsList.Predicates.schemesEqual((Iterable<String>)ImmutableMultiset.of((Object)"WorkflowScheme_Workflow1", (Object)"A second scheme"))));
        this.administration.workflows().workflowSteps("Workflow1");
        this.tester.assertTextNotPresent("NewDraftStep");
    }
}

