/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.backdoor.ProjectControlExt;
import com.atlassian.jira.functest.framework.backdoor.WorkflowsControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.WorkflowSchemesControl;
import com.atlassian.jira.webtests.ztests.workflow.AbstractTestDraftWorkflowSchemeMigration;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
@LoginAs(user="admin")
public class TestDraftWorkflowSchemeMigration
extends AbstractTestDraftWorkflowSchemeMigration {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @Restore(value="blankWithOldDefault.xml")
    public void testDrafWorkflowRemovedWhenInactive() {
        String workflowName = "WorkflowWithDraft";
        WorkflowsControlExt workflowControl = this.getBackdoor().workflow();
        workflowControl.createWorkflow("WorkflowWithDraft");
        WorkflowSchemesControl workflowSchemesControl = this.getBackdoor().workflowSchemes();
        WorkflowSchemeData scheme = workflowSchemesControl.createScheme(new WorkflowSchemeData().setName("WorkflowWithDraft").setMapping("Bug", "WorkflowWithDraft"));
        String projectKey = "TDWC";
        String projectName = "testDrafWorkflowChanged";
        ProjectControlExt projectControl = this.getBackdoor().project();
        projectControl.addProject("testDrafWorkflowChanged", "TDWC", "admin");
        projectControl.setWorkflowScheme("TDWC", scheme.getId());
        workflowControl.createDraftOfWorkflow("WorkflowWithDraft");
        workflowSchemesControl.createDraft(scheme);
        workflowSchemesControl.updateDraftScheme(scheme.getId().longValue(), new WorkflowSchemeData().setMapping("Bug", "jira"));
        Long schemeId = this.getBackdoor().workflowSchemes().getWorkflowSchemeByProjectKey("TDWC").getId();
        this.administration.project().publishWorkflowSchemeDraft("testDrafWorkflowChanged", schemeId, Collections.emptyMap(), true);
        WorkflowsControlExt.Workflow workflow = workflowControl.getWorkflowDetailed("WorkflowWithDraft");
        Assert.assertFalse((String)"Workflow should no longer have a draft.", (boolean)workflow.isHasDraft());
        workflow = workflowControl.getWorkflowDetailed("Copy of WorkflowWithDraft");
        Assert.assertNotNull((String)"Workflow draft has been made its own scheme?", (Object)workflow);
        Assert.assertEquals((String)"Description should be valid.", (Object)String.format("(This copy was automatically generated from a draft, when workflow '%s' was made inactive.)", "WorkflowWithDraft"), (Object)workflow.getDescription());
    }

    @Test
    @Restore(value="blankWithOldDefault.xml")
    public void testDrafWorkflowRemovedWhenInactiveWithIssues() {
        String workflowName = "WorkflowWithDraft";
        WorkflowsControlExt workflowControl = this.getBackdoor().workflow();
        workflowControl.createWorkflow("WorkflowWithDraft");
        WorkflowSchemesControl workflowSchemesControl = this.getBackdoor().workflowSchemes();
        WorkflowSchemeData scheme = workflowSchemesControl.createScheme(new WorkflowSchemeData().setName("WorkflowWithDraft").setMapping("Bug", "WorkflowWithDraft"));
        String projectKey = "TDWC";
        String projectName = "testDrafWorkflowChanged";
        ProjectControlExt projectControl = this.getBackdoor().project();
        projectControl.addProject("testDrafWorkflowChanged", "TDWC", "admin");
        projectControl.setWorkflowScheme("TDWC", scheme.getId());
        this.getBackdoor().issues().createIssue("TDWC", "some issue");
        workflowControl.createDraftOfWorkflow("WorkflowWithDraft");
        workflowSchemesControl.createDraft(scheme);
        workflowSchemesControl.updateDraftScheme(scheme.getId().longValue(), new WorkflowSchemeData().setMapping("Bug", "jira"));
        Long schemeId = this.getBackdoor().workflowSchemes().getWorkflowSchemeByProjectKey("TDWC").getId();
        this.administration.project().publishWorkflowSchemeDraft("testDrafWorkflowChanged", schemeId, Collections.emptyMap(), true);
        WorkflowsControlExt.Workflow workflow = workflowControl.getWorkflowDetailed("WorkflowWithDraft");
        Assert.assertFalse((String)"Workflow should no longer have a draft.", (boolean)workflow.isHasDraft());
        workflow = workflowControl.getWorkflowDetailed("Copy of WorkflowWithDraft");
        Assert.assertNotNull((String)"Workflow draft has been made its own scheme?", (Object)workflow);
        Assert.assertEquals((String)"Description should be valid.", (Object)String.format("(This copy was automatically generated from a draft, when workflow '%s' was made inactive.)", "WorkflowWithDraft"), (Object)workflow.getDescription());
    }

    @Test
    @Restore(value="WorkflowSchemePublishingMigrationTest.xml")
    public void testWorkflowMigration() {
        this.publishDraft();
        this.assertStandardIssues("TST");
        this.assertSchemeAndNoDraft("Test Project");
    }

    @Test
    @Restore(value="WorkflowMigrationTestBrokenHalfWayDraft.xml")
    public void testWorkflowMigrationHalfMigratedData() {
        this.publishDraft();
        this.assertIssuesMigratedAndChangeHistory("TST");
        this.assertSchemeAndNoDraft("Test Project");
    }

    @Test
    @Restore(value="WorkflowMigrationTestIssueWithUnupdatedIssueDraft.xml")
    public void testWorkflowMigrationWithUnupdatedIssue() {
        this.publishDraft();
        this.assertIssuesMigratedAndChangeHistory("TST");
        this.assertSchemeAndNoDraft("Test Project");
    }

    @Test
    @Restore(value="WorkflowMigrationTestUnchangedSchemeDraft.xml")
    public void testWorkflowMigrationWithUnupdatedWorkflowScheme() {
        this.publishDraft();
        this.assertIssuesAfterMigrationWithUnupdatedWorkflowScheme();
        this.assertSchemeAndNoDraft("Test Project");
    }

    @Test
    @Restore(value="WorkflowMigrationHalfMigratedDataNewDestinationDraft.xml")
    public void testWorkflowMigrationHalfMigratedDataNewDestination() throws SAXException {
        this.tester.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep2!default.jspa?draftMigration=true&projectId=10010&schemeId=10000");
        this.tester.assertTextPresent("Step 1 of 2");
        this.tester.assertTextPresent("The current status of each issue needs to be changed so that it is compatible with the new workflows.");
        this.textAssertions.assertTextPresent(this.locator.css("title"), "Publish Workflows");
        this.textAssertions.assertTextPresent(this.locator.css("header h2"), "Publish Workflows");
        this.tester.assertTextPresent("Affected issues: 4 of 8");
        this.tester.assertTextPresent("Affected issues: 8 of 16");
        this.tester.assertTextPresent("Affected issues: 2 of 8");
        this.assertMappingAndSelectOptionsForHalfMigratedDataNewDestination();
        this.tester.submit("Associate");
        this.administration.project().waitForWorkflowMigration(1000L, 100);
        this.assertIssuesInHomosapienProjectAfterHalfMigratedDataNewDestination();
        this.checkIssuesInTestProjectAfterHalfMigratedDataNewDestination();
        this.assertScheme("homosapien", "Homosapien Source Scheme", "The original workflow scheme of the Homosapien project", (Map<String, String>)ImmutableMap.of((Object)"Custom Issue Type", (Object)"Homosapien Custom Issue Type Destination", (Object)"Improvement", (Object)"jira"), "Homospien Destination");
        this.assertNoDraft("homosapien");
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=711000)
    @Restore(value="WorkflowMigrationTestIssueVerifierDraft.xml")
    public void testIssueVerifierError() {
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.waitForFailedMigration();
        this.assertIssueVerifierErrorMessages("TST");
        this.assertDraft("Test Project");
        this.assertScheme("Test Project", "Source Workflow Scheme", "The workflow scheme the project started on", SOURCE_SCHEME_WORKFLOW_MAPPING, "Source Workflow 1");
    }

    @Test
    @Restore(value="WorkflowMigrationTwoAdminsDraft.xml")
    public void testMultiAdminTaskProgressFlow() {
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, false);
        this.assertMultiAdminTaskProgressFlow(10000L);
    }
}

