/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.util.Objects;
import javax.annotation.Nullable;

public class SearchQuery {
    private Query query;
    @Nullable
    private ApplicationUser user;
    private boolean overrideSecurity;
    private org.apache.lucene.search.Query luceneQuery;

    private SearchQuery(Query query, ApplicationUser user) {
        this.query = query;
        this.user = user;
    }

    public static SearchQuery create(Query query, ApplicationUser searcher) {
        return new SearchQuery(query, searcher);
    }

    public SearchQuery overrideSecurity(boolean overrideSecurity) {
        this.overrideSecurity = overrideSecurity;
        return this;
    }

    public SearchQuery luceneQuery(org.apache.lucene.search.Query luceneQuery) {
        this.luceneQuery = luceneQuery;
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public org.apache.lucene.search.Query getLuceneQuery() {
        return this.luceneQuery;
    }

    @Nullable
    public ApplicationUser getUser() {
        return this.user;
    }

    public boolean isOverrideSecurity() {
        return this.overrideSecurity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchQuery that = (SearchQuery)o;
        return Objects.equals(this.getQuery(), that.getQuery()) && Objects.equals(this.getUser(), that.getUser()) && this.isOverrideSecurity() == that.isOverrideSecurity() && Objects.equals(this.getLuceneQuery(), that.getLuceneQuery());
    }

    public int hashCode() {
        return Objects.hash(this.getQuery(), this.getUser(), this.isOverrideSecurity(), this.getLuceneQuery());
    }
}

