/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import com.atlassian.jira.issue.search.parameters.lucene.sort.MatchHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultMatchHandler
implements MatchHandler {
    private static final List<String> NULL_SINGLETON = Collections.singletonList(null);
    private final List<String>[] docToTerms;
    private Object previousTermValue = null;
    private List<String> currentSingleton = NULL_SINGLETON;

    public DefaultMatchHandler(int maxdoc) {
        this.docToTerms = new List[maxdoc];
    }

    @Override
    public void handleMatchedDocument(int doc, String termValue) {
        List<String> currentValue;
        if (this.previousTermValue != termValue) {
            this.previousTermValue = termValue;
            this.currentSingleton = Collections.singletonList(termValue);
        }
        if ((currentValue = this.docToTerms[doc]) == null) {
            this.docToTerms[doc] = this.currentSingleton;
        } else if (currentValue.size() == 1) {
            String previousTermValue = currentValue.get(0);
            currentValue = new ArrayList<String>(2);
            currentValue.add(previousTermValue);
            currentValue.add(termValue);
            this.docToTerms[doc] = currentValue;
        } else {
            currentValue.add(termValue);
        }
    }

    public List<String>[] getResults() {
        return this.docToTerms;
    }
}

