/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.core.bean.MathBean;
import com.atlassian.jira.web.bean.StatisticMap;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticMapWrapper<K, N extends Number>
extends AbstractMap<K, N>
implements StatisticMap<K, N> {
    private static final Logger log = LoggerFactory.getLogger(StatisticMapWrapper.class);
    private final long totalcount;
    private long largestPercentage = -1L;
    private Map<K, N> statistics;
    private Map<K, Long> percentages;
    private final long irrelevantCount;

    public StatisticMapWrapper(Map<K, N> statistics, long totalCount, long irrelevantCount) {
        this.totalcount = totalCount;
        this.irrelevantCount = irrelevantCount;
        this.setStatistics(statistics);
    }

    @Override
    public Map<K, N> getStatistics() {
        return this.statistics;
    }

    protected Map<K, Long> getPercentages() {
        if (this.percentages == null) {
            this.percentages = new HashMap<K, Long>();
            for (Object o : this.keySet()) {
                long value = ((Number)this.get(o)).longValue();
                long percentage = new MathBean().getPercentage(value, this.getTotalCount());
                this.percentages.put(o, percentage);
            }
        }
        return this.percentages;
    }

    @Override
    public int getIrrelevantPercentage() {
        return (int)new MathBean().getPercentage(this.irrelevantCount, this.getTotalCount());
    }

    @Override
    public void setStatistics(Map<K, N> statistics) {
        this.statistics = statistics;
    }

    @Override
    public Set<Map.Entry<K, N>> entrySet() {
        return this.statistics.entrySet();
    }

    @Override
    public long getTotalCount() {
        return this.totalcount;
    }

    @Override
    public int getIrrelevantCount() {
        return (int)this.irrelevantCount;
    }

    @Override
    public long getLargestPercentage() {
        if (this.largestPercentage == -1L) {
            for (Long o : this.getPercentages().values()) {
                long currentValue = this.longValue(o);
                if (this.largestPercentage >= currentValue) continue;
                this.largestPercentage = currentValue;
            }
        }
        return this.largestPercentage;
    }

    @Override
    public int getPercentage(K key) {
        try {
            return this.getPercentages().get(key).intValue();
        }
        catch (Exception e) {
            log.error("Error getting stats for key=" + key + ": " + e, (Throwable)e);
            return 0;
        }
    }

    @Override
    public long getNullKeyValue() {
        boolean nullValueFound = false;
        long value = -1L;
        for (Object o : this.keySet()) {
            if (o != null) continue;
            if (nullValueFound) {
                log.error("StatisticMap - contains multiple mappings with a null key");
                return -1L;
            }
            value = ((Number)this.get(o)).longValue();
            nullValueFound = true;
        }
        return value;
    }

    private long longValue(Number value) {
        return value.longValue();
    }
}

