/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import java.nio.charset.Charset;
import java.util.Arrays;

public class JiraBytesRef {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final byte[] bytes;
    private final int offset;
    private final int length;

    public JiraBytesRef(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public JiraBytesRef(String characters) {
        this.bytes = characters.getBytes(UTF8_CHARSET);
        this.offset = 0;
        this.length = this.bytes.length;
    }

    public String utf8ToString() {
        return new String(this.bytes, this.offset, this.length, UTF8_CHARSET);
    }

    public byte[] getBytes() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    public int hashCode() {
        int result = 0;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            result = result * 31 + this.bytes[i];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JiraBytesRef)) {
            return false;
        }
        JiraBytesRef other = (JiraBytesRef)obj;
        if (other.length != this.length) {
            return false;
        }
        if (this.length == 0) {
            return true;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[this.offset + i] == other.bytes[other.offset + i]) continue;
            return false;
        }
        return true;
    }
}

