/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.parameters.lucene.JiraBytesRef;
import com.atlassian.jira.issue.statistics.util.AbstractOneDimensionalHitCollector;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

@Internal
public class OneDimensionalTermHitCollector
extends AbstractOneDimensionalHitCollector {
    private final Map<JiraBytesRef, Tally> results = new HashMap<JiraBytesRef, Tally>();

    public OneDimensionalTermHitCollector(String fieldId, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache, FieldManager fieldManager) {
        super(fieldId, fieldVisibilityManager, readerCache, fieldManager);
    }

    @Override
    protected void collectIrrelevant(int docId) {
    }

    public Map<String, Integer> getResult() {
        HashMap<String, Integer> returnValue = new HashMap<String, Integer>(this.results.size());
        for (Map.Entry<JiraBytesRef, Tally> result : this.results.entrySet()) {
            String key = result.getKey() == null ? null : result.getKey().utf8ToString();
            returnValue.put(key, result.getValue().getTally());
        }
        return returnValue;
    }

    @Override
    protected void collectWithTerms(int docId, JiraBytesRef[] terms) {
        if (ArrayUtils.isEmpty((Object[])terms)) {
            this.incrementCount(null, this.results);
        } else {
            for (JiraBytesRef term : terms) {
                this.incrementCount(term, this.results);
            }
        }
    }

    private void incrementCount(JiraBytesRef key, Map<JiraBytesRef, Tally> map) {
        Tally tally = map.get(key);
        if (tally == null) {
            tally = new Tally();
            map.put(key, tally);
        }
        tally.inc();
    }

    private static class Tally {
        int tally = 0;

        private Tally() {
        }

        private Integer getTally() {
            return this.tally;
        }

        private void inc() {
            ++this.tally;
        }
    }
}

