/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.func;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.projects.pageobjects.func.page.IssuesPage;
import com.atlassian.jira.projects.pageobjects.func.page.NewSummaryPage;
import com.atlassian.jira.projects.pageobjects.func.page.PluginProvidedPage;
import com.atlassian.jira.projects.pageobjects.func.page.ReferencePluginSidebarPage;
import com.atlassian.jira.projects.pageobjects.func.page.ReportPage;
import com.atlassian.jira.projects.pageobjects.func.page.SummaryPage;
import net.sourceforge.jwebunit.WebTester;

public class World {
    private final LocatorFactory locators;
    private final Navigation navigation;
    private String projectKey;

    public World(WorldBuilder worldBuilder) {
        this.locators = worldBuilder.locators;
        this.navigation = worldBuilder.navigation;
        this.projectKey = worldBuilder.key;
    }

    public NewSummaryPage goToNewProjectSummary() {
        NewSummaryPage page = new NewSummaryPage(this.projectKey, "com.atlassian.jira.jira-projects-plugin:summary-page", this.locators);
        this.navigation.gotoPage(page.baseUrl());
        return page;
    }

    public SummaryPage gotoSummaryPage() {
        SummaryPage page = new SummaryPage(this.projectKey, "com.atlassian.jira.jira-projects-plugin:summary-panel", this.locators);
        this.navigation.gotoPage(page.baseUrl());
        return page;
    }

    public PluginProvidedPage goToRootPage() {
        PluginProvidedPage page = new PluginProvidedPage(this.projectKey, "", this.locators);
        this.navigation.gotoPage(page.baseUrl());
        return page;
    }

    public IssuesPage goToIssuesPage() {
        IssuesPage page = new IssuesPage(this.projectKey, "com.atlassian.jira.jira-projects-plugin:issues-panel", this.locators);
        this.navigation.gotoPage(page.baseUrl());
        return page;
    }

    public ReportPage goToReportPage() {
        ReportPage page = new ReportPage(this.projectKey, "com.atlassian.jira.jira-projects-plugin:report-page", this.locators);
        this.navigation.gotoPage(page.baseUrl());
        return page;
    }

    public PluginProvidedPage gotoPluginProvidedPage() {
        return this.getPluginProvidedPage("com.atlassian.jira.jira-projects-reference-plugin:plugin-provided-link-to-soy-panel");
    }

    public PluginProvidedPage gotoPluginProvidedVelocityPage() {
        return this.getPluginProvidedPage("com.atlassian.jira.jira-projects-reference-plugin:plugin-provided-link-to-velocity-panel");
    }

    public ReferencePluginSidebarPage gotoReferencePluginSidebarPage() {
        ReferencePluginSidebarPage page = new ReferencePluginSidebarPage(this.projectKey, this.locators);
        this.navigation.gotoPage(page.baseUrl());
        return page;
    }

    private PluginProvidedPage getPluginProvidedPage(String tabName) {
        PluginProvidedPage page = new PluginProvidedPage(this.projectKey, tabName, this.locators);
        this.navigation.gotoPage(page.baseUrl());
        return page;
    }

    public static WorldBuilder builder(WebTester tester, Backdoor backdoor, Navigation navigation) {
        return new WorldBuilder(tester, backdoor, navigation);
    }

    public static class WorldBuilder {
        private final LocatorFactory locators;
        private final Backdoor backdoor;
        private final Navigation navigation;
        private final WebTester tester;
        private String key;
        private String name;
        private boolean throwExceptionsOnErrorStatus;

        public WorldBuilder(WebTester tester, Backdoor backdoor, Navigation navigation) {
            this.tester = tester;
            this.locators = new LocatorFactoryImpl(tester);
            this.backdoor = backdoor;
            this.navigation = navigation;
            this.name = "A Project Name";
            this.key = "KEY";
            this.throwExceptionsOnErrorStatus = true;
        }

        public WorldBuilder withProject(String name, String key) {
            this.name = name;
            this.key = key;
            return this;
        }

        public WorldBuilder withExceptionsThrownOnErrorStatus(boolean throwExceptionsOnErrorStatus) {
            this.throwExceptionsOnErrorStatus = throwExceptionsOnErrorStatus;
            return this;
        }

        public World build() {
            this.backdoor.restoreBlankInstance();
            this.backdoor.project().addProject(this.name, this.key, "admin");
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(this.throwExceptionsOnErrorStatus);
            return new World(this);
        }
    }
}

