/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.func.rest;

import com.atlassian.jira.projects.pageobjects.func.rest.ProjectShortcutBean;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public class ShortcutsClient {
    private final Client client;
    private final JIRAEnvironmentData environmentData;
    private final String projectKey;
    private final String username;
    private final String password;

    public ShortcutsClient(JIRAEnvironmentData environmentData, String projectKey, String username, String password) {
        this.environmentData = environmentData;
        this.projectKey = projectKey;
        this.username = username;
        this.password = password;
        ClientConfig config = new ClientConfig();
        config.register(JacksonJsonProvider.class);
        this.client = ClientBuilder.newClient((Configuration)config);
        this.client.register((Object)HttpAuthenticationFeature.basicBuilder().build());
    }

    public ShortcutsClient(JIRAEnvironmentData environmentData, String projectKey) {
        this(environmentData, projectKey, "admin", "admin");
    }

    public ShortcutsClient login(String username, String password) {
        return new ShortcutsClient(this.environmentData, this.projectKey, username, password);
    }

    public ShortcutsClient anonymous() {
        return new ShortcutsClient(this.environmentData, this.projectKey, null, null);
    }

    public Response create(ProjectShortcutBean bean) {
        return this.configure(this.mainResource()).post(Entity.json((Object)bean));
    }

    public Response update(Integer id, ProjectShortcutBean bean) {
        return this.configure(this.mainResource().path(id.toString())).put(Entity.json((Object)bean));
    }

    public Response getAll() {
        return this.configure(this.mainResource()).get();
    }

    public Response get(Integer id) {
        return this.configure(this.mainResource().path(id.toString())).get();
    }

    public void delete(Integer id) {
        this.configure(this.mainResource().path(id.toString())).delete(String.class);
    }

    private Invocation.Builder configure(WebTarget resource) {
        if (this.username != null) {
            return resource.request(new String[]{"application/json"}).property("jersey.config.client.http.auth.basic.username", (Object)this.username).property("jersey.config.client.http.auth.basic.password", (Object)this.password);
        }
        return resource.request(new String[]{"application/json"});
    }

    private WebTarget mainResource() {
        return this.client.target(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("projects").path("1.0").path("project").path(this.projectKey).path("shortcut");
    }
}

