/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page;

import com.atlassian.jira.projects.pageobjects.webdriver.page.Subnavigator;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.SidebarBrowseProjectSubPage;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.inject.Inject;
import org.openqa.selenium.By;

public class ReportsPage
extends SidebarBrowseProjectSubPage {
    public static final String COMPONENTS_PAGE_KEY = "com.atlassian.jira.jira-projects-plugin:report-page";
    @ElementBy(className="reports")
    private PageElement reportsSection;
    @Inject
    private PageBinder pageBinder;

    public ReportsPage(String projectKey) {
        super(projectKey);
    }

    @Override
    public String getPageId() {
        return COMPONENTS_PAGE_KEY;
    }

    public ReportsSection getReportsSection(String categoryKey) {
        String selector = "ul[data-category-key=\"%s\"]";
        PageElement sectionElement = this.reportsSection.find(By.cssSelector((String)String.format(selector, categoryKey)));
        return (ReportsSection)this.pageBinder.bind(ReportsSection.class, new Object[]{sectionElement});
    }

    public Subnavigator getReportsSubnavigator() {
        return (Subnavigator)this.pageBinder.bind(Subnavigator.class, new Object[0]);
    }

    public static class Report {
        @Inject
        private PageBinder pageBinder;
        private final PageElement mainElement;

        public Report(PageElement mainElement) {
            this.mainElement = mainElement;
        }

        public TimedCondition isVisible() {
            return this.mainElement.timed().isVisible();
        }

        public TimedQuery<String> getDescription() {
            return this.mainElement.find(By.tagName((String)"p")).timed().getText();
        }

        public <P> P visit(Class<P> reportPageClass, Object ... args) {
            this.mainElement.find(By.tagName((String)"a")).click();
            return (P)this.pageBinder.bind(reportPageClass, args);
        }
    }

    public static class ReportsSection {
        @Inject
        private PageBinder pageBinder;
        private final PageElement sectionElement;

        public ReportsSection(PageElement sectionElement) {
            this.sectionElement = sectionElement;
        }

        public Report getReport(String reportName) {
            String xpath = "//a[text()=\"%s\" and @data-report-key]/..";
            PageElement tableRow = this.sectionElement.find(By.xpath((String)String.format(xpath, reportName)));
            return (Report)this.pageBinder.bind(Report.class, new Object[]{tableRow});
        }
    }
}

